/*
 * Decompiled with CFR 0.152.
 */
package au.org.consumerdatastandards.api.banking;

import au.org.consumerdatastandards.api.banking.models.ResponseBankingPayeeById;
import au.org.consumerdatastandards.api.banking.models.ResponseBankingPayeeList;
import au.org.consumerdatastandards.support.Endpoint;
import au.org.consumerdatastandards.support.EndpointResponse;
import au.org.consumerdatastandards.support.Param;
import au.org.consumerdatastandards.support.ParamLocation;
import au.org.consumerdatastandards.support.RequestMethod;
import au.org.consumerdatastandards.support.ResponseCode;
import au.org.consumerdatastandards.support.Section;
import au.org.consumerdatastandards.support.data.CDSDataType;
import au.org.consumerdatastandards.support.data.CustomAttribute;
import au.org.consumerdatastandards.support.data.CustomAttributes;
import au.org.consumerdatastandards.support.data.CustomDataType;

@Section(name="BankingPayees", tags={"Banking", "Payees"})
public interface BankingPayeesAPI {
    @Endpoint(path="/banking/payees/{payeeId}", summary="Get Payee Detail", description="Obtain detailed information on a single payee", requestMethod=RequestMethod.GET, operationId="getPayeeDetail", responses={@EndpointResponse(responseCode=ResponseCode.OK, description="Success", content=ResponseBankingPayeeById.class)})
    @CustomAttributes(value={@CustomAttribute(name="x-scopes", value="bank_payees", multiple=true), @CustomAttribute(name="x-version", value="1")})
    public ResponseBankingPayeeById getPayeeDetail(@Param(name="payeeId", description="The ID used to locate the details of a particular payee", in=ParamLocation.PATH) @CDSDataType(value=CustomDataType.ASCII) String var1, @Param(name="x-v", description="Version of the API end point requested by the client. Must be set to a positive integer. If the version(s) requested is not supported then the provider should respond with a 406 Not Acceptable. See [here](##request-headers)", in=ParamLocation.HEADER, reference="RequestHeader_x-v") String var2, @Param(name="x-min-v", description="Minimum version of the API end point requested by the client. Must be set to a positive integer if provided. The provider should respond with the highest supported version between [x-min-v](##request-headers) and [x-v](##request-headers). If all versions requested are not supported then the provider should respond with a 406 Not Acceptable.", in=ParamLocation.HEADER, reference="RequestHeader_x-min-v") String var3);

    @Endpoint(path="/banking/payees", summary="Get Payees", description="Obtain a list of pre-registered payees", requestMethod=RequestMethod.GET, operationId="listPayees", responses={@EndpointResponse(responseCode=ResponseCode.OK, description="Success", content=ResponseBankingPayeeList.class)})
    @CustomAttributes(value={@CustomAttribute(name="x-scopes", value="bank_basic_accounts", multiple=true), @CustomAttribute(name="x-version", value="1")})
    public ResponseBankingPayeeList listPayees(@Param(name="type", description="Filter on the payee type field.  In addition to normal type field values, ALL can be specified to retrieve all payees.  If absent the assumed value is ALL", in=ParamLocation.QUERY, defaultValue="ALL") ParamType var1, @Param(name="page", description="Page of results to request (standard pagination)", in=ParamLocation.QUERY, defaultValue="1", reference="ParamPage") @CDSDataType(value=CustomDataType.PositiveInteger) Integer var2, @Param(name="page-size", description="Page size to request. Default is 25 (standard pagination)", in=ParamLocation.QUERY, defaultValue="25", reference="ParamPageSize") @CDSDataType(value=CustomDataType.PositiveInteger) Integer var3, @Param(name="x-v", description="Version of the API end point requested by the client. Must be set to a positive integer. If the version(s) requested is not supported then the provider should respond with a 406 Not Acceptable. See [here](##request-headers)", in=ParamLocation.HEADER, reference="RequestHeader_x-v") String var4, @Param(name="x-min-v", description="Minimum version of the API end point requested by the client. Must be set to a positive integer if provided. The provider should respond with the highest supported version between [x-min-v](##request-headers) and [x-v](##request-headers). If all versions requested are not supported then the provider should respond with a 406 Not Acceptable.", in=ParamLocation.HEADER, reference="RequestHeader_x-min-v") String var5);

    public static enum ParamType {
        DOMESTIC,
        INTERNATIONAL,
        BILLER,
        ALL;

    }
}

