/*
 * Decompiled with CFR 0.152.
 */
package au.id.tmm.utilities.logging;

import au.id.tmm.utilities.logging.Logger;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Logger$
implements scala.Serializable {
    public static Logger$ MODULE$;
    private final String nullRepresentation;
    private final char quoteChar;
    private final char separatorChar;
    private final char equalityChar;
    private final char escapeChar;
    private final char[] searchChars;
    private final String[] searchStrings;
    private final String[] replacements;

    static {
        new Logger$();
    }

    public Logger apply(String name) {
        String className = new StringOps(Predef$.MODULE$.augmentString(name)).stripSuffix("$");
        org.slf4j.Logger underlying = LoggerFactory.getLogger((String)className);
        return new Logger(underlying);
    }

    public Logger apply(Class<?> cls) {
        return this.apply(cls.getName());
    }

    public Logger apply() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String callingClassName = ((StackTraceElement)((IterableLike)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stackTrace)).toStream().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$apply$1(x$1)))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$apply$2(x$2)))).head()).getClassName();
        return this.apply(callingClassName);
    }

    public String format(String eventId, Iterable<Tuple2<String, Object>> kvPairs) {
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("event_id=").append(this.escapeForFormat(eventId));
        kvPairs.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$format$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object valueObject = tuple2._2();
            String valueString = Objects.toString(valueObject, null);
            logMessage.append(MODULE$.separatorChar()).append(" ");
            logMessage.append(key).append("=");
            StringBuilder stringBuilder = logMessage.append(MODULE$.escapeForFormat(valueString));
            return stringBuilder;
        });
        return logMessage.toString();
    }

    private String nullRepresentation() {
        return this.nullRepresentation;
    }

    private char quoteChar() {
        return this.quoteChar;
    }

    private char separatorChar() {
        return this.separatorChar;
    }

    private char equalityChar() {
        return this.equalityChar;
    }

    private char escapeChar() {
        return this.escapeChar;
    }

    private char[] searchChars() {
        return this.searchChars;
    }

    private String[] searchStrings() {
        return this.searchStrings;
    }

    private String[] replacements() {
        return this.replacements;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String escapeForFormat(String value) {
        String string;
        if (value == null) {
            string = this.nullRepresentation();
            return string;
        }
        if (!StringUtils.containsAny((CharSequence)value, (CharSequence)Predef$.MODULE$.ArrayCharSequence(this.searchChars()))) {
            String string2 = value;
            String string3 = this.nullRepresentation();
            if ((string2 == null ? string3 != null : !string2.equals(string3)) && !StringUtils.containsWhitespace((CharSequence)value)) {
                string = value;
                return string;
            }
        }
        StringBuilder output = new StringBuilder();
        output.append(this.quoteChar());
        output.append(StringUtils.replaceEach((String)value, (String[])this.searchStrings(), (String[])this.replacements()));
        output.append(this.quoteChar());
        string = output.toString();
        return string;
    }

    public Logger apply(org.slf4j.Logger underlying) {
        return new Logger(underlying);
    }

    public Option<org.slf4j.Logger> unapply(Logger x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.underlying());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(StackTraceElement x$1) {
        String string = x$1.getClassName();
        String string2 = Thread.class.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(StackTraceElement x$2) {
        String string = x$2.getClassName();
        String string2 = MODULE$.getClass().getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$format$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ String $anonfun$searchStrings$1(char x$1) {
        return String.valueOf(x$1);
    }

    private Logger$() {
        MODULE$ = this;
        this.nullRepresentation = "<null>";
        this.quoteChar = (char)34;
        this.separatorChar = (char)59;
        this.equalityChar = (char)61;
        this.escapeChar = (char)92;
        this.searchChars = new char[]{this.quoteChar(), this.separatorChar(), this.equalityChar(), this.escapeChar()};
        this.searchStrings = (String[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(this.searchChars())).map((Function1 & Serializable & scala.Serializable)x$1 -> Logger$.$anonfun$searchStrings$1(BoxesRunTime.unboxToChar((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.replacements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.searchStrings())).map((Function1 & Serializable & scala.Serializable)x$4 -> "" + MODULE$.escapeChar() + x$4, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }
}

