/*
 * Decompiled with CFR 0.152.
 */
package au.id.tmm.probability.distribution.exhaustive;

import au.id.tmm.probability.distribution.ProbabilityDistributionTypeclass;
import au.id.tmm.probability.distribution.exhaustive.ProbabilityDistribution;
import au.id.tmm.probability.distribution.exhaustive.ProbabilityDistribution$;
import au.id.tmm.probability.rational.RationalProbability;
import au.id.tmm.probability.rational.RationalProbability$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.MapView;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import spire.math.Rational;
import spire.math.Rational$;

public final class ExhaustiveProbabilityDistributionInstance$
implements ProbabilityDistributionTypeclass<ProbabilityDistribution> {
    public static final ExhaustiveProbabilityDistributionInstance$ MODULE$ = new ExhaustiveProbabilityDistributionInstance$();

    static {
        ProbabilityDistributionTypeclass.$init$((ProbabilityDistributionTypeclass)MODULE$);
    }

    public Object evenly(Object head, Seq tail) {
        return ProbabilityDistributionTypeclass.evenly$((ProbabilityDistributionTypeclass)this, (Object)head, (Seq)tail);
    }

    public <A> ProbabilityDistribution<A> always(A a) {
        return new ProbabilityDistribution.Always<A>(a);
    }

    public <A, B> ProbabilityDistribution<B> tailRecM(A a, Function1<A, ProbabilityDistribution<Either<A, B>>> f) {
        ProbabilityDistribution.ProbabilityDistributionBuilder builder = new ProbabilityDistribution.ProbabilityDistributionBuilder();
        Stack workingStack = (Stack)Stack$.MODULE$.apply(((ProbabilityDistribution)f.apply(a)).asMap().toSeq());
        while (workingStack.nonEmpty()) {
            Stack stack;
            Tuple2 tuple2 = (Tuple2)workingStack.pop();
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Rational probability = ((RationalProbability)tuple2._2()).asRational();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Object b = right.value();
                    stack = builder.addOne(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(b), (Object)new RationalProbability(probability)));
                    continue;
                }
            }
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Rational probability = ((RationalProbability)tuple2._2()).asRational();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Object a2 = left.value();
                    MapView subBranch = ((ProbabilityDistribution)f.apply(a2)).asMap().mapValues((Function1 & Serializable)x$1 -> new RationalProbability(RationalProbability$.MODULE$.$times$extension(((RationalProbability)x$1).asRational(), probability)));
                    stack = workingStack.pushAll((IterableOnce)subBranch);
                    continue;
                }
            }
            throw new MatchError((Object)tuple2);
        }
        return (ProbabilityDistribution)builder.result().getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError();
        });
    }

    public <A, B> ProbabilityDistribution<B> flatMap(ProbabilityDistribution<A> aDistribution, Function1<A, ProbabilityDistribution<B>> f) {
        return aDistribution.flatMap(f);
    }

    public <A, B> ProbabilityDistribution<B> map(ProbabilityDistribution<A> aDistribution, Function1<A, B> f) {
        return aDistribution.map(f);
    }

    public <A, N> Option<ProbabilityDistribution<A>> fromWeights(Seq<Tuple2<A, N>> weightsPerElement, Numeric<N> evidence$1) {
        ProbabilityDistribution d;
        Seq seq;
        if (weightsPerElement.isEmpty()) {
            return None$.MODULE$;
        }
        if (weightsPerElement.size() == 1) {
            return new Some(new ProbabilityDistribution.Always<Object>(((Tuple2)weightsPerElement.head())._1()));
        }
        Object totalWeight = weightsPerElement.foldLeft(package$.MODULE$.Numeric().apply(evidence$1).zero(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Object acc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    acc = tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object weight = tuple2._2();
            Object object = package$.MODULE$.Numeric().apply(evidence$1).plus(acc, weight);
            return object;
        });
        Object object = totalWeight;
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            seq = (Seq)weightsPerElement.map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object a = tuple2._1();
                Object weight = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), (Object)new RationalProbability(RationalProbability$.MODULE$.makeUnsafe(Rational$.MODULE$.apply((long)BoxesRunTime.unboxToInt((Object)weight), (long)n))));
                return tuple22;
            });
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            seq = (Seq)weightsPerElement.map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object a = tuple2._1();
                Object weight = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), (Object)new RationalProbability(RationalProbability$.MODULE$.makeUnsafe(Rational$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)weight), l))));
                return tuple22;
            });
        } else if (object instanceof Rational) {
            Rational rational = (Rational)object;
            seq = (Seq)weightsPerElement.map((Function1 & Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object a = tuple2._1();
                Object weight = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), (Object)new RationalProbability(RationalProbability$.MODULE$.makeUnsafe(((Rational)weight).$div(rational))));
                return tuple22;
            });
        } else {
            double totalWeightAsDouble = package$.MODULE$.Numeric().apply(evidence$1).toDouble(totalWeight);
            seq = (Seq)weightsPerElement.map((Function1 & Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object a = tuple2._1();
                Object weight = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), (Object)new RationalProbability(RationalProbability$.MODULE$.makeUnsafe(Rational$.MODULE$.apply(package$.MODULE$.Numeric().apply(evidence$1).toDouble(weight) / totalWeightAsDouble))));
                return tuple22;
            });
        }
        Seq rationalProbabilitiesPerOutcome = seq;
        Either either = ProbabilityDistribution$.MODULE$.apply(rationalProbabilitiesPerOutcome.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ProbabilityDistribution.ConstructionError e = (ProbabilityDistribution.ConstructionError)left.value();
                throw new AssertionError((Object)e);
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        ProbabilityDistribution probabilityDistribution = d = (ProbabilityDistribution)right.value();
        ProbabilityDistribution probabilityDistribution2 = probabilityDistribution;
        return new Some((Object)probabilityDistribution2);
    }

    public <A, N> ProbabilityDistribution<A> headTailWeights(Tuple2<A, N> firstWeight, Seq<Tuple2<A, N>> otherWeights, Numeric<N> evidence$2) {
        ProbabilityDistribution distribution;
        if (otherWeights.isEmpty()) {
            return new ProbabilityDistribution.Always<Object>(firstWeight._1());
        }
        Option<ProbabilityDistribution<A>> option = this.fromWeights((Seq)otherWeights.prepended(firstWeight), evidence$2);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new AssertionError();
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        ProbabilityDistribution probabilityDistribution = distribution = (ProbabilityDistribution)some.value();
        return probabilityDistribution;
    }

    public <A> ProbabilityDistribution<A> headTailEvenly(A head, Iterable<A> tail) {
        return ProbabilityDistribution$.MODULE$.headTailEvenly(head, tail);
    }

    public <A> Option<ProbabilityDistribution<A>> allElementsEvenly(Iterable<A> iterable) {
        return ProbabilityDistribution$.MODULE$.allElementsEvenly(iterable);
    }

    private ExhaustiveProbabilityDistributionInstance$() {
    }
}

