/*
 * Decompiled with CFR 0.152.
 */
package au.gov.digitalhealth.ncts.syndication.client;

import au.gov.digitalhealth.ncts.syndication.client.DownloadResult;
import au.gov.digitalhealth.ncts.syndication.client.Entry;
import au.gov.digitalhealth.ncts.syndication.client.NctsFeedReader;
import au.gov.digitalhealth.ncts.syndication.client.NctsFileDownloader;
import au.gov.digitalhealth.ncts.syndication.client.exception.HashValidationFailureException;
import au.gov.digitalhealth.ncts.syndication.client.exception.SyndicationClientInitialisationException;
import au.gov.digitalhealth.ncts.syndication.client.exception.SyndicationFeedException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SyndicationClient {
    private static final Logger logger = Logger.getLogger(SyndicationClient.class.getName());
    public static final String TOKEN_URL = "https://api.healthterminologies.gov.au/oauth2/token";
    public static final String FEED_URL = "https://api.healthterminologies.gov.au/syndication/v1/syndication.xml";
    private URI feedUrl;
    private URI tokenUrl;
    private File outputDirectory;
    private String clientId;
    private String clientSecret;

    public SyndicationClient() {
        this(null, null, null);
        try {
            this.setOutputDirectory(File.createTempFile("NctsSyndClientDownload", ""));
        }
        catch (IOException e) {
            throw new SyndicationClientInitialisationException("Cannot create temporary file", e);
        }
    }

    public SyndicationClient(File outputDirectory) {
        this(outputDirectory, null, null);
    }

    public SyndicationClient(File outputDirectory, String clientId, String clientSecret) {
        this(FEED_URL, TOKEN_URL, outputDirectory, clientId, clientSecret);
    }

    public SyndicationClient(String feedUrl, String tokenUrl, File outputDirectory, String clientId, String clientSecret) {
        this.setFeedUrl(feedUrl);
        this.setTokenUrl(tokenUrl);
        this.setOutputDirectory(outputDirectory);
        this.setClientId(clientId);
        this.setClientSecret(clientSecret);
    }

    public Map<String, List<DownloadResult>> download(boolean latestOnly, String ... categories) throws IOException, NoSuchAlgorithmException, HashValidationFailureException {
        NctsFeedReader feedReader = new NctsFeedReader(this.feedUrl.toString());
        NctsFileDownloader downloader = new NctsFileDownloader(this.tokenUrl, this.clientId, this.clientSecret);
        Map<String, Set<Entry>> matchingEntries = feedReader.getMatchingEntries(latestOnly, categories);
        HashMap<String, List<DownloadResult>> result = new HashMap<String, List<DownloadResult>>();
        if (matchingEntries.isEmpty()) {
            logger.warning(() -> "No entries found to download for specified categories " + categories);
        } else {
            for (String category : matchingEntries.keySet()) {
                ArrayList<DownloadResult> downloads = new ArrayList<DownloadResult>();
                for (Entry entry : matchingEntries.get(category)) {
                    downloads.add(downloader.downloadEntry(entry, this.outputDirectory));
                }
                result.put(category, downloads);
            }
        }
        return result;
    }

    public Map<String, DownloadResult> downloadLatestFromCategories(String ... categories) throws NoSuchAlgorithmException, IOException, HashValidationFailureException {
        HashMap<String, DownloadResult> result = new HashMap<String, DownloadResult>();
        Map<String, List<DownloadResult>> downloadResults = this.download(true, categories);
        for (String category : downloadResults.keySet()) {
            if (downloadResults.get(category).size() != 1) {
                throw new SyndicationFeedException("Expected only 1 result for category " + category + " but encountered " + downloadResults.get(category).size());
            }
            result.put(category, downloadResults.get(category).get(0));
        }
        return result;
    }

    public DownloadResult downloadLatest(String category) throws NoSuchAlgorithmException, IOException, HashValidationFailureException {
        Map<String, DownloadResult> downloadResults = this.downloadLatestFromCategories(category);
        if (downloadResults.keySet().size() != 1 || !downloadResults.keySet().iterator().next().equals(category)) {
            throw new SyndicationFeedException("Expected only 1 category " + category + " but encountered " + downloadResults.keySet());
        }
        return downloadResults.get(category);
    }

    public URI getFeedUrl() {
        return this.feedUrl;
    }

    public SyndicationClient setFeedUrl(String feedUrl) {
        return this.setFeedUrl(URI.create(feedUrl));
    }

    public SyndicationClient setFeedUrl(URI feedUrl) {
        this.feedUrl = feedUrl;
        return this;
    }

    public URI getTokenUrl() {
        return this.tokenUrl;
    }

    public SyndicationClient setTokenUrl(String tokenUrl) {
        return this.setTokenUrl(URI.create(tokenUrl));
    }

    public SyndicationClient setTokenUrl(URI tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public SyndicationClient setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public SyndicationClient setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public SyndicationClient setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }
}

