/*
 * Decompiled with CFR 0.152.
 */
package au.gov.digitalhealth.ncts.syndication.client;

import au.gov.digitalhealth.ncts.syndication.client.DownloadResult;
import au.gov.digitalhealth.ncts.syndication.client.Entry;
import au.gov.digitalhealth.ncts.syndication.client.exception.AuthenticationException;
import au.gov.digitalhealth.ncts.syndication.client.exception.HashValidationFailureException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class NctsFileDownloader {
    private static final Logger logger = Logger.getLogger(NctsFileDownloader.class.getName());
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private String token;
    private URI tokenUrl;
    private String clientId;
    private String clientSecret;

    public NctsFileDownloader(URI tokenUrl, String clientId, String clientSecret) {
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public DownloadResult downloadEntry(Entry entry, File outputDirectory) throws IOException, NoSuchAlgorithmException, HashValidationFailureException {
        File out = this.getOutputFile(entry, outputDirectory);
        entry.setFile(out);
        if (out.exists() && out.isFile()) {
            if (!this.sha256AndLengthMatch(entry, out)) {
                logger.warning(() -> "File " + out.getAbsolutePath() + " exists for entry " + entry.getId() + " but does not match feed entry sha256 and/or length - deleting file and redownloading it.");
                if (!out.delete()) {
                    throw new IOException("Unable to delete existing cached file " + out.getAbsolutePath() + " whose sha256 doesn't match the feed. Unable to redownload the file with the corrected sha256");
                }
                this.downloadFile(entry, out);
                return new DownloadResult(out, true);
            }
            logger.info(() -> "File " + out.getAbsolutePath() + " exists for entry " + entry.getId() + " with matching sha256 and length - skipping dowload.");
            return new DownloadResult(out, false);
        }
        logger.info(() -> "File " + out.getAbsolutePath() + " does not exists for entry " + entry.getId() + " - starting download for new file.");
        this.downloadFile(entry, out);
        return new DownloadResult(out, true);
    }

    private void downloadFile(Entry entry, File out) throws NoSuchAlgorithmException, IOException, HashValidationFailureException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        HttpClientBuilder builder = HttpClients.custom();
        builder.addInterceptorFirst((request, context) -> request.addHeader("Authorization", "Bearer " + this.getBearerTokenFromAuthServer()));
        try (DigestOutputStream dos = new DigestOutputStream(new BufferedOutputStream(new FileOutputStream(out)), digest);
             CloseableHttpClient httpClient = builder.build();
             CloseableHttpResponse response = httpClient.execute(new HttpGet(entry.getUrl()));){
            int inByte;
            InputStream is = response.getEntity().getContent();
            while ((inByte = is.read()) != -1) {
                dos.write(inByte);
            }
        }
        String downloadedFileSha256 = Hex.encodeHexString(digest.digest());
        long length = out.length();
        if (!this.sha256AndLengthMatch(entry, length, downloadedFileSha256)) {
            if (!out.delete()) {
                logger.warning(() -> "Unable to delete downloaded file " + out.getAbsolutePath() + " whose sha256 doesn't match the feed.");
            }
            throw new HashValidationFailureException(out, downloadedFileSha256, length, entry.getSha256(), entry.getLength());
        }
    }

    private File getOutputFile(Entry entry, File outputDirectory) {
        String[] urlParts = entry.getUrl().split("[/]");
        String filename = urlParts[urlParts.length - 1];
        return new File(outputDirectory, filename);
    }

    private boolean sha256AndLengthMatch(Entry entry, File out) throws IOException {
        String existingSha256;
        try (FileInputStream fis = new FileInputStream(out);){
            existingSha256 = DigestUtils.sha256Hex(fis);
        }
        return this.sha256AndLengthMatch(entry, out.length(), existingSha256);
    }

    private boolean sha256AndLengthMatch(Entry entry, Long length, String existingSha256) {
        return length.longValue() == entry.getLength() && existingSha256.equals(entry.getSha256());
    }

    private String getBearerTokenFromAuthServer() {
        if (this.token == null) {
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost post = new HttpPost(this.tokenUrl);
                ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
                data.add(new BasicNameValuePair("grant_type", "client_credentials"));
                data.add(new BasicNameValuePair("client_id", this.clientId));
                data.add(new BasicNameValuePair("client_secret", this.clientSecret));
                post.addHeader("Content-Type", "application/x-www-form-urlencoded");
                post.setEntity(new UrlEncodedFormEntity(data, "utf-8"));
                HttpEntity responseEntity = client.execute(post).getEntity();
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map responseMap = (Map)this.gson.fromJson(EntityUtils.toString(responseEntity), type);
                this.token = (String)responseMap.get("access_token");
            }
            catch (IOException e) {
                throw new AuthenticationException("Could not get token from authentication server", e);
            }
        }
        return this.token;
    }
}

