/*
 * Decompiled with CFR 0.152.
 */
package au.gov.digitalhealth.ncts.syndication.client;

import au.gov.digitalhealth.ncts.syndication.client.Entry;
import au.gov.digitalhealth.ncts.syndication.client.NctsEntryVersionComparator;
import au.gov.digitalhealth.ncts.syndication.client.exception.SyndicationFeedException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class NctsFeedReader {
    static final String SNOMED_VERSION_REGEXP = "http://snomed.info/sct/(\\d+)/version/(\\d+)";
    private static final Logger logger = Logger.getLogger(NctsFeedReader.class.getName());
    private static final Namespace NCTS_NAMESPACE = Namespace.getNamespace("http://ns.electronichealth.net.au/ncts/syndication/asf/extensions/1.0.0");
    private static final Namespace ATOM_NAMESPACE = Namespace.getNamespace("http://www.w3.org/2005/Atom");
    private Map<String, Set<Entry>> entries = new HashMap<String, Set<Entry>>();

    public NctsFeedReader(String feedUrl) throws IOException {
        logger.info(() -> "Initialising NctsFeedReader from feed " + feedUrl);
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = null;
        try {
            doc = saxBuilder.build(feedUrl);
        }
        catch (JDOMException e) {
            throw new SyndicationFeedException("Cannot parse syndication feed", e);
        }
        Element rootElement = doc.getRootElement();
        List<Element> feedEntries = rootElement.getChildren("entry", ATOM_NAMESPACE);
        for (Element entryElement : feedEntries) {
            List<Element> entryCategoryElements = entryElement.getChildren("category", ATOM_NAMESPACE);
            String id = entryElement.getChildText("id", ATOM_NAMESPACE);
            if (entryCategoryElements.size() != 1) {
                throw new SyndicationFeedException("Entry " + id + " doesn't have exactly one category");
            }
            Element entryCategoryElement = entryCategoryElements.iterator().next();
            Element link = this.getLink(entryElement);
            Entry entry = new Entry(id, link.getAttributeValue("sha256Hash", NCTS_NAMESPACE), link.getAttributeValue("href"), Long.parseLong(link.getAttributeValue("length")), entryElement.getChildText("contentItemIdentifier", NCTS_NAMESPACE), entryElement.getChildText("contentItemVersion", NCTS_NAMESPACE), entryCategoryElement.getAttributeValue("term"), entryCategoryElement.getAttributeValue("scheme"));
            this.addEntry(entry);
        }
        logger.info(() -> "Feed " + feedUrl + " successfully read");
        this.entries.keySet().forEach(c -> logger.info("Category " + c + " has " + this.entries.get(c).size() + " entries"));
    }

    public Entry getLatestMatchingEntry(String category) {
        return this.getMatchingEntries(true, category).get(category).iterator().next();
    }

    public Set<Entry> getMatchingEntries(String category) {
        return Collections.unmodifiableSet(this.entries.get(category));
    }

    public Map<String, Set<Entry>> getMatchingEntries(boolean latestOnly, String ... categories) {
        HashMap<String, Set<Entry>> matchingEntries = new HashMap<String, Set<Entry>>();
        HashSet<String> categorySet = new HashSet<String>(Arrays.asList(categories));
        for (String category : this.entries.keySet()) {
            if (!categorySet.contains(category)) continue;
            HashSet<Entry> set = new HashSet<Entry>();
            set.addAll((Collection)this.entries.get(category));
            if (latestOnly) {
                set.retainAll(Arrays.asList(this.getLatestEntry(set)));
            }
            matchingEntries.put(category, set);
        }
        return matchingEntries;
    }

    private Entry getLatestEntry(HashSet<Entry> set) {
        return set.stream().max(new NctsEntryVersionComparator()).orElseThrow(() -> new SyndicationFeedException("No latest entry for set " + set));
    }

    private Element getLink(Element entry) {
        List<Element> links = entry.getChildren("link", ATOM_NAMESPACE);
        if (links.size() != 1) {
            throw new SyndicationFeedException("Entry " + entry.getChild("id", ATOM_NAMESPACE) + " does not have exactly one link");
        }
        return links.iterator().next();
    }

    private void addEntry(Entry entry) {
        Set<Entry> cachedEntries = this.entries.get(entry.getCategory());
        if (cachedEntries == null) {
            cachedEntries = new HashSet<Entry>();
            this.entries.put(entry.getCategory(), cachedEntries);
        }
        if (cachedEntries.contains(entry)) {
            throw new SyndicationFeedException("Feed contains duplicate entries for ID " + entry.getId());
        }
        cachedEntries.add(entry);
    }
}

