/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.core.benchmark;

import au.csiro.ontology.util.Statistics;
import au.csiro.snorocket.owlapi.SnorocketReasonerFactory;
import java.io.File;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OWLBenchmark {
    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
        OWLOntology root = null;
        try {
            root = man.loadOntologyFromOntologyDocument(new File("C:\\dev\\ontologies\\owl\\snomed_20130131_stated.owl"));
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("owl-api loading: " + (System.currentTimeMillis() - start));
        SnorocketReasonerFactory reasonerFactory = new SnorocketReasonerFactory();
        OWLReasoner reasoner = reasonerFactory.createNonBufferingReasoner(root);
        reasoner.precomputeInferences(new InferenceType[]{InferenceType.CLASS_HIERARCHY});
        reasoner.dispose();
        System.out.println(Statistics.INSTANCE.getStatistics());
        System.out.println("Total time: " + Statistics.INSTANCE.getTotalTime());
    }
}

