/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.examples;

import au.csiro.ontology.Factory;
import au.csiro.ontology.Node;
import au.csiro.ontology.Ontology;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.Concept;
import au.csiro.snorocket.core.SnorocketReasoner;
import au.csiro.snorocket.core.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;

public class Demo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        System.out.println("Loading base state from classifier_uuid.state");
        SnorocketReasoner reasoner = SnorocketReasoner.load((InputStream)this.getClass().getResourceAsStream("/classifier_uuid.state"));
        System.out.println("Loading uuid description map");
        HashMap<String, String> sctToUuidMap = new HashMap<String, String>();
        HashMap<String, String> uuidToDescMap = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/nid_sctid_uuid_map.txt"), "UTF8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split("[,]");
                String desc = null;
                desc = parts.length < 4 ? "" : parts[3];
                if (parts[1].equals("NA")) continue;
                sctToUuidMap.put(parts[1], parts[2]);
                uuidToDescMap.put(parts[2], desc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        System.out.println("Adding test axiom");
        Factory f = new Factory();
        String newId = UUID.randomUUID().toString();
        uuidToDescMap.put(newId, "Special Appendicits");
        Concept specialAppendicitis = Factory.createNamedConcept((String)newId);
        String appendicitsUuid = "55450fab-6786-394d-89f9-a0fd44bd7e7e";
        Concept appendicitis = Factory.createNamedConcept((String)appendicitsUuid);
        Axiom a1 = Factory.createConceptInclusion((Concept)specialAppendicitis, (Concept)appendicitis);
        HashSet<Axiom> axioms = new HashSet<Axiom>();
        axioms.add(a1);
        System.out.println("Classifying incrementally");
        reasoner.loadAxioms(axioms);
        reasoner.classify();
        System.out.println("Retrieving taxonomy");
        Ontology ont = reasoner.getClassifiedOntology();
        Node specialAppendicitisNode = (Node)ont.getNodeMap().get(appendicitsUuid);
        Utils.printTaxonomy((Node)((Node)specialAppendicitisNode.getParents().iterator().next()), (Node)ont.getBottomNode(), uuidToDescMap);
    }

    public static void main(String[] args) {
        Demo d = new Demo();
        d.start();
    }
}

