/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.examples;

import au.csiro.ontology.Factory;
import au.csiro.ontology.Node;
import au.csiro.ontology.Ontology;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.Concept;
import au.csiro.ontology.model.Role;
import au.csiro.snorocket.core.SnorocketReasoner;
import java.util.HashSet;
import java.util.Set;

public class LegoExample {
    public static void main(String[] args) {
        System.out.println("Running Chest Pain Lego Example");
        SnorocketReasoner reasoner = new SnorocketReasoner();
        HashSet<Axiom> axioms = new HashSet<Axiom>();
        Factory f = new Factory();
        Concept nonCardiacChestPain = Factory.createNamedConcept((String)"274668005");
        Concept duringExcersice = Factory.createNamedConcept((String)"309604004");
        Concept interview = Factory.createNamedConcept((String)"108217004");
        Concept present = Factory.createNamedConcept((String)"52101004");
        Role associatedWith = Factory.createNamedRole((String)"47429007");
        Concept historyCardioStandardNonAnginalChestPainExertion = Factory.createNamedConcept((String)"pce_24220");
        Concept[] conceptArray = new Concept[2];
        conceptArray[0] = nonCardiacChestPain;
        conceptArray[1] = Factory.createExistential((Role)associatedWith, (Concept)duringExcersice);
        axioms.add(Factory.createConceptInclusion((Concept)historyCardioStandardNonAnginalChestPainExertion, (Concept)Factory.createConjunction((Concept[])conceptArray)));
        axioms.add(Factory.createConceptInclusion((Concept)historyCardioStandardNonAnginalChestPainExertion, (Concept)interview));
        axioms.add(Factory.createConceptInclusion((Concept)historyCardioStandardNonAnginalChestPainExertion, (Concept)present));
        reasoner.loadAxioms(axioms);
        reasoner.classify();
        Ontology t = reasoner.getClassifiedOntology();
        Node newNode = t.getNode("pce_24220");
        System.out.println("Node for HISTORY_CARDIO_Standard_Non_Anginal_Chest_Pain_Exertion:\n  " + newNode.getEquivalentConcepts());
        Set parentNodes = newNode.getParents();
        System.out.println("Parents:");
        for (Node parentNode : parentNodes) {
            System.out.println("  " + parentNode.getEquivalentConcepts());
        }
        Set childNodes = newNode.getChildren();
        System.out.println("Children:");
        for (Node childNode : childNodes) {
            System.out.println("  " + childNode.getEquivalentConcepts());
        }
    }
}

