/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.snorocket.examples;

import au.csiro.ontology.Factory;
import au.csiro.ontology.Node;
import au.csiro.ontology.Ontology;
import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.Concept;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.Role;
import au.csiro.snorocket.core.SnorocketReasoner;
import java.util.HashSet;
import java.util.Set;

public class APIExample {
    public static void main(String[] args) {
        Concept heartInflammation;
        System.out.println("Running Snorocket API Example");
        SnorocketReasoner reasoner = new SnorocketReasoner();
        HashSet<Axiom> baseAxioms = new HashSet<Axiom>();
        Factory f = new Factory();
        Concept endocardium = Factory.createNamedConcept((String)"Endocardium");
        Concept tissue = Factory.createNamedConcept((String)"Tissue");
        Concept heartWall = Factory.createNamedConcept((String)"HeartWall");
        Concept heartValve = Factory.createNamedConcept((String)"HeartValve");
        Concept bodyWall = Factory.createNamedConcept((String)"BodyWall");
        Concept heart = Factory.createNamedConcept((String)"Heart");
        Concept bodyValve = Factory.createNamedConcept((String)"BodyValve");
        Concept endocarditis = Factory.createNamedConcept((String)"Endocarditis");
        Concept inflammation = Factory.createNamedConcept((String)"Inflammation");
        Concept disease = Factory.createNamedConcept((String)"Disease");
        Concept heartDisease = Factory.createNamedConcept((String)"HeartDisease");
        Concept criticalDisease = Factory.createNamedConcept((String)"CriticalDisease");
        Role actsOn = Factory.createNamedRole((String)"acts-on");
        Role partOf = Factory.createNamedRole((String)"part-of");
        Role contIn = Factory.createNamedRole((String)"cont-in");
        Role hasLoc = Factory.createNamedRole((String)"has-loc");
        Concept lhs = endocardium;
        Concept[] conceptArray = new Concept[3];
        conceptArray[0] = tissue;
        conceptArray[1] = Factory.createExistential((Role)((NamedRole)contIn), (Concept)heartWall);
        conceptArray[2] = Factory.createExistential((Role)((NamedRole)contIn), (Concept)heartValve);
        Concept rhs = Factory.createConjunction((Concept[])conceptArray);
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = heartWall;
        Concept[] conceptArray2 = new Concept[2];
        conceptArray2[0] = bodyWall;
        conceptArray2[1] = Factory.createExistential((Role)((NamedRole)partOf), (Concept)heart);
        rhs = Factory.createConjunction((Concept[])conceptArray2);
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = heartValve;
        Concept[] conceptArray3 = new Concept[2];
        conceptArray3[0] = bodyValve;
        conceptArray3[1] = Factory.createExistential((Role)((NamedRole)partOf), (Concept)heart);
        rhs = Factory.createConjunction((Concept[])conceptArray3);
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = endocarditis;
        Concept[] conceptArray4 = new Concept[2];
        conceptArray4[0] = inflammation;
        conceptArray4[1] = Factory.createExistential((Role)((NamedRole)hasLoc), (Concept)endocardium);
        rhs = Factory.createConjunction((Concept[])conceptArray4);
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = inflammation;
        Concept[] conceptArray5 = new Concept[2];
        conceptArray5[0] = disease;
        conceptArray5[1] = Factory.createExistential((Role)actsOn, (Concept)tissue);
        rhs = Factory.createConjunction((Concept[])conceptArray5);
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        Concept[] conceptArray6 = new Concept[2];
        conceptArray6[0] = heartDisease;
        conceptArray6[1] = Factory.createExistential((Role)hasLoc, (Concept)heartValve);
        lhs = Factory.createConjunction((Concept[])conceptArray6);
        rhs = criticalDisease;
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = heartDisease;
        Concept[] conceptArray7 = new Concept[2];
        conceptArray7[0] = disease;
        conceptArray7[1] = Factory.createExistential((Role)hasLoc, (Concept)heart);
        rhs = Factory.createConjunction((Concept[])conceptArray7);
        baseAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        baseAxioms.add(Factory.createConceptInclusion((Concept)rhs, (Concept)lhs));
        Role[] rlhs = new Role[]{partOf, partOf};
        Role rrhs = partOf;
        baseAxioms.add(Factory.createRoleInclusion((Role[])rlhs, (Role)rrhs));
        rlhs = new Role[]{partOf};
        rrhs = contIn;
        baseAxioms.add(Factory.createRoleInclusion((Role[])rlhs, (Role)rrhs));
        rlhs = new Role[]{hasLoc, contIn};
        rrhs = hasLoc;
        baseAxioms.add(Factory.createRoleInclusion((Role[])rlhs, (Role)rrhs));
        reasoner.loadAxioms(baseAxioms);
        reasoner.classify();
        Ontology t = reasoner.getClassifiedOntology();
        Node endocarditisNode = t.getNode("Endocarditis");
        System.out.println("Node for endocarditis:\n  " + endocarditisNode.getEquivalentConcepts());
        Set parentNodes = endocarditisNode.getParents();
        System.out.println("Parents of endocarditis:");
        for (Node parentNode : parentNodes) {
            System.out.println("  " + parentNode.getEquivalentConcepts());
        }
        HashSet<Axiom> additionalAxioms = new HashSet<Axiom>();
        lhs = heartInflammation = Factory.createNamedConcept((String)"HeartInflammation");
        rhs = inflammation;
        additionalAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        lhs = endocarditis;
        Concept[] conceptArray8 = new Concept[2];
        conceptArray8[0] = heartInflammation;
        conceptArray8[1] = Factory.createExistential((Role)hasLoc, (Concept)endocardium);
        rhs = Factory.createConjunction((Concept[])conceptArray8);
        additionalAxioms.add(Factory.createConceptInclusion((Concept)lhs, (Concept)rhs));
        System.out.println("Running incremental classification:");
        reasoner.loadAxioms(additionalAxioms);
        reasoner.classify();
        t = reasoner.getClassifiedOntology();
        endocarditisNode = t.getNode("Endocarditis");
        System.out.println("Node for endocarditis:\n  " + endocarditisNode.getEquivalentConcepts());
        parentNodes = endocarditisNode.getParents();
        System.out.println("Parents of endocarditis:");
        for (Node parentNode : parentNodes) {
            System.out.println("  " + parentNode.getEquivalentConcepts());
        }
    }
}

