/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.snomed.refset.rf2;

import au.csiro.ontology.input.MapView;
import au.csiro.ontology.input.StructuredLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModuleDependency
implements MapView {
    protected final String id;
    protected final String version;
    protected final Set<ModuleDependency> dependencies = new HashSet<ModuleDependency>();

    public ModuleDependency(String id, String version) {
        if (id == null) {
            throw new IllegalArgumentException("Module id cannot be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Module version cannot be null");
        }
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Collection<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDependency other = (ModuleDependency)obj;
        return this.id.equals(other.id) && this.version.equals(other.version);
    }

    public String toString() {
        return StructuredLog.renderMap(this.toMap());
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "ModuleDependency");
        map.put("id", this.id);
        map.put("version", this.version);
        map.put("dependencies", this.dependencies);
        return map;
    }
}

