/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.snomed.refset.rf2;

import au.csiro.ontology.snomed.refset.rf2.IModuleDependencyRefset;
import au.csiro.ontology.snomed.refset.rf2.ModuleDependency;
import au.csiro.ontology.snomed.refset.rf2.ModuleDependencyRow;
import au.csiro.ontology.snomed.refset.rf2.Refset;
import au.csiro.ontology.snomed.refset.rf2.ValidationException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDependencyRefset
extends Refset
implements IModuleDependencyRefset {
    private static final Logger log = LoggerFactory.getLogger(ModuleDependencyRefset.class);
    protected final Map<String, Map<String, ModuleDependency>> dependencies = new HashMap<String, Map<String, ModuleDependency>>();

    public ModuleDependencyRefset(Set<ModuleDependencyRow> members, boolean validate) throws ValidationException {
        this.id = "900000000000534007";
        ArrayList<String> problems = new ArrayList<String>();
        HashMap<M, Set<M>> index = new HashMap<M, Set<M>>();
        for (ModuleDependencyRow member : members) {
            String message;
            M version = new M(member.getModuleId(), member.getSourceEffectiveTime());
            M requiredModule = new M(member.getReferencedComponentId(), member.getTargetEffectiveTime());
            if (!member.isActive()) {
                message = "Inactive dependency: " + version + " to\t" + requiredModule;
                log.info(message);
                continue;
            }
            if (member.isMalformed()) {
                message = "Ignoring malformed MDRS entry: " + version + " to\t" + requiredModule;
                problems.add(message);
                log.warn(message);
                continue;
            }
            HashSet<M> vals = (HashSet<M>)index.get(version);
            if (vals == null) {
                vals = new HashSet<M>();
                index.put(version, vals);
            }
            vals.add(requiredModule);
        }
        if (validate && !problems.isEmpty()) {
            throw new ValidationException("Malformed Module Dependency Reference Set", problems);
        }
        if (log.isTraceEnabled()) {
            for (M version : new TreeSet(index.keySet())) {
                log.trace("MDRS entry for version: " + version);
            }
        }
        ModuleDependencyRefset.tc(index);
        for (M version : index.keySet()) {
            String srcId = version.module;
            String srcVer = version.time;
            ModuleDependency md = this.createDependency(version, index);
            Map<String, ModuleDependency> verDepMap = this.dependencies.get(srcId);
            if (verDepMap == null) {
                verDepMap = new HashMap<String, ModuleDependency>();
                this.dependencies.put(srcId, verDepMap);
            }
            verDepMap.put(srcVer, md);
        }
    }

    private static void tc(Map<M, Set<M>> index) {
        TreeSet<String> warnings = new TreeSet<String>();
        for (Map.Entry<M, Set<M>> entry : index.entrySet()) {
            M src = entry.getKey();
            Set<M> dependents = entry.getValue();
            LinkedList<M> queue = new LinkedList<M>(dependents);
            while (!queue.isEmpty()) {
                M key = (M)queue.poll();
                if (!index.containsKey(key)) continue;
                for (M addition : index.get(key)) {
                    if (dependents.contains(addition)) continue;
                    dependents.add(addition);
                    queue.add(addition);
                    warnings.add("Added implied transitive dependency from " + src + " to " + addition + " via " + key);
                }
            }
        }
        for (String warning : warnings) {
            log.warn(warning);
        }
    }

    private ModuleDependency createDependency(M version, Map<M, Set<M>> index) {
        return this.createDependency(new HashSet<ModuleDependency>(), version, index);
    }

    private ModuleDependency createDependency(Collection<ModuleDependency> all, M version, Map<M, Set<M>> index) {
        ModuleDependency md = new ModuleDependency(version.module, version.time);
        if (all.contains(md)) {
            log.warn("Ignoring cyclic dependency for " + md);
            return null;
        }
        all.add(md);
        Set<M> deps = index.get(version);
        if (deps != null) {
            for (M dep : deps) {
                ModuleDependency childMd = this.createDependency(all, dep, index);
                if (null == childMd) continue;
                md.getDependencies().add(childMd);
            }
        }
        all.remove(md);
        return md;
    }

    @Override
    public Map<String, Map<String, ModuleDependency>> getModuleDependencies() {
        return this.dependencies;
    }

    static Date parseTime(String time) {
        SimpleDateFormat ddf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        try {
            return ddf.parse(time);
        }
        catch (ParseException e1) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                return sdf.parse(time);
            }
            catch (ParseException e2) {
                String message = "Could not parse effectiveTime: " + time;
                log.error(message, (Throwable)e2);
                throw new RuntimeException(message, e2);
            }
        }
    }

    private static final class M
    implements Comparable<M> {
        private final String module;
        private final String time;

        M(String module, String time) {
            assert (null != module);
            assert (null != time);
            this.module = module;
            this.time = time;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.module.hashCode();
            result = 31 * result + this.time.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            M other = (M)obj;
            return this.module.equals(other.module) && this.time.equals(other.time);
        }

        public String toString() {
            return this.module + "/" + this.time;
        }

        @Override
        public int compareTo(M other) {
            int mCmp = this.module.compareTo(other.module);
            if (mCmp == 0) {
                return ModuleDependencyRefset.parseTime(this.time).compareTo(ModuleDependencyRefset.parseTime(other.time));
            }
            return mCmp;
        }
    }
}

