/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.model;

import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.ConceptInclusion;
import au.csiro.ontology.model.Role;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RoleInclusion
extends Axiom {
    protected Role[] lhs;
    protected Role rhs;

    public RoleInclusion() {
    }

    public RoleInclusion(Role[] lhs, Role rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public RoleInclusion(Role lhs, Role rhs) {
        this.lhs = new Role[]{lhs};
        this.rhs = rhs;
    }

    public Role[] getLhs() {
        return this.lhs;
    }

    public void setLhs(Role[] lhs) {
        this.lhs = lhs;
    }

    public Role getRhs() {
        return this.rhs;
    }

    public void setRhs(Role rhs) {
        this.rhs = rhs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lhs[0]);
        for (int i = 1; i < this.lhs.length; ++i) {
            sb.append(" o ");
            sb.append(this.lhs[i]);
        }
        sb.append(" \u2291 ");
        sb.append(this.rhs);
        return sb.toString();
    }

    @Override
    public int compareTo(Axiom o) {
        if (o instanceof ConceptInclusion) {
            return 1;
        }
        if (o instanceof RoleInclusion) {
            RoleInclusion otherRi = (RoleInclusion)o;
            int lhsRes = 0;
            Object[] oLhs = otherRi.getLhs();
            if (!Arrays.equals(this.lhs, oLhs)) {
                if (this.lhs.length < oLhs.length) {
                    lhsRes = -1;
                } else if (this.lhs.length > oLhs.length) {
                    lhsRes = 1;
                } else {
                    for (int i = 0; i < this.lhs.length; ++i) {
                        int res = this.lhs[i].compareTo(oLhs[i]);
                        if (res < 0) {
                            lhsRes = -1;
                            break;
                        }
                        if (res <= 0) continue;
                        lhsRes = 1;
                        break;
                    }
                }
            }
            int rhsRes = this.rhs.compareTo(otherRi.getRhs());
            if (lhsRes == 0 && rhsRes == 0) {
                return 0;
            }
            if (lhsRes != 0) {
                return lhsRes;
            }
            return rhsRes;
        }
        return -1;
    }
}

