/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.ontology.util;

import au.csiro.ontology.model.Axiom;
import au.csiro.ontology.model.BigIntegerLiteral;
import au.csiro.ontology.model.BooleanLiteral;
import au.csiro.ontology.model.Concept;
import au.csiro.ontology.model.ConceptInclusion;
import au.csiro.ontology.model.Conjunction;
import au.csiro.ontology.model.Datatype;
import au.csiro.ontology.model.DateLiteral;
import au.csiro.ontology.model.DecimalLiteral;
import au.csiro.ontology.model.DoubleLiteral;
import au.csiro.ontology.model.Existential;
import au.csiro.ontology.model.FloatLiteral;
import au.csiro.ontology.model.IntegerLiteral;
import au.csiro.ontology.model.Literal;
import au.csiro.ontology.model.LongLiteral;
import au.csiro.ontology.model.NamedConcept;
import au.csiro.ontology.model.NamedFeature;
import au.csiro.ontology.model.NamedRole;
import au.csiro.ontology.model.RoleInclusion;
import au.csiro.ontology.model.StringLiteral;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class AxiomUtils {
    private static final Logger log = Logger.getLogger(AxiomUtils.class);
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;

    private static void init() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ConceptInclusion.class, RoleInclusion.class, NamedConcept.class, Conjunction.class, Existential.class, Datatype.class, NamedFeature.class, NamedRole.class, IntegerLiteral.class, StringLiteral.class, LongLiteral.class, DateLiteral.class, DecimalLiteral.class, BigIntegerLiteral.class, FloatLiteral.class, DoubleLiteral.class, BooleanLiteral.class});
            marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            unmarshaller = jc.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        }
        catch (JAXBException e) {
            log.error((Object)"There was a problem initialising JAXB.", (Throwable)e);
        }
    }

    public static String serialiseConcept(Concept concept) {
        if (marshaller == null) {
            AxiomUtils.init();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal((Object)concept, (OutputStream)baos);
            return baos.toString("UTF8");
        }
        catch (JAXBException e) {
            log.error((Object)"There was a problem serialising a concept. JAXB threw an exception.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"There was a problem serialising a concept. The UTF8 encoding is not supported.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Concept deserialiseConcept(String s) {
        if (unmarshaller == null) {
            AxiomUtils.init();
        }
        try {
            Object res = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(s.getBytes()));
            return (Concept)res;
        }
        catch (JAXBException e) {
            log.error((Object)"There was a problem deserialising a concept. JAXB threw an exception.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String serialiseLiteral(Literal l) {
        if (marshaller == null) {
            AxiomUtils.init();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal((Object)l, (OutputStream)baos);
            return baos.toString("UTF8");
        }
        catch (JAXBException e) {
            log.error((Object)"There was a problem serialising a concept. JAXB threw an exception.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"There was a problem serialising a concept. The UTF8 encoding is not supported.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String serialise(Axiom axiom) {
        if (marshaller == null) {
            AxiomUtils.init();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal((Object)axiom, (OutputStream)baos);
            return baos.toString("UTF8");
        }
        catch (JAXBException e) {
            log.error((Object)"There was a problem serialising an axiom. JAXB threw an exception.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"There was a problem serialising an axiom. The UTF8 encoding is not supported.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Axiom deserialise(String s) {
        if (unmarshaller == null) {
            AxiomUtils.init();
        }
        try {
            Object res = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(s.getBytes()));
            return (Axiom)res;
        }
        catch (JAXBException e) {
            log.error((Object)"There was a problem deserialising an axiom. JAXB threw an exception.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

