/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.scheduler;

import com.skytix.velocity.VelocityTaskException;
import com.skytix.velocity.entities.VelocityTask;
import com.skytix.velocity.repository.TaskRepository;
import java.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSubscriber
implements Flow.Subscriber<VelocityTask> {
    private static final Logger log = LoggerFactory.getLogger(TaskSubscriber.class);
    private final TaskRepository<VelocityTask> mTaskRepository;
    private Flow.Subscription mSubscription;

    public TaskSubscriber(TaskRepository<VelocityTask> aTaskRepository) {
        this.mTaskRepository = aTaskRepository;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.mSubscription = subscription;
        this.mSubscription.request(1L);
    }

    @Override
    public void onNext(VelocityTask item) {
        try {
            this.mTaskRepository.queueTask(item);
        }
        catch (VelocityTaskException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.mSubscription.request(1L);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
    }

    @Override
    public void onComplete() {
    }
}

