/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.scheduler;

import com.skytix.velocity.entities.VelocityTask;
import com.skytix.velocity.repository.TaskRepository;
import com.skytix.velocity.scheduler.SchedulerRemoteProvider;
import com.skytix.velocity.scheduler.VelocityTaskRemote;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Flow;
import org.apache.mesos.v1.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferSubscriber
implements Flow.Subscriber<Protos.Offer> {
    private static final Logger log = LoggerFactory.getLogger(OfferSubscriber.class);
    private final TaskRepository<VelocityTask> mTaskRepository;
    private final SchedulerRemoteProvider mRemote;
    private final MeterRegistry mMeterRegistry;
    private Flow.Subscription mSubscription;

    public OfferSubscriber(TaskRepository<VelocityTask> aTaskRepository, SchedulerRemoteProvider aRemote, MeterRegistry aMeterRegistry) {
        this.mTaskRepository = aTaskRepository;
        this.mRemote = aRemote;
        this.mMeterRegistry = aMeterRegistry;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.mSubscription = subscription;
        this.mSubscription.request(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(Protos.Offer offer) {
        try {
            Protos.OfferID offerId = offer.getId();
            if (this.isAvailable(offer)) {
                List<Protos.TaskInfo.Builder> matchingTasks = this.mTaskRepository.getMatchingWaitingTasks(offer);
                if (matchingTasks.size() > 0) {
                    Protos.Offer.Operation.Builder operation = this.buildLaunchOperation(offer, matchingTasks);
                    List infoList = operation.getLaunch().getTaskInfosList();
                    int numTasks = infoList.size();
                    this.mMeterRegistry.counter("velocity.counter.scheduler.offerTasksLaunched", new String[0]).increment((double)numTasks);
                    this.mTaskRepository.launchTasks(infoList);
                    for (Protos.TaskInfo taskInfo : infoList) {
                        VelocityTask task = this.mTaskRepository.getTaskByTaskId(taskInfo.getTaskId().getValue());
                        if (task == null) continue;
                        task.setState(Protos.TaskState.TASK_STAGING);
                        task.setRemote(VelocityTaskRemote.builder().schedulerRemote(this.mRemote).agentID(taskInfo.getAgentId()).taskID(taskInfo.getTaskId()).build());
                    }
                    this.mRemote.get().accept(Collections.singletonList(offer.getId()), Collections.singletonList(operation.build()));
                } else {
                    this.mRemote.get().decline(Collections.singletonList(offerId));
                }
            } else {
                this.mRemote.get().decline(Collections.singletonList(offerId));
            }
        }
        catch (Exception aE) {
            log.error(aE.getMessage(), (Throwable)aE);
        }
        finally {
            this.mSubscription.request(1L);
        }
    }

    @Override
    public void onError(Throwable throwable) {
    }

    @Override
    public void onComplete() {
    }

    private boolean isAvailable(Protos.Offer aOffer) {
        Protos.Unavailability unavailabilityInfo = aOffer.getUnavailability();
        if (unavailabilityInfo.isInitialized()) {
            LocalDateTime now = LocalDateTime.now();
            Protos.TimeInfo startInfo = unavailabilityInfo.getStart();
            if (startInfo.isInitialized()) {
                LocalDateTime start = LocalDateTime.from(Instant.ofEpochMilli(startInfo.getNanoseconds() / 1000000L));
                Protos.DurationInfo durationInfo = unavailabilityInfo.getDuration();
                if (durationInfo != null && durationInfo.isInitialized()) {
                    Duration duration = Duration.of(durationInfo.getNanoseconds(), ChronoUnit.NANOS);
                    LocalDateTime end = start.plus(duration);
                    return now.isBefore(start) || now.isAfter(end) || now.isEqual(end);
                }
                return now.isBefore(start);
            }
            return true;
        }
        return true;
    }

    private Protos.Offer.Operation.Builder buildLaunchOperation(Protos.Offer aOffer, List<Protos.TaskInfo.Builder> aTasks) {
        Protos.Offer.Operation.Launch.Builder launch = Protos.Offer.Operation.Launch.newBuilder();
        for (Protos.TaskInfo.Builder taskInfo : aTasks) {
            launch.addTaskInfos(taskInfo.setAgentId(aOffer.getAgentId()));
        }
        return Protos.Offer.Operation.newBuilder().setType(Protos.Offer.Operation.Type.LAUNCH).setLaunch(launch);
    }
}

