/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.schedulerclient;

import com.skytix.schedulerclient.LeaderResolver;
import com.skytix.schedulerclient.NoLeaderException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLeaderResolver
implements LeaderResolver {
    private static final Logger log = LoggerFactory.getLogger(HttpLeaderResolver.class);
    private final String mMesosPath;
    private final HttpClient mHttpClient = HttpClient.newHttpClient();

    public HttpLeaderResolver(String aMesosPath) {
        this.mMesosPath = aMesosPath;
    }

    @Override
    public String resolveLeader() throws NoLeaderException {
        try {
            URI uri = new URI(String.format("%s/redirect", this.mMesosPath));
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<String> response = this.mHttpClient.send(request, HttpResponse.BodyHandlers.ofString());
            switch (response.statusCode()) {
                case 307: {
                    Optional<String> location = response.headers().firstValue("Location");
                    if (location.isPresent()) {
                        String url = String.format("%s:%s", uri.getScheme(), location.get());
                        log.info(String.format("Discovered Mesos master node at: %s", url));
                        return url;
                    }
                    throw new NoLeaderException("Unable to find master in missing Location header");
                }
                case 503: {
                    throw new NoLeaderException("An elected Mesos master node cannot be found");
                }
            }
            throw new NoLeaderException("Unable to determine the current leader");
        }
        catch (IOException | InterruptedException | URISyntaxException aE) {
            throw new NoLeaderException(aE);
        }
    }
}

