/*
 * Decompiled with CFR 0.152.
 */
package au.com.permeance.liferay.clojure;

import au.com.permeance.liferay.clojure.CallUnderClassLoader;
import au.com.permeance.liferay.clojure.ClojureScriptingCallable;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClojureScriptingExecutor
extends BaseScriptingExecutor {
    private static final String LANGUAGE = "clojure";
    private static final Log LOG = LogFactoryUtil.getLog(ClojureScriptingExecutor.class);
    private final transient ClassLoader hookClassLoader;

    public ClojureScriptingExecutor() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClojureScriptingExecutor(ClassLoader hookClassLoader) {
        this.hookClassLoader = hookClassLoader;
    }

    public final Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        if (allowedClasses != null && !allowedClasses.isEmpty()) {
            throw new ExecutionException("Constrained execution not supported for Clojure");
        }
        Callable callable = this.createCallableForScript(inputObjects, outputNames, script);
        return (Map)this.callAndWrapException(callable);
    }

    public final String getLanguage() {
        return LANGUAGE;
    }

    protected final Callable<Map<String, Object>> createCallableForScript(Map<String, Object> inputObjects, Set<String> outputNames, String script) {
        ClojureScriptingCallable callable = new ClojureScriptingCallable(inputObjects, outputNames, script);
        return new CallUnderClassLoader((Callable)callable, this.hookClassLoader);
    }

    protected final <V> V callAndWrapException(Callable<V> callable) throws ScriptingException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            LOG.error((Object)"Error executing clojure script", (Throwable)e);
            throw new ScriptingException("Error executing clojure script", (Throwable)e);
        }
    }
}

