/*
 * Decompiled with CFR 0.152.
 */
package au.com.permeance.liferay.clojure;

import au.com.permeance.liferay.clojure.ClojureScriptable;
import au.com.permeance.liferay.clojure.ClojureScriptableImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClojureScriptingCallable
implements Callable<Map<String, Object>> {
    private static final Log LOG = LogFactoryUtil.getLog(ClojureScriptingCallable.class);
    private static final ClojureScriptable CLOJURE_SCRIPTABLE = new ClojureScriptableImpl();
    private final transient Map<String, Object> inputObjects;
    private final transient Set<String> outputNames;
    private final transient String script;

    public ClojureScriptingCallable(Map<String, Object> inputObjects, Set<String> outputNames, String script) {
        this.inputObjects = inputObjects;
        this.outputNames = outputNames;
        this.script = script;
    }

    @Override
    public final Map<String, Object> call() {
        Object result = CLOJURE_SCRIPTABLE.run_script((Object)this.inputObjects, (Object)this.outputNames, (Object)this.script);
        if (this.outputNames == null || this.outputNames.isEmpty() || result == null) {
            return Collections.emptyMap();
        }
        if (!(result instanceof Map)) {
            LOG.warn((Object)String.format("Unknown return type from clojure script: %s (%s)", result, result.getClass()));
            return Collections.emptyMap();
        }
        return this.retainKeys((Map)result, (Collection)this.outputNames);
    }

    protected final <K, V> Map<K, V> retainKeys(Map<K, V> map, Collection<K> keys) {
        ConcurrentHashMap<K, V> result = new ConcurrentHashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = map.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }
}

