/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import au.com.mountainpass.hyperstate.server.serialization.MessageSourceAwareSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Labelled {
    @Nullable String label = null;
    private Set<String> natures = new HashSet<String>();

    public Labelled() {
    }

    public Labelled(Labelled labelled) {
        this();
        this.label = labelled.label;
        this.natures = labelled.natures;
    }

    public Labelled(String label, Set<String> natures) {
        this.label = label;
        this.natures = natures;
    }

    public Labelled(String label, String ... natures) {
        this.label = label;
        this.natures.addAll(Arrays.asList(natures));
    }

    @JsonSerialize(using=MessageSourceAwareSerializer.class)
    @JsonProperty(value="title")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="class")
    public Set<String> getNatures() {
        return this.natures;
    }

    public boolean hasNature(String nature) {
        return this.getNatures().contains(nature);
    }

    private String interpolate(String value, String ... args) {
        if (args.length == 0) {
            return value;
        }
        Pattern patt = Pattern.compile("\\{(.*?)\\}");
        Matcher m = patt.matcher(value);
        StringBuffer sb = new StringBuffer(value.length());
        int i = 0;
        while (m.find()) {
            String code = m.group(1);
            m.appendReplacement(sb, Matcher.quoteReplacement(args[i]));
            ++i;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    void setLabel(String template, String ... args) {
        this.label = this.interpolate(template, args);
    }

    @JsonProperty(value="class")
    public void setNatures(Set<String> natures) {
        this.natures = natures;
    }

    public void setTitle(String title) {
        this.label = title;
    }
}

