/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.server;

import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.entities.Entity;
import au.com.mountainpass.hyperstate.server.HyperstateApplication;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerMapping;

@RequestMapping(value={"/"})
public class HyperstateRootController {
    @Autowired
    ApplicationContext context;
    @Autowired
    HyperstateApplication hyperstateApplication;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(method={RequestMethod.DELETE}, produces={"application/vnd.siren+json", "application/json"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    @Async
    public CompletableFuture<ResponseEntity<?>> delete(HttpServletRequest request) throws URISyntaxException, NoSuchMethodException, SecurityException, ScriptException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, ExecutionException {
        throw new NotImplementedException("TODO. Shutdown?");
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"text/html", "application/xhtml+xml"})
    public String html() {
        return "/index.html";
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<?> onException(Exception e) {
        this.LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
    }

    @RequestMapping(method={RequestMethod.POST}, produces={"application/vnd.siren+json", "application/json"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public ResponseEntity<?> post(@RequestParam MultiValueMap<String, Object> allRequestParams, HttpServletRequest request) throws URISyntaxException, NoSuchMethodException, SecurityException, ScriptException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, ExecutionException {
        String url = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        HyperstateApplication entity = this.hyperstateApplication;
        if (entity == null) {
            return ResponseEntity.notFound().build();
        }
        Object actionName = allRequestParams.getFirst((Object)"action");
        if (actionName == null) {
            return ResponseEntity.badRequest().build();
        }
        Action<?> action = entity.getAction(actionName.toString());
        if (action == null) {
            return ResponseEntity.badRequest().build();
        }
        Entity result = (Entity)action.invoke(allRequestParams.toSingleValueMap()).get();
        return ResponseEntity.created((URI)result.getAddress()).build();
    }

    @RequestMapping(method={RequestMethod.PUT}, produces={"application/vnd.siren+json", "application/json"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public ResponseEntity<?> put(@RequestParam MultiValueMap<String, Object> queryParams, HttpServletRequest request) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException, InterruptedException, ExecutionException {
        String url = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        HyperstateApplication entity = this.hyperstateApplication;
        if (entity == null) {
            return ResponseEntity.notFound().build();
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.putAll(queryParams);
        String actionName = (String)queryParams.getFirst((Object)"action");
        if (actionName == null) {
            return ResponseEntity.badRequest().build();
        }
        Action<?> action = entity.getAction(actionName);
        if (action == null) {
            return ResponseEntity.badRequest().build();
        }
        action.invoke(params.toSingleValueMap());
        return ResponseEntity.noContent().location(entity.getAddress()).build();
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/vnd.siren+json", "application/json"})
    @ResponseBody
    @Async
    public CompletableFuture<ResponseEntity<?>> self(@RequestParam Map<String, Object> allRequestParams, HttpServletRequest request) {
        return CompletableFuture.supplyAsync(() -> ResponseEntity.ok((Object)this.hyperstateApplication));
    }
}

