/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core.entities;

import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.entities.Entity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ParameterizedTypeReference;

public class LinkedEntity
extends Entity {
    private final Link link;

    public LinkedEntity(Link link) {
        this.link = link;
    }

    public LinkedEntity(Link link, String label, Set<String> natures) {
        this.link = link;
        this.setNatures(natures);
        this.setTitle(label);
    }

    public LinkedEntity(Link link, String label, String ... natures) {
        this.link = link;
        this.setNatures(new HashSet<String>(Arrays.asList(natures)));
        this.setTitle(label);
    }

    @Override
    @JsonProperty(value="href")
    public URI getAddress() {
        return this.link.getAddress();
    }

    @JsonIgnore
    public Link getLink() {
        return this.link;
    }

    @Override
    public <K, T extends EntityWrapper<K>> T reload(Class<T> type) {
        throw new NotImplementedException("TODO");
    }

    @Override
    public <K, T extends EntityWrapper<K>> T resolve(Class<T> type) {
        return (T)((EntityWrapper)this.link.resolve(type));
    }

    @Override
    public <K, T extends EntityWrapper<K>> T resolve(ParameterizedTypeReference<T> type) {
        return (T)((EntityWrapper)this.link.resolve(type));
    }

    @Autowired
    public void setApplicationContext(ApplicationContext context) {
        AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
        bpp.setBeanFactory((BeanFactory)context.getAutowireCapableBeanFactory());
        bpp.processInjection((Object)this.link);
    }

    @Override
    public LinkedEntity toLinkedEntity() {
        return this;
    }
}

