/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import au.com.mountainpass.hyperstate.core.Labelled;
import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.Parameter;
import au.com.mountainpass.hyperstate.core.Resolver;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpMethod;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class Action<T>
extends Labelled {
    private String identifier;
    private Link link;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private Resolver resolver;

    protected Action() {
    }

    public Action(Resolver resolver, String identifier, Link link, Parameter ... parameters) {
        this.identifier = identifier;
        this.parameters.addAll(Arrays.asList(parameters));
        this.link = link;
        this.resolver = resolver;
    }

    protected abstract CompletableFuture<T> doInvoke(Resolver var1, Map<String, Object> var2);

    @JsonProperty(value="href")
    public URI getAddress() {
        if (this.getLink() != null) {
            return this.getLink().getAddress();
        }
        return null;
    }

    @JsonProperty(value="name")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonIgnore
    public Link getLink() {
        return this.link;
    }

    @JsonProperty(value="method")
    public abstract HttpMethod getNature();

    public Set<String> getParameterKeys() {
        HashSet<String> rval = new HashSet<String>();
        for (Parameter param : this.getParameters()) {
            rval.add(param.getIdentifier());
        }
        return rval;
    }

    @JsonProperty(value="fields")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public CompletableFuture<T> invoke(Map<String, Object> context) {
        Set<String> parameterKeys = this.getParameterKeys();
        HashMap<String, Object> filteredParameters = new HashMap<String, Object>(Maps.filterKeys(context, (Predicate)Predicates.in(parameterKeys)));
        String id = this.getIdentifier();
        filteredParameters.put("action", id);
        return this.doInvoke(this.resolver, filteredParameters);
    }
}

