/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.server;

import au.com.mountainpass.hyperstate.core.EntityRepository;
import au.com.mountainpass.hyperstate.core.entities.CreatedEntity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class HyperstateApplication
extends EntityWrapper<Properties> {
    @Autowired
    ApplicationContext context;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    EntityRepository repository;

    public HyperstateApplication() {
        super(new Properties());
    }

    @Autowired
    public HyperstateApplication(EntityRepository repository) {
        super("/", System.getProperties(), "Hyperstate Application", new String[0]);
        this.LOGGER.debug(this.getLink("self").getNatures().toString());
    }

    public CompletableFuture<CreatedEntity> addApplication(String name, String className) throws BeansException, IllegalStateException, ClassNotFoundException {
        Class<?> type = Class.forName(className);
        if (EntityWrapper.class.isAssignableFrom(type)) {
            EntityWrapper entity = (EntityWrapper)this.context.getAutowireCapableBeanFactory().createBean(type);
            return this.repository.save(entity).thenApply(e -> new CreatedEntity((EntityWrapper<?>)e));
        }
        throw new NotImplementedException("TODO: bad request - " + className + " is not an instance of " + EntityWrapper.class.getCanonicalName());
    }
}

