/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.JavaLink;
import au.com.mountainpass.hyperstate.core.Parameter;
import au.com.mountainpass.hyperstate.core.Resolver;
import au.com.mountainpass.hyperstate.core.entities.CreatedEntity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import au.com.mountainpass.hyperstate.core.entities.UpdatedEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpMethod;

public class JavaAction<T>
extends Action<T> {
    private Method method;
    private EntityWrapper<?> entity;
    private HttpMethod nature;

    protected JavaAction() {
    }

    public JavaAction(EntityWrapper<?> entity, Method method) {
        super(null, method.getName(), new JavaLink(entity), JavaAction.extractParameters(method));
        this.method = method;
        this.entity = entity;
        this.nature = JavaAction.determineMethodNature(method);
    }

    public static HttpMethod determineMethodNature(Method method) {
        Type[] typeParams;
        ParameterizedType parameterizedType;
        Type rawType;
        Class<?> rawTypeClass;
        Type type = method.getGenericReturnType();
        if (ParameterizedType.class.isAssignableFrom(type.getClass()) && Class.class.isAssignableFrom(rawTypeClass = (rawType = (parameterizedType = (ParameterizedType)type).getRawType()).getClass()) && CompletableFuture.class.isAssignableFrom((Class)rawType) && (typeParams = parameterizedType.getActualTypeArguments()).length == 1) {
            Type typeParam = typeParams[0];
            if (Class.class.isAssignableFrom(typeParam.getClass()) && Void.class.isAssignableFrom((Class)typeParam)) {
                return HttpMethod.DELETE;
            }
            if (Class.class.isAssignableFrom(typeParam.getClass()) && CreatedEntity.class.isAssignableFrom((Class)typeParam)) {
                return HttpMethod.POST;
            }
            if (Class.class.isAssignableFrom(typeParam.getClass()) && UpdatedEntity.class.isAssignableFrom((Class)typeParam)) {
                return HttpMethod.PUT;
            }
            if (ParameterizedType.class.isAssignableFrom(typeParam.getClass()) && EntityWrapper.class.isAssignableFrom((Class)((ParameterizedType)typeParam).getRawType())) {
                return HttpMethod.GET;
            }
        }
        return null;
    }

    private static Parameter[] extractParameters(Method method) {
        List<java.lang.reflect.Parameter> params = Arrays.asList(method.getParameters());
        ArrayList<Parameter> rval = new ArrayList<Parameter>();
        for (int i = 0; i < params.size(); ++i) {
            rval.add(new Parameter(params.get(i).getName()));
        }
        rval.add(new Parameter("action", "submit", method.getName()));
        return rval.toArray(new Parameter[0]);
    }

    @Override
    public CompletableFuture<T> doInvoke(Resolver resolver, Map<String, Object> filteredParameters) {
        ArrayList<Object> args = new ArrayList<Object>(this.getParameters().size());
        for (Parameter param : this.getParameters()) {
            if ("submit".equals(param.getType())) continue;
            args.add(filteredParameters.get(param.getIdentifier()));
        }
        try {
            return (CompletableFuture)this.method.invoke(this.entity, args.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HttpMethod getNature() {
        return this.nature;
    }
}

