/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import java.util.concurrent.CompletableFuture;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class FutureConverter {
    public static <T> CompletableFuture<T> convert(final ListenableFuture<T> listenableFuture) {
        final CompletableFuture completable = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        listenableFuture.addCallback(new ListenableFutureCallback<T>(){

            public void onSuccess(T result) {
                completable.complete(result);
            }

            public void onFailure(Throwable t) {
                completable.completeExceptionally(t);
            }
        });
        return completable;
    }
}

