/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import au.com.mountainpass.hyperstate.core.Address;
import au.com.mountainpass.hyperstate.core.MediaTypes;
import au.com.mountainpass.hyperstate.core.Titled;
import au.com.mountainpass.hyperstate.core.entities.CreatedEntity;
import au.com.mountainpass.hyperstate.core.entities.DeletedEntity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import au.com.mountainpass.hyperstate.core.entities.UpdatedEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Link
extends Titled {
    private @Nullable MediaType representationFormat = MediaTypes.SIREN_JSON;
    private Address address;

    public Link(@JsonProperty(value="href") Address address, @JsonProperty(value="title") String title, String ... classes) {
        super(title, classes);
        this.address = address;
    }

    public Link() {
    }

    public Link(Address address) {
        this.address = address;
    }

    @JsonProperty(value="type")
    public MediaType getRepresentationFormat() {
        return this.representationFormat == null ? MediaTypes.SIREN_JSON : this.representationFormat;
    }

    public <T extends EntityWrapper<?>> CompletableFuture<T> resolve(Class<T> type) {
        return this.address.get(type);
    }

    public <T extends EntityWrapper<?>> CompletableFuture<T> resolve(ParameterizedTypeReference<T> type) {
        return this.address.get(type);
    }

    @JsonIgnore
    public String getPath() {
        return this.address.getPath();
    }

    public CompletableFuture<EntityWrapper<?>> get(Map<String, Object> filteredParameters) {
        return this.address.get(filteredParameters);
    }

    public CompletableFuture<DeletedEntity> delete(Map<String, Object> filteredParameters) {
        return this.address.delete(filteredParameters);
    }

    public CompletableFuture<CreatedEntity> create(Map<String, Object> filteredParameters) {
        return this.address.create(filteredParameters);
    }

    public CompletableFuture<UpdatedEntity> update(Map<String, Object> filteredParameters) {
        return this.address.update(filteredParameters);
    }

    public CompletableFuture<EntityWrapper<?>> get() {
        return this.address.get();
    }

    @JsonIgnore
    public <T extends EntityWrapper<?>> CompletableFuture<T> get(Class<T> type) {
        return this.address.get(type);
    }

    @JsonUnwrapped
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }
}

