/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Parameter {
    private String identifier;
    private @Nullable String title;
    private final String[] natures = new String[0];
    private String type;
    private @Nullable String value;
    private static Map<Class<?>, String> formTypes = new HashMap();

    protected Parameter() {
    }

    public Parameter(@JsonProperty(value="name") String identifier) {
        this.identifier = identifier;
        this.type = "text";
    }

    public Parameter(String identifier, String type, String value) {
        this(identifier);
        this.type = type == null ? "text" : type;
        this.value = value;
    }

    public Parameter(String identifier, String type, String value, String title) {
        this(identifier, type, value);
        this.title = title;
    }

    @JsonProperty(value="name")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="class")
    public String[] getNatures() {
        return this.natures;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean hasFormTypes(Method method) {
        List<java.lang.reflect.Parameter> params = Arrays.asList(method.getParameters());
        for (java.lang.reflect.Parameter param : params) {
            Class<?> type = param.getType();
            if (formTypes.containsKey(type)) continue;
            return false;
        }
        return true;
    }

    static {
        formTypes.put(String.class, "text");
        formTypes.put(LocalDateTime.class, "datetime");
    }
}

