/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import au.com.mountainpass.hyperstate.core.Address;
import au.com.mountainpass.hyperstate.core.Parameter;
import au.com.mountainpass.hyperstate.core.Titled;
import au.com.mountainpass.hyperstate.core.entities.Entity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.springframework.http.HttpMethod;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class Action<T extends Entity>
extends Titled {
    private String name;
    private Address address;
    private final List<Parameter> parameters = new ArrayList<Parameter>();

    protected Action() {
    }

    public Action(String name, Address address, Parameter ... parameters) {
        this.name = name;
        this.parameters.addAll(Arrays.asList(parameters));
        this.address = address;
    }

    protected abstract CompletableFuture<T> doInvoke(Map<String, Object> var1);

    public String getName() {
        return this.name;
    }

    @JsonUnwrapped
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="method")
    public abstract HttpMethod getNature();

    @JsonIgnore
    public Set<String> getParameterKeys() {
        HashSet<String> rval = new HashSet<String>();
        for (Parameter param : this.getParameters()) {
            rval.add(param.getIdentifier());
        }
        return rval;
    }

    @JsonProperty(value="fields")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public CompletableFuture<T> invoke(Map<String, Object> context) {
        Set<String> parameterKeys = this.getParameterKeys();
        HashMap<String, Object> filteredParameters = new HashMap<String, Object>(Maps.filterKeys(context, (Predicate)Predicates.in(parameterKeys)));
        String id = this.getName();
        filteredParameters.put("action", id);
        return this.doInvoke(filteredParameters);
    }
}

