/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.client.builder;

import au.com.mountainpass.hyperstate.client.CreateAction;
import au.com.mountainpass.hyperstate.client.DeleteAction;
import au.com.mountainpass.hyperstate.client.GetAction;
import au.com.mountainpass.hyperstate.client.RestAddress;
import au.com.mountainpass.hyperstate.client.RestTemplateResolver;
import au.com.mountainpass.hyperstate.client.UpdateAction;
import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.Parameter;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import org.springframework.http.HttpMethod;

public class RestActionBuilder {
    private Parameter[] fields = new Parameter[0];
    private URI href;
    private String name;
    private HttpMethod method;
    private final RestTemplateResolver resolver;

    @JsonCreator
    public RestActionBuilder(@JacksonInject RestTemplateResolver resolver) {
        this.resolver = resolver;
    }

    public Action<?> build() {
        RestAddress address = new RestAddress(this.resolver, this.href);
        switch (this.method) {
            case POST: {
                return new CreateAction(this.name, address, this.fields);
            }
            case DELETE: {
                return new DeleteAction(this.name, address, this.fields);
            }
            case GET: {
                return new GetAction(this.name, address, this.fields);
            }
            case PUT: {
                return new UpdateAction(this.name, address, this.fields);
            }
        }
        return null;
    }

    @JsonProperty(value="fields")
    public RestActionBuilder setFields(Parameter[] fields) {
        this.fields = fields;
        return this;
    }

    @JsonProperty(value="href")
    public RestActionBuilder setHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="method")
    public RestActionBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @JsonProperty(value="name")
    public RestActionBuilder setName(String name) {
        this.name = name;
        return this;
    }
}

