/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.client;

import au.com.mountainpass.hyperstate.client.HyperstateRestErrorHandler;
import au.com.mountainpass.hyperstate.client.RestAddress;
import au.com.mountainpass.hyperstate.client.deserialisation.mixins.ActionMixin;
import au.com.mountainpass.hyperstate.client.deserialisation.mixins.AddressMixin;
import au.com.mountainpass.hyperstate.client.deserialisation.mixins.EntityRelationshipMixin;
import au.com.mountainpass.hyperstate.client.deserialisation.mixins.NavigationalRelationshipMixin;
import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.Address;
import au.com.mountainpass.hyperstate.core.EntityRelationship;
import au.com.mountainpass.hyperstate.core.FutureConverter;
import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.MediaTypes;
import au.com.mountainpass.hyperstate.core.NavigationalRelationship;
import au.com.mountainpass.hyperstate.core.Resolver;
import au.com.mountainpass.hyperstate.core.entities.CreatedEntity;
import au.com.mountainpass.hyperstate.core.entities.DeletedEntity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import au.com.mountainpass.hyperstate.core.entities.UpdatedEntity;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTemplateResolver
implements Resolver {
    private URI baseUri;
    private AsyncRestTemplate asyncRestTemplate;

    public RestTemplateResolver(URI baseUri, ObjectMapper om, AsyncRestTemplate asyncRestTemplate) {
        this.baseUri = baseUri;
        this.asyncRestTemplate = asyncRestTemplate;
        om.addMixIn(Action.class, ActionMixin.class);
        om.addMixIn(Address.class, AddressMixin.class);
        om.addMixIn(EntityRelationship.class, EntityRelationshipMixin.class);
        om.addMixIn(NavigationalRelationship.class, NavigationalRelationshipMixin.class);
        om.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(RestTemplateResolver.class, (Object)this));
        asyncRestTemplate.setErrorHandler((ResponseErrorHandler)new HyperstateRestErrorHandler());
    }

    public CompletableFuture<CreatedEntity> create(RestAddress address, Map<String, Object> filteredParameters) {
        LinkedMultiValueMap body = new LinkedMultiValueMap(filteredParameters.size());
        for (Map.Entry<String, Object> entry : filteredParameters.entrySet()) {
            body.add((Object)entry.getKey(), entry.getValue());
        }
        RequestEntity request = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)address.getHref()).accept(new MediaType[]{MediaTypes.SIREN_JSON})).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)body);
        ListenableFuture locationFuture = this.asyncRestTemplate.postForLocation(address.getHref(), (HttpEntity)request);
        return FutureConverter.convert((ListenableFuture)locationFuture).thenApplyAsync(uri -> {
            CreatedEntity linkedEntity = new CreatedEntity(new Link((Address)new RestAddress(this, (URI)uri), null, null));
            return linkedEntity;
        });
    }

    public CompletableFuture<DeletedEntity> delete(RestAddress address, Map<String, Object> filteredParameters) {
        LinkedMultiValueMap body = new LinkedMultiValueMap(filteredParameters.size());
        for (Map.Entry<String, Object> entry : filteredParameters.entrySet()) {
            body.add((Object)entry.getKey(), entry.getValue());
        }
        RequestEntity request = ((RequestEntity.BodyBuilder)RequestEntity.put((URI)address.getHref()).accept(new MediaType[]{MediaTypes.SIREN_JSON})).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)body);
        ListenableFuture responseFuture = this.asyncRestTemplate.exchange(address.getHref(), HttpMethod.DELETE, (HttpEntity)request, DeletedEntity.class);
        return FutureConverter.convert((ListenableFuture)responseFuture).thenApplyAsync(response -> (DeletedEntity)response.getBody());
    }

    public <T> CompletableFuture<T> get(RestAddress address, Map<String, Object> filteredParameters, Class<T> type) {
        LinkedMultiValueMap body = new LinkedMultiValueMap(filteredParameters.size());
        for (Map.Entry<String, Object> entry : filteredParameters.entrySet()) {
            body.add((Object)entry.getKey(), (Object)entry.getValue().toString());
        }
        URI uri = UriComponentsBuilder.fromHttpUrl((String)address.getHref().toString()).queryParams((MultiValueMap)body).build().toUri();
        RequestEntity request = RequestEntity.get((URI)uri).accept(new MediaType[]{MediaTypes.SIREN_JSON}).build();
        ListenableFuture responseFuture = this.asyncRestTemplate.exchange(uri, HttpMethod.GET, (HttpEntity)request, type);
        return FutureConverter.convert((ListenableFuture)responseFuture).thenApplyAsync(response -> response.getBody());
    }

    public <E extends EntityWrapper<?>> CompletableFuture<E> get(RestAddress address, Class<E> type) {
        HashMap<String, Object> filteredParameters = new HashMap<String, Object>();
        return this.get(address, filteredParameters, type);
    }

    public <E extends EntityWrapper<?>> CompletableFuture<E> get(String path, Class<E> type) {
        URI rootUrl = this.getBaseUri().resolve(path);
        RequestEntity request = RequestEntity.get((URI)rootUrl).accept(new MediaType[]{MediaTypes.SIREN_JSON}).build();
        return FutureConverter.convert((ListenableFuture)this.asyncRestTemplate.exchange(rootUrl, HttpMethod.GET, (HttpEntity)request, type)).thenApply(r -> (EntityWrapper)r.getBody());
    }

    private URI getBaseUri() {
        return this.baseUri;
    }

    public CompletableFuture<UpdatedEntity> update(RestAddress address, Map<String, Object> filteredParameters) {
        LinkedMultiValueMap body = new LinkedMultiValueMap(filteredParameters.size());
        for (Map.Entry<String, Object> entry : filteredParameters.entrySet()) {
            body.add((Object)entry.getKey(), entry.getValue());
        }
        RequestEntity request = ((RequestEntity.BodyBuilder)RequestEntity.put((URI)address.getHref()).accept(new MediaType[]{MediaTypes.SIREN_JSON})).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)body);
        ListenableFuture responseFuture = this.asyncRestTemplate.exchange(address.getHref(), HttpMethod.PUT, (HttpEntity)request, Void.class);
        return FutureConverter.convert((ListenableFuture)responseFuture).thenApplyAsync(response -> {
            Link link = new Link((Address)address);
            return new UpdatedEntity(link);
        });
    }

    public <T> CompletableFuture<T> get(RestAddress address, ParameterizedTypeReference<T> type) {
        throw new NotImplementedException("TODO");
    }

    public <T> CompletableFuture<T> get(RestAddress restAddress) {
        return this.get(restAddress, EntityWrapper.class);
    }
}

