/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.client.deserialisation;

import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.context.ApplicationContext;

public class EntityWrapperProxyDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 5929494436284359667L;
    ApplicationContext context;

    public EntityWrapperProxyDeserializer(ApplicationContext context, JsonDeserializer<?> delegatee) {
        super(delegatee);
        this.context = context;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        final Object result = super.deserialize(jp, ctxt);
        if (EntityWrapper.class.isAssignableFrom(result.getClass())) {
            Enhancer e = new Enhancer();
            e.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            e.setSuperclass(result.getClass());
            e.setCallback((Callback)new MethodInterceptor(){
                private Object original;
                {
                    this.original = result;
                }

                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    if (method.getName().equals("getAction") || method.getName().equals("getActions") || method.getName().equals("toLinkedEntity") || method.getName().equals("getEntities") || method.getName().equals("getProperties") || method.getName().equals("getTitle") || method.getName().equals("getClasses") || method.getName().equals("getLinks") || method.getName().equals("resolve") || method.getName().equals("getLink")) {
                        return proxy.invoke(this.original, args);
                    }
                    if (method.getName().equals("reload")) {
                        return ((EntityWrapper)obj).getLink("self").get();
                    }
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    Parameter[] params = method.getParameters();
                    for (int i = 0; i < params.length; ++i) {
                        context.put(params[i].getName(), args[i]);
                    }
                    Action action = ((EntityWrapper)obj).getAction(method.getName());
                    if (action == null) {
                        throw new RuntimeException("The method `" + method.getName() + "` cannot be executed remotely");
                    }
                    return action.invoke(context);
                }
            });
            return e.create();
        }
        return result;
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return this;
    }
}

