/*
 * Decompiled with CFR 0.152.
 */
package au.gov.dva.sopapi.dtos;

public enum StandardOfProof {
    ReasonableHypothesis("Reasonable Hypothesis"),
    BalanceOfProbabilities("Balance of Probabilities");

    private String text;

    public static StandardOfProof fromString(String text) {
        if (text.contentEquals(ReasonableHypothesis.toString())) {
            return ReasonableHypothesis;
        }
        if (text.contentEquals(BalanceOfProbabilities.toString())) {
            return BalanceOfProbabilities;
        }
        throw new IllegalArgumentException(String.format("Cannot convert this text to Standard of Proof: %s", text));
    }

    public static StandardOfProof fromAbbreviation(String abbreviatedText) {
        if (abbreviatedText.contentEquals("RH")) {
            return ReasonableHypothesis;
        }
        if (abbreviatedText.contentEquals("BoP")) {
            return BalanceOfProbabilities;
        }
        throw new IllegalArgumentException(String.format("Cannot convert this text to Standard of Proof: %s", abbreviatedText));
    }

    public String toAbbreviatedString() {
        switch (this) {
            case BalanceOfProbabilities: {
                return "BoP";
            }
            case ReasonableHypothesis: {
                return "RH";
            }
        }
        throw new IllegalArgumentException(String.format("Cannot create abbreviated string for enum %s.", new Object[]{this}));
    }

    public String toString() {
        return this.text;
    }

    private StandardOfProof(String text) {
        this.text = text;
    }
}

