/*
 * Decompiled with CFR 0.152.
 */
package au.gov.dva.sopapi.dtos;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Locale;

public enum ServiceBranch {
    ARMY,
    RAN,
    RAAF;


    public String toString() {
        switch (this) {
            case ARMY: {
                return "Australian Army";
            }
            case RAN: {
                return "Royal Australian Navy";
            }
            case RAAF: {
                return "Royal Australian Air Force";
            }
        }
        throw new IllegalArgumentException();
    }

    @JsonCreator
    public static ServiceBranch fromString(String value) {
        String lowered = value.toLowerCase(Locale.ENGLISH);
        if (lowered.contentEquals("australian army")) {
            return ARMY;
        }
        if (lowered.contentEquals("royal australian navy")) {
            return RAN;
        }
        if (lowered.contentEquals("royal australian air force")) {
            return RAAF;
        }
        throw new IllegalArgumentException(String.format("Unrecognised service branch: %s", value));
    }
}

