/*
 * Decompiled with CFR 0.152.
 */
package au.gov.dva.sopapi.dtos;

public enum Recommendation {
    APPROVED,
    REJECT,
    CHECK_RH_BOP_MET,
    CHECK_RH;

    private static final String RECOMMEDATION_TEXT_APPROVED = "Accept claim";
    private static final String RECOMMEDATION_TEXT_REJECT = "Review claim details";
    private static final String RECOMMEDATION_TEXT_CHECK_RH_BOP_MET = "Review operational service to check all factors, otherwise accept as BoP factor met";
    private static final String RECOMMEDATION_TEXT_CHECK_RH = "Review operational service to check all factors";

    public String toString() {
        switch (this) {
            case APPROVED: {
                return RECOMMEDATION_TEXT_APPROVED;
            }
            case REJECT: {
                return RECOMMEDATION_TEXT_REJECT;
            }
            case CHECK_RH_BOP_MET: {
                return RECOMMEDATION_TEXT_CHECK_RH_BOP_MET;
            }
            case CHECK_RH: {
                return RECOMMEDATION_TEXT_CHECK_RH;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Recommendation fromString(String value) {
        if (value.contentEquals(RECOMMEDATION_TEXT_APPROVED)) {
            return APPROVED;
        }
        if (value.contentEquals(RECOMMEDATION_TEXT_REJECT)) {
            return REJECT;
        }
        if (value.contentEquals(RECOMMEDATION_TEXT_CHECK_RH_BOP_MET)) {
            return CHECK_RH_BOP_MET;
        }
        if (value.contentEquals(RECOMMEDATION_TEXT_CHECK_RH)) {
            return CHECK_RH;
        }
        throw new IllegalArgumentException(String.format("Unrecognised recommendation: %s", value));
    }
}

