/*
 * Decompiled with CFR 0.152.
 */
package au.gov.dva.sopapi.dtos;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Locale;

public enum Rank {
    Officer,
    OtherRank,
    SpecialForces,
    Unknown;


    public String toString() {
        switch (this) {
            case Officer: {
                return "officer";
            }
            case OtherRank: {
                return "other rank";
            }
            case SpecialForces: {
                return "special forces";
            }
            case Unknown: {
                return "unknown";
            }
        }
        throw new IllegalArgumentException();
    }

    @JsonCreator
    public static Rank fromString(String rank) {
        String lowered = rank.toLowerCase(Locale.ENGLISH);
        if (lowered.contentEquals("officer")) {
            return Officer;
        }
        if (lowered.contentEquals("other rank")) {
            return OtherRank;
        }
        if (lowered.contentEquals("special forces")) {
            return SpecialForces;
        }
        throw new IllegalArgumentException(String.format("Do not recognise rank: %s", rank));
    }
}

