/*
 * Decompiled with CFR 0.152.
 */
package au.gov.dva.sopapi.client;

import au.gov.dva.sopapi.client.SoPApiClient;
import au.gov.dva.sopapi.client.SoPApiClientError;
import au.gov.dva.sopapi.client.SoPApiProxyClientNtlmSettings;
import au.gov.dva.sopapi.dtos.IncidentType;
import au.gov.dva.sopapi.dtos.StandardOfProof;
import au.gov.dva.sopapi.dtos.sopref.ConditionsList;
import au.gov.dva.sopapi.dtos.sopref.OperationsResponse;
import au.gov.dva.sopapi.dtos.sopref.SoPReferenceResponse;
import au.gov.dva.sopapi.dtos.sopsupport.SopSupportRequestDto;
import au.gov.dva.sopapi.dtos.sopsupport.SopSupportResponseDto;
import com.google.common.base.Charsets;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Param;
import org.asynchttpclient.Realm;
import org.asynchttpclient.proxy.ProxyServer;

public class HttpSoPApiClient
implements SoPApiClient {
    private final URL baseUrl;
    private Optional<SoPApiProxyClientNtlmSettings> proxyConfig;
    private static volatile AsyncHttpClient asyncHttpClient;

    public HttpSoPApiClient(URL baseUrl, Optional<SoPApiProxyClientNtlmSettings> proxyConfig) {
        this.baseUrl = baseUrl;
        this.proxyConfig = proxyConfig;
    }

    private AsyncHttpClient getOrCreateAsyncHttpClient() {
        if (asyncHttpClient == null) {
            asyncHttpClient = this.buildAsyncHttpClient(this.proxyConfig);
        }
        return asyncHttpClient;
    }

    private AsyncHttpClient buildAsyncHttpClient(Optional<SoPApiProxyClientNtlmSettings> soPApiProxyClientSettings) {
        if (soPApiProxyClientSettings.isPresent()) {
            SoPApiProxyClientNtlmSettings proxyClientSettings = soPApiProxyClientSettings.get();
            Realm realm = new Realm.Builder(proxyClientSettings.getUserName(), proxyClientSettings.getPassword()).setNtlmDomain(proxyClientSettings.getNtlmDomain()).setNtlmHost(proxyClientSettings.getNtlmHost()).setScheme(Realm.AuthScheme.NTLM).build();
            ProxyServer proxyServer = new ProxyServer.Builder(proxyClientSettings.getIpAddress(), proxyClientSettings.getPort()).setRealm(realm).setSecuredPort(proxyClientSettings.getPort()).build();
            DefaultAsyncHttpClientConfig cf = new DefaultAsyncHttpClientConfig.Builder().setProxyServer(proxyServer).setAcceptAnyCertificate(true).setConnectTimeout(proxyClientSettings.getSecondsTimeOut()).build();
            return new DefaultAsyncHttpClient((AsyncHttpClientConfig)cf);
        }
        return new DefaultAsyncHttpClient();
    }

    private static URL getServiceUrl(URL baseUrl, String serviceRouteWithLeadingSlash) {
        try {
            assert (!baseUrl.toString().endsWith("/"));
            return URI.create(baseUrl + serviceRouteWithLeadingSlash).toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CompletableFuture<SoPReferenceResponse> getFactorsForConditionName(String conditionName, IncidentType incidentType, StandardOfProof standardOfProof) {
        return this.getFactors(conditionName, null, null, incidentType, standardOfProof);
    }

    @Override
    public CompletableFuture<SoPReferenceResponse> getFactorsForIcdCode(String icdCodeVersion, String icdCodeValue, IncidentType incidentType, StandardOfProof standardOfProof) {
        return this.getFactors(null, icdCodeVersion, icdCodeValue, incidentType, standardOfProof);
    }

    private CompletableFuture<SoPReferenceResponse> getFactors(String conditionName, String icdCodeVersion, String icdCodeValue, IncidentType incidentType, StandardOfProof standardOfProof) {
        URL serviceUrl = HttpSoPApiClient.getServiceUrl(this.baseUrl, "/getSopFactors");
        ArrayList<Param> params = new ArrayList<Param>();
        params.add(new Param("conditionName", conditionName));
        params.add(new Param("icdCodeValue", icdCodeValue));
        params.add(new Param("icdCodeVersion", icdCodeVersion));
        params.add(new Param("incidentType", incidentType.toString()));
        params.add(new Param("standardOfProof", standardOfProof.toAbbreviatedString()));
        CompletionStage promise = ((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.getOrCreateAsyncHttpClient().prepareGet(serviceUrl.toString()).setHeader((CharSequence)"Accept", "application/json; charset=utf-8")).setHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).addQueryParams(params)).execute().toCompletableFuture().thenApply(response -> {
            if (response.getStatusCode() == 200) {
                return SoPReferenceResponse.fromJsonString((String)response.getResponseBody());
            }
            throw new SoPApiClientError(response.getResponseBody(Charsets.UTF_8));
        });
        return promise;
    }

    @Override
    public CompletableFuture<OperationsResponse> getOperations() {
        URL serviceUrl = HttpSoPApiClient.getServiceUrl(this.baseUrl, "/getOperations");
        CompletionStage promise = ((BoundRequestBuilder)((BoundRequestBuilder)this.getOrCreateAsyncHttpClient().prepareGet(serviceUrl.toString()).setHeader((CharSequence)"Accept", "application/json; charset=utf-8")).setHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).execute().toCompletableFuture().thenApply(response -> {
            if (response.getStatusCode() == 200) {
                return OperationsResponse.fromJsonString((String)response.getResponseBody(Charsets.UTF_8));
            }
            throw new SoPApiClientError(response.getResponseBody(Charsets.UTF_8));
        });
        return promise;
    }

    @Override
    public CompletableFuture<SopSupportResponseDto> getSatisfiedFactors(SopSupportRequestDto sopSupportRequestDto) {
        String jsonRequestBody = sopSupportRequestDto.toJsonString();
        URL serviceUrl = HttpSoPApiClient.getServiceUrl(this.baseUrl, "/getConnectionToService");
        CompletionStage promise = ((CompletableFuture)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.getOrCreateAsyncHttpClient().preparePost(serviceUrl.toString()).setHeader((CharSequence)"Accept", "application/json; charset=utf-8")).setHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).setBody(jsonRequestBody)).execute().toCompletableFuture().thenApply(response -> {
            if (response.getStatusCode() == 200) {
                return response.getResponseBody();
            }
            throw new SoPApiClientError(HttpSoPApiClient.buildErrorMsg(response.getStatusCode(), response.getResponseBody()));
        })).thenApply(json -> SopSupportResponseDto.fromJsonString((String)json.toString()));
        return promise;
    }

    @Override
    public CompletableFuture<ConditionsList> getConditions() {
        URL serviceUrl = HttpSoPApiClient.getServiceUrl(this.baseUrl, "/getConditions");
        CompletionStage promise = ((BoundRequestBuilder)((BoundRequestBuilder)this.getOrCreateAsyncHttpClient().prepareGet(serviceUrl.toString()).setHeader((CharSequence)"Accept", "application/json; charset=utf-8")).setHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).execute().toCompletableFuture().thenApply(response -> {
            if (response.getStatusCode() == 200) {
                return ConditionsList.fromJsonString((String)response.getResponseBody(Charsets.UTF_8));
            }
            throw new SoPApiClientError(response.getResponseBody(Charsets.UTF_8));
        });
        return promise;
    }

    private static String buildErrorMsg(Integer statusCode, String msg) {
        return String.format("HTTP Status Code: %d, %s.", statusCode, msg);
    }
}

