package akka.guice.annotation

import scala.annotation.{StaticAnnotation, compileTimeOnly}
import scala.language.experimental.macros
import scala.reflect.macros.whitebox

object injectableActor {
  def impl(c: whitebox.Context)(annottees: c.Expr[Any]*): c.Expr[Any] = {
    import c.universe._
    val inputs = annottees.map(_.tree).toList
    val klass = inputs.head match {
      case ClassDef(modifiers, name, typedef, Template(parents, self, body)) =>
        val injectableActorClass =
          Select(
            Select(
              Ident(TermName("akka")),
              TermName("guice")),
            TypeName("InjectableActor")
          )
        val injectorClass: c.universe.Select = Select(
          Select(Select(Ident(TermName("com")), TermName("google")),
            TermName("inject")), TypeName("Injector"))

        val updateConstructors =
          ValDef(
            Modifiers(Flag.PROTECTED | Flag.PARAMACCESSOR),
            TermName("injector"),
            injectorClass,
            EmptyTree
          ) ::
            body map {
              case v @ DefDef(funcModifiers, funcName, tparams, vparamss, b1, b2)
              if funcName == termNames.CONSTRUCTOR =>
                if (vparamss.length > 1) {
                  throw new UnsupportedOperationException("You may only have one parameter list.")
                }
                val injectedvparamss = vparamss.map { old =>
                  ValDef(
                    Modifiers(Flag.PARAMACCESSOR | Flag.PARAM),
                    TermName("injector"),
                    injectorClass,
                    EmptyTree
                  ) :: old
                }
                DefDef(funcModifiers, funcName, tparams, injectedvparamss, b1, b2)
              case x =>
                x
            }
        val template = Template(parents :+ injectableActorClass, self, updateConstructors)

        ClassDef(modifiers, name, typedef, template)

      case _ =>
        throw new UnsupportedOperationException("You can only attach @injectableActor to class definitions.")
    }
    c.Expr[Any](Block(klass :: inputs.tail, Literal(Constant(()))))
  }
}

@compileTimeOnly("Enable macro paradise compiler plugin to expand macro annotations")
class injectableActor extends StaticAnnotation {
  def macroTransform(annottees: Any*): Any = macro injectableActor.impl
}
