/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.provider.DefaultTestResultAccumulator;
import au.com.dius.pact.provider.DefaultVerificationReporter;
import au.com.dius.pact.provider.TestResultAccumulator;
import au.com.dius.pact.provider.VerificationReporter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J*\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0012J\u0016\u0010\u0016\u001a\u00020\u00062\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011J\u0018\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ(\u0010\u001b\u001a\u00020\u00182\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J(\u0010\u001b\u001a\u00020\u00182\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000fH\u0016R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lau/com/dius/pact/provider/DefaultTestResultAccumulator;", "Lau/com/dius/pact/provider/TestResultAccumulator;", "Lmu/KLogging;", "()V", "testResults", "", "", "Lau/com/dius/pact/core/pactbroker/TestResult;", "verificationReporter", "Lau/com/dius/pact/provider/VerificationReporter;", "getVerificationReporter", "()Lau/com/dius/pact/provider/VerificationReporter;", "setVerificationReporter", "(Lau/com/dius/pact/provider/VerificationReporter;)V", "allInteractionsVerified", "", "pact", "Lau/com/dius/pact/core/model/Pact;", "Lau/com/dius/pact/core/model/Interaction;", "results", "calculateInteractionHash", "interaction", "calculatePactHash", "clearTestResult", "", "lookupProviderVersion", "", "updateTestResult", "testExecutionResult", "pact-jvm-provider"})
public final class DefaultTestResultAccumulator
extends KLogging
implements TestResultAccumulator {
    private static final Map<Integer, Map<Integer, TestResult>> testResults;
    @NotNull
    private static VerificationReporter verificationReporter;
    public static final DefaultTestResultAccumulator INSTANCE;

    @NotNull
    public final VerificationReporter getVerificationReporter() {
        return verificationReporter;
    }

    public final void setVerificationReporter(@NotNull VerificationReporter verificationReporter) {
        Intrinsics.checkParameterIsNotNull((Object)verificationReporter, (String)"<set-?>");
        DefaultTestResultAccumulator.verificationReporter = verificationReporter;
    }

    @Override
    public void updateTestResult(@NotNull Pact<? extends Interaction> pact, @NotNull Interaction interaction, boolean testExecutionResult) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        this.updateTestResult(pact, interaction, TestResult.Companion.fromBoolean(testExecutionResult));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateTestResult(@NotNull Pact<? extends Interaction> pact, @NotNull Interaction interaction, @NotNull TestResult testExecutionResult) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        Intrinsics.checkParameterIsNotNull((Object)testExecutionResult, (String)"testExecutionResult");
        this.getLogger().debug((Function0)new Function0<String>(testExecutionResult, pact, interaction){
            final /* synthetic */ TestResult $testExecutionResult;
            final /* synthetic */ Pact $pact;
            final /* synthetic */ Interaction $interaction;

            @NotNull
            public final String invoke() {
                return "Received test result '" + this.$testExecutionResult + "' for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + ' ' + "and " + this.$interaction.getDescription();
            }
            {
                this.$testExecutionResult = testResult;
                this.$pact = pact;
                this.$interaction = interaction;
                super(0);
            }
        });
        int pactHash = this.calculatePactHash(pact);
        Map<Integer, Map<Integer, TestResult>> map2 = testResults;
        Object key$iv = pactHash;
        boolean $i$f$getOrPut2 = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Map interactionResults = (Map)object;
        int interactionHash = this.calculateInteractionHash(interaction);
        interactionResults.put(interactionHash, testExecutionResult);
        if (this.allInteractionsVerified(pact, interactionResults)) {
            this.getLogger().debug((Function0)new Function0<String>(pact){
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "All interactions for Pact " + this.$pact.getProvider().getName() + '-' + this.$pact.getConsumer().getName() + " are verified";
                }
                {
                    this.$pact = pact;
                    super(0);
                }
            });
            if (verificationReporter.publishingResultsDisabled()) {
                this.getLogger().warn((Function0)updateTestResult.3.INSTANCE);
            } else {
                void $this$fold$iv;
                void initial$iv;
                key$iv = interactionResults.values();
                TestResult.Ok $i$f$getOrPut2 = TestResult.Ok.INSTANCE;
                Pact<? extends Interaction> pact2 = pact;
                VerificationReporter verificationReporter = DefaultTestResultAccumulator.verificationReporter;
                boolean $i$f$fold = false;
                TestResult accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void result2;
                    TestResult testResult = (TestResult)element$iv;
                    TestResult acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc.merge((TestResult)result2);
                }
                void var18_23 = accumulator$iv;
                VerificationReporter.DefaultImpls.reportResults$default(verificationReporter, pact2, (TestResult)var18_23, this.lookupProviderVersion(), null, 8, null);
            }
        } else {
            this.getLogger().info((Function0)new Function0<String>(pact){
                final /* synthetic */ Pact $pact;

                @NotNull
                public final String invoke() {
                    return "Not all of the #" + this.$pact.getInteractions().size() + " were verified.";
                }
                {
                    this.$pact = pact;
                    super(0);
                }
            });
        }
    }

    public final int calculateInteractionHash(@NotNull Interaction interaction) {
        Intrinsics.checkParameterIsNotNull((Object)interaction, (String)"interaction");
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)interaction.getDescription());
        Iterable $this$forEach$iv = interaction.getProviderStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProviderState it = (ProviderState)element$iv;
            boolean bl = false;
            builder.append((Object)it.getName());
        }
        return builder.toHashCode();
    }

    public final int calculatePactHash(@NotNull Pact<? extends Interaction> pact) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        return new HashCodeBuilder().append((Object)pact.getConsumer().getName()).append((Object)pact.getProvider().getName()).toHashCode();
    }

    @NotNull
    public final String lookupProviderVersion() {
        String string;
        String version = System.getProperty("pact.provider.version");
        CharSequence charSequence = version;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            this.getLogger().warn((Function0)lookupProviderVersion.1.INSTANCE);
            string = "0.0.0";
        } else {
            string = version;
        }
        return string;
    }

    public final boolean allInteractionsVerified(@NotNull Pact<? extends Interaction> pact, @NotNull Map<Integer, TestResult> results) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
            Intrinsics.checkParameterIsNotNull(results, (String)"results");
            this.getLogger().debug((Function0)new Function0<String>(pact, results){
                final /* synthetic */ Pact $pact;
                final /* synthetic */ Map $results;

                @NotNull
                public final String invoke() {
                    return "Number of interactions #" + this.$pact.getInteractions().size() + " and results: " + this.$results.values();
                }
                {
                    this.$pact = pact;
                    this.$results = map2;
                    super(0);
                }
            });
            Iterable $this$all$iv = pact.getInteractions();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Interaction it = (Interaction)element$iv;
                    boolean bl2 = false;
                    if (results.containsKey(INSTANCE.calculateInteractionHash(it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void clearTestResult(@NotNull Pact<? extends Interaction> pact) {
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        int pactHash = this.calculatePactHash(pact);
        testResults.remove(pactHash);
    }

    private DefaultTestResultAccumulator() {
    }

    static {
        DefaultTestResultAccumulator defaultTestResultAccumulator;
        INSTANCE = defaultTestResultAccumulator = new DefaultTestResultAccumulator();
        boolean bl = false;
        testResults = new LinkedHashMap();
        verificationReporter = DefaultVerificationReporter.INSTANCE;
    }
}

