/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.pactbroker;

import au.com.dius.pact.com.github.michaelbull.result.Err;
import au.com.dius.pact.com.github.michaelbull.result.Ok;
import au.com.dius.pact.com.github.michaelbull.result.Result;
import au.com.dius.pact.pactbroker.CustomServiceUnavailableRetryStrategy;
import au.com.dius.pact.pactbroker.HalClientBase;
import au.com.dius.pact.pactbroker.IHalClient;
import au.com.dius.pact.pactbroker.InvalidHalResponse;
import au.com.dius.pact.pactbroker.InvalidNavigationRequest;
import au.com.dius.pact.pactbroker.NotFoundHalResponse;
import au.com.dius.pact.pactbroker.RequestFailedException;
import au.com.dius.pact.support.KotlinLanguageSupportKt;
import au.com.dius.pact.util.HttpClientUtils;
import com.github.salomonbrys.kotson.ElementKt;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 P2\u00020\u0001:\u0001PB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J.\u0010\"\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0016J$\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J,\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\u001a\u0010.\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050/H\u0016J*\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\b\u0012\u000602j\u0002`3012\u0006\u0010&\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020(H\u0002J6\u00104\u001a\u0004\u0018\u00010\u00062\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u00032\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000608J\u0006\u00109\u001a\u00020,J\u001d\u0010:\u001a\u0002H;\"\b\b\u0000\u0010;*\u00020<2\u0006\u0010=\u001a\u0002H;\u00a2\u0006\u0002\u0010>J\u0012\u0010?\u001a\u0004\u0018\u00010\u00032\u0006\u0010@\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0003H\u0016J$\u0010A\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010*\u001a\u00020\u0003H\u0016J\"\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005J(\u0010D\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\b\u0012\u000602j\u0002`3012\u0006\u0010E\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0003H\u0016Jb\u0010D\u001a\u0012\u0012\u0004\u0012\u00020(\u0012\b\u0012\u000602j\u0002`3012\u0006\u0010E\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u000328\u0010F\u001a4\u0012\u0013\u0012\u00110H\u00a2\u0006\f\bI\u0012\b\b@\u0012\u0004\b\b(J\u0012\u0013\u0012\u00110K\u00a2\u0006\f\bI\u0012\b\b@\u0012\u0004\b\b(L\u0012\u0004\u0012\u00020(\u0018\u00010GH\u0016J\b\u0010M\u001a\u00020\u0011H\u0016J\u001a\u0010N\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\u00032\u0006\u0010O\u001a\u00020\u0003H\u0016J6\u0010N\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\u00032\u0006\u0010O\u001a\u00020\u00032\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000608H\u0016J>\u0010N\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\u00032\u0006\u0010O\u001a\u00020\u00032\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0006082\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\t\"\u0004\b\u0018\u0010\u0019R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006Q"}, d2={"Lau/com/dius/pact/pactbroker/HalClientBase;", "Lau/com/dius/pact/pactbroker/IHalClient;", "baseUrl", "", "options", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getBaseUrl", "()Ljava/lang/String;", "defaultHeaders", "", "getDefaultHeaders", "()Ljava/util/Map;", "setDefaultHeaders", "(Ljava/util/Map;)V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "getHttpClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "setHttpClient", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "lastUrl", "getLastUrl", "setLastUrl", "(Ljava/lang/String;)V", "getOptions", "setOptions", "pathInfo", "Lcom/google/gson/JsonElement;", "getPathInfo", "()Lcom/google/gson/JsonElement;", "setPathInfo", "(Lcom/google/gson/JsonElement;)V", "encodePathParameter", "key", "value", "fetch", "path", "encodePath", "", "fetchLink", "link", "forAll", "", "linkName", "closure", "Ljava/util/function/Consumer;", "getJson", "Lau/com/dius/pact/com/github/michaelbull/result/Result;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleFailure", "resp", "Lorg/apache/http/HttpResponse;", "body", "Ljava/util/function/BiFunction;", "initPathInfo", "initialiseRequest", "Method", "Lorg/apache/http/HttpMessage;", "method", "(Lorg/apache/http/HttpMessage;)Lorg/apache/http/HttpMessage;", "linkUrl", "name", "navigate", "parseLinkUrl", "href", "postJson", "url", "handler", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "status", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "response", "setupHttpClient", "uploadJson", "bodyJson", "Companion", "pact-jvm-pact-broker"})
public abstract class HalClientBase
implements IHalClient {
    @Nullable
    private CloseableHttpClient httpClient;
    @Nullable
    private JsonElement pathInfo;
    @Nullable
    private String lastUrl;
    @NotNull
    private Map<String, String> defaultHeaders;
    @NotNull
    private final String baseUrl;
    @NotNull
    private Map<String, ? extends Object> options;
    @NotNull
    public static final String ROOT = "/";
    @NotNull
    public static final String LINKS = "_links";
    @NotNull
    private static final Regex URL_TEMPLATE_REGEX;
    public static final Companion Companion;

    @Nullable
    public final CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public final void setHttpClient(@Nullable CloseableHttpClient closeableHttpClient) {
        this.httpClient = closeableHttpClient;
    }

    @Nullable
    public final JsonElement getPathInfo() {
        return this.pathInfo;
    }

    public final void setPathInfo(@Nullable JsonElement jsonElement) {
        this.pathInfo = jsonElement;
    }

    @Nullable
    public final String getLastUrl() {
        return this.lastUrl;
    }

    public final void setLastUrl(@Nullable String string) {
        this.lastUrl = string;
    }

    @NotNull
    public final Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public final void setDefaultHeaders(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.defaultHeaders = map;
    }

    @NotNull
    public final <Method extends HttpMessage> Method initialiseRequest(@NotNull Method method) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        this.defaultHeaders.forEach(new BiConsumer<String, String>(method){
            final /* synthetic */ HttpMessage $method;

            public final void accept(@NotNull String key, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                this.$method.addHeader(key, value);
            }
            {
                this.$method = httpMessage;
            }
        });
        return method;
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        return this.postJson(url, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body, @Nullable Function2<? super Integer, ? super CloseableHttpResponse, Boolean> handler) {
        Result result;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Companion.getLogger().debug((Function0)new Function0<String>(url, body){
            final /* synthetic */ String $url;
            final /* synthetic */ String $body;

            @NotNull
            public final String invoke() {
                return "Posting JSON to " + this.$url + '\n' + this.$body;
            }
            {
                this.$url = string;
                this.$body = string2;
                super(0);
            }
        });
        CloseableHttpClient client = this.setupHttpClient();
        Result.Companion this_$iv = Result.Companion;
        boolean $i$f$of = false;
        try {
            Boolean bl;
            boolean bl2;
            boolean bl3 = false;
            HttpPost httpPost = (HttpPost)this.initialiseRequest((HttpMessage)new HttpPost(url));
            httpPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
            Closeable closeable = (Closeable)client.execute((HttpUriRequest)httpPost);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                boolean bl5;
                CloseableHttpResponse it = (CloseableHttpResponse)closeable;
                boolean bl6 = false;
                Companion.getLogger().debug((Function0)new Function0<String>(it){
                    final /* synthetic */ CloseableHttpResponse $it;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Got response ");
                        CloseableHttpResponse closeableHttpResponse = this.$it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                        return stringBuilder.append(closeableHttpResponse.getStatusLine()).toString();
                    }
                    {
                        this.$it = closeableHttpResponse;
                        super(0);
                    }
                });
                Companion.getLogger().debug((Function0)new Function0<String>(it){
                    final /* synthetic */ CloseableHttpResponse $it;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Response body: ");
                        CloseableHttpResponse closeableHttpResponse = this.$it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                        HttpEntity httpEntity = closeableHttpResponse.getEntity();
                        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"it.entity");
                        InputStream inputStream = httpEntity.getContent();
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it.entity.content");
                        InputStream inputStream2 = inputStream;
                        StringBuilder stringBuilder2 = stringBuilder;
                        Charset charset = Charsets.UTF_8;
                        boolean bl = false;
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, charset);
                        return stringBuilder2.append(TextStreamsKt.readText((Reader)inputStreamReader)).toString();
                    }
                    {
                        this.$it = closeableHttpResponse;
                        super(0);
                    }
                });
                if (handler != null) {
                    CloseableHttpResponse closeableHttpResponse = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                    bl5 = (Boolean)handler.invoke((Object)statusLine.getStatusCode(), (Object)it);
                } else {
                    CloseableHttpResponse closeableHttpResponse = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                    bl5 = statusLine.getStatusCode() < 300;
                }
                bl2 = bl5;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Boolean bl7 = bl = Boolean.valueOf(bl2);
            result = (Result)new Ok((Object)bl7);
        }
        catch (Exception ex$iv) {
            result = (Result)new Err((Object)ex$iv);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public CloseableHttpClient setupHttpClient() {
        block12: {
            block14: {
                block13: {
                    if (this.httpClient != null) break block12;
                    retryStrategy = new CustomServiceUnavailableRetryStrategy(5, 3000);
                    builder = HttpClients.custom().useSystemProperties().setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)retryStrategy);
                    if (!(this.options.get("authentication") instanceof List)) break block13;
                    v0 = this.options.get("authentication");
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                    }
                    authentication = (List)v0;
                    var5_4 = String.valueOf(CollectionsKt.first((List)authentication));
                    var6_5 = false;
                    v1 = var5_4;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v2 = v1.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"(this as java.lang.String).toLowerCase()");
                    var5_4 = scheme = v2;
                    switch (var5_4.hashCode()) {
                        case -1393032351: {
                            if (!var5_4.equals("bearer")) ** break;
                            break;
                        }
                        case 93508654: {
                            if (!var5_4.equals("basic")) ** break;
                            if (authentication.size() > 2) {
                                credsProvider = new BasicCredentialsProvider();
                                uri = new URI(this.baseUrl);
                                credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(String.valueOf(authentication.get(1)), String.valueOf(authentication.get(2))));
                                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                            } else {
                                HalClientBase.Companion.getLogger().warn((Function0)setupHttpClient.1.INSTANCE);
                            }
                            break block14;
                        }
                    }
                    if (authentication.size() > 1) {
                        this.defaultHeaders.put("Authorization", "Bearer " + String.valueOf(authentication.get(1)));
                    } else {
                        HalClientBase.Companion.getLogger().warn((Function0)setupHttpClient.2.INSTANCE);
                    }
                    break block14;
                    HalClientBase.Companion.getLogger().warn((Function0)new Function0<String>(scheme){
                        final /* synthetic */ String $scheme;

                        @NotNull
                        public final String invoke() {
                            return "Hal client Only supports basic and bearer token authentication, got '" + this.$scheme + "', ignoring.";
                        }
                        {
                            this.$scheme = string;
                            super(0);
                        }
                    });
                    break block14;
                }
                if (this.options.containsKey("authentication")) {
                    HalClientBase.Companion.getLogger().warn((Function0)setupHttpClient.4.INSTANCE);
                }
            }
            this.httpClient = builder.build();
        }
        v3 = this.httpClient;
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        return v3;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull Map<String, ? extends Object> options, @NotNull String link) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            jsonElement = this.fetch(ROOT);
        }
        this.pathInfo = jsonElement;
        this.pathInfo = this.fetchLink(link, options);
        return this;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        HalClientBase halClientBase = this;
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        return halClientBase.navigate(map, link);
    }

    @Override
    @NotNull
    public JsonElement fetch(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.fetch(path, true);
    }

    @Override
    @NotNull
    public JsonElement fetch(@NotNull String path, boolean encodePath) {
        Result<JsonElement, Exception> response;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.lastUrl = path;
        Companion.getLogger().debug((Function0)new Function0<String>(path){
            final /* synthetic */ String $path;

            @NotNull
            public final String invoke() {
                return "Fetching: " + this.$path;
            }
            {
                this.$path = string;
                super(0);
            }
        });
        Result<JsonElement, Exception> result = response = this.getJson(path, encodePath);
        if (result instanceof Ok) {
            return (JsonElement)((Ok)response).getValue();
        }
        if (result instanceof Err) {
            throw (Throwable)((Err)response).getError();
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Result<JsonElement, Exception> getJson(String path, boolean encodePath) {
        Result result;
        this.setupHttpClient();
        Result.Companion this_$iv = Result.Companion;
        boolean $i$f$of = false;
        try {
            JsonElement jsonElement;
            CloseableHttpResponse response;
            boolean bl = false;
            HttpGet httpGet = (HttpGet)this.initialiseRequest((HttpMessage)new HttpGet(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, path, encodePath)));
            httpGet.addHeader("Content-Type", "application/json");
            httpGet.addHeader("Accept", "application/hal+json, application/json");
            CloseableHttpClient closeableHttpClient = this.httpClient;
            if (closeableHttpClient == null) {
                Intrinsics.throwNpe();
            }
            CloseableHttpResponse closeableHttpResponse = response = closeableHttpClient.execute((HttpUriRequest)httpGet);
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
            if (statusLine.getStatusCode() < 300) {
                ContentType contentType;
                ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
                Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
                if (!HttpClientUtils.INSTANCE.isJsonResponse(contentType2)) {
                    throw (Throwable)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got '" + contentType + '\'');
                }
            } else {
                StatusLine statusLine2 = response.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"response.statusLine");
                switch (statusLine2.getStatusCode()) {
                    case 404: {
                        throw (Throwable)new NotFoundHalResponse("No HAL document found at path '" + path + '\'');
                    }
                }
                throw (Throwable)new RequestFailedException("Request to path '" + path + "' failed with response '" + response.getStatusLine() + '\'');
            }
            JsonElement jsonElement2 = jsonElement = new JsonParser().parse(EntityUtils.toString((HttpEntity)response.getEntity()));
            result = (Result)new Ok((Object)jsonElement2);
        }
        catch (Exception ex$iv) {
            result = (Result)new Err((Object)ex$iv);
        }
        return result;
    }

    static /* synthetic */ Result getJson$default(HalClientBase halClientBase, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getJson");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return halClientBase.getJson(string, bl);
    }

    private final JsonElement fetchLink(String link, Map<String, ? extends Object> options) {
        JsonElement links;
        JsonElement jsonElement = this.pathInfo;
        if ((jsonElement != null && (jsonElement = ElementKt.getNullObj((JsonElement)jsonElement)) != null ? jsonElement.get(LINKS) : null) == null) {
            throw (Throwable)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got " + "a response with no '_links'. URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        JsonElement jsonElement2 = this.pathInfo;
        if (jsonElement2 == null) {
            Intrinsics.throwNpe();
        }
        if ((links = ElementKt.get((JsonElement)jsonElement2, (String)LINKS)).isJsonObject()) {
            if (!ElementKt.getObj((JsonElement)links).has(link)) {
                throw (Throwable)new InvalidHalResponse("Link '" + link + "' was not found in the response, only the following links where " + "found: " + ElementKt.keys((JsonObject)ElementKt.getObj((JsonElement)links)) + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            JsonElement linkData = ElementKt.get((JsonElement)links, (String)link);
            if (linkData.isJsonArray()) {
                if (options.containsKey("name")) {
                    JsonElement jsonElement3;
                    Object v4;
                    block12: {
                        JsonArray jsonArray = linkData.getAsJsonArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"linkData.asJsonArray");
                        Iterable iterable = (Iterable)jsonArray;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (Object t : iterable2) {
                            JsonElement it = (JsonElement)t;
                            boolean bl3 = false;
                            JsonElement jsonElement4 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"it");
                            if (!(jsonElement4.isJsonObject() && Intrinsics.areEqual((Object)ElementKt.get((JsonElement)it, (String)"name"), (Object)options.get("name")))) continue;
                            v4 = t;
                            break block12;
                        }
                        v4 = null;
                    }
                    JsonElement linkByName = v4;
                    if (linkByName != null && linkByName.isJsonObject() && ElementKt.get((JsonElement)linkByName, (String)"templated").isJsonPrimitive() && ElementKt.getBool((JsonElement)ElementKt.get((JsonElement)linkByName, (String)"templated"))) {
                        String string = ElementKt.get((JsonElement)linkByName, (String)"href").toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"linkByName[\"href\"].toString()");
                        jsonElement3 = this.fetch(this.parseLinkUrl(string, options), false);
                    } else if (linkByName != null && linkByName.isJsonObject()) {
                        jsonElement3 = this.fetch(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkByName, (String)"href")));
                    } else {
                        throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' does not have an entry with name '" + options.get("name") + "'. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
                    }
                    return jsonElement3;
                }
                throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' has multiple entries. You need to filter by the link name. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            if (linkData.isJsonObject()) {
                return ElementKt.getObj((JsonElement)linkData).has("templated") && ElementKt.get((JsonElement)linkData, (String)"templated").isJsonPrimitive() && ElementKt.getBool((JsonElement)ElementKt.get((JsonElement)linkData, (String)"templated")) ? this.fetch(this.parseLinkUrl(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkData, (String)"href")), options), false) : this.fetch(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)linkData, (String)"href")));
            }
            throw (Throwable)new InvalidHalResponse("Expected link in map form in the response, but " + "found: " + linkData + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        throw (Throwable)new InvalidHalResponse("Expected a map of links in the response, but " + "found: " + links + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
    }

    @NotNull
    public final String parseLinkUrl(@NotNull String href, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        String result = "";
        MatchResult match = Regex.find$default((Regex)URL_TEMPLATE_REGEX, (CharSequence)href, (int)0, (int)2, null);
        int index = 0;
        while (match != null) {
            MatchResult.Destructured destructured;
            int start = match.getRange().getStart() - 1;
            if (start >= index) {
                int n = index;
                result = result + StringsKt.substring((String)href, (IntRange)new IntRange(n, start));
            }
            index = match.getRange().getEndInclusive() + 1;
            MatchResult.Destructured destructured2 = destructured = match.getDestructured();
            boolean bl = false;
            String key = (String)destructured2.getMatch().getGroupValues().get(1);
            result = result + this.encodePathParameter(options, key, match.getValue());
            match = URL_TEMPLATE_REGEX.find((CharSequence)href, index);
        }
        if (index < href.length()) {
            String string = href;
            StringBuilder stringBuilder = new StringBuilder().append(result);
            boolean bl = false;
            String string2 = string.substring(index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            result = stringBuilder.append(string3).toString();
        }
        return result;
    }

    private final String encodePathParameter(Map<String, ? extends Object> options, String key, String value) {
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        Object object = options.get(key);
        if (object == null || (object = object.toString()) == null) {
            object = value;
        }
        return escaper.escape((String)object);
    }

    public final void initPathInfo() {
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            jsonElement = this.fetch(ROOT);
        }
        this.pathInfo = jsonElement;
    }

    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        return this.uploadJson(path, bodyJson, uploadJson.1.INSTANCE, true);
    }

    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson, @NotNull BiFunction<String, String, Object> closure) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        return this.uploadJson(path, bodyJson, closure, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object uploadJson(@NotNull String path, @NotNull String bodyJson, @NotNull BiFunction<String, String, Object> closure, boolean encodePath) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)bodyJson, (String)"bodyJson");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        CloseableHttpClient client = this.setupHttpClient();
        HttpPut httpPut = (HttpPut)this.initialiseRequest((HttpMessage)new HttpPut(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, path, encodePath)));
        httpPut.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        httpPut.setEntity((HttpEntity)new StringEntity(bodyJson, ContentType.APPLICATION_JSON));
        Closeable closeable = (Closeable)client.execute((HttpUriRequest)httpPut);
        boolean bl = false;
        Throwable throwable = null;
        try {
            Object object;
            CloseableHttpResponse it = (CloseableHttpResponse)closeable;
            boolean bl2 = false;
            CloseableHttpResponse closeableHttpResponse = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
            if (statusLine.getStatusCode() < 300) {
                EntityUtils.consume((HttpEntity)it.getEntity());
                object = closure.apply("OK", it.getStatusLine().toString());
            } else {
                String body;
                boolean bl3;
                int n;
                Closeable closeable2;
                boolean bl4;
                Charset charset;
                InputStream inputStream;
                StatusLine statusLine2 = it.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"it.statusLine");
                if (statusLine2.getStatusCode() == 409) {
                    HttpEntity httpEntity = it.getEntity();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"it.entity");
                    InputStream inputStream2 = httpEntity.getContent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"it.entity.content");
                    inputStream = inputStream2;
                    charset = Charsets.UTF_8;
                    bl4 = false;
                    closeable2 = inputStream;
                    n = 0;
                    closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                    n = 8192;
                    bl3 = false;
                    body = TextStreamsKt.readText((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
                    StringBuilder stringBuilder = new StringBuilder();
                    StatusLine statusLine3 = it.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine3, (String)"it.statusLine");
                    StringBuilder stringBuilder2 = stringBuilder.append(statusLine3.getStatusCode()).append(' ');
                    StatusLine statusLine4 = it.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine4, (String)"it.statusLine");
                    object = closure.apply("FAILED", stringBuilder2.append(statusLine4.getReasonPhrase()).append(" - ").append(body).toString());
                } else {
                    HttpEntity httpEntity = it.getEntity();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"it.entity");
                    InputStream inputStream3 = httpEntity.getContent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream3, (String)"it.entity.content");
                    inputStream = inputStream3;
                    charset = Charsets.UTF_8;
                    bl4 = false;
                    closeable2 = inputStream;
                    n = 0;
                    closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                    n = 8192;
                    bl3 = false;
                    body = TextStreamsKt.readText((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
                    object = this.handleFailure((HttpResponse)it, body, closure);
                }
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public final Object handleFailure(@NotNull HttpResponse resp, @Nullable String body, @NotNull BiFunction<String, String, Object> closure) {
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        HttpEntity httpEntity = resp.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"resp.entity");
        if (httpEntity.getContentType() != null) {
            ContentType contentType;
            ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)resp.getEntity());
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
            if (HttpClientUtils.INSTANCE.isJsonResponse(contentType2)) {
                JsonElement jsonBody;
                String error = "";
                if (KotlinLanguageSupportKt.isNotEmpty((String)body) && (jsonBody = new JsonParser().parse(body)) != null && ElementKt.getObj((JsonElement)jsonBody).has("errors")) {
                    if (ElementKt.get((JsonElement)jsonBody, (String)"errors").isJsonArray()) {
                        StringBuilder stringBuilder = new StringBuilder().append(" - ");
                        JsonArray jsonArray = ElementKt.get((JsonElement)jsonBody, (String)"errors").getAsJsonArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"jsonBody[\"errors\"].asJsonArray");
                        error = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((Iterable)jsonArray), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.1.INSTANCE, (int)30, null)).toString();
                    } else if (ElementKt.get((JsonElement)jsonBody, (String)"errors").isJsonObject()) {
                        StringBuilder stringBuilder = new StringBuilder().append(" - ");
                        Set set = ElementKt.get((JsonElement)jsonBody, (String)"errors").getAsJsonObject().entrySet();
                        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"jsonBody[\"errors\"].asJsonObject.entrySet()");
                        error = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.2.INSTANCE, (int)30, null)).toString();
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                StatusLine statusLine = resp.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
                StringBuilder stringBuilder2 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
                StatusLine statusLine2 = resp.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"resp.statusLine");
                return closure.apply("FAILED", stringBuilder2.append(statusLine2.getReasonPhrase()).append(error).toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            StatusLine statusLine = resp.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
            StringBuilder stringBuilder3 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
            StatusLine statusLine3 = resp.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine3, (String)"resp.statusLine");
            return closure.apply("FAILED", stringBuilder3.append(statusLine3.getReasonPhrase()).append(" - ").append(body).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        StatusLine statusLine = resp.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
        StringBuilder stringBuilder4 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
        StatusLine statusLine4 = resp.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine4, (String)"resp.statusLine");
        return closure.apply("FAILED", stringBuilder4.append(statusLine4.getReasonPhrase()).append(" - ").append(body).toString());
    }

    @Override
    @Nullable
    public String linkUrl(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            Intrinsics.throwNpe();
        }
        if (ElementKt.getObj((JsonElement)jsonElement).has(LINKS)) {
            JsonElement linkData;
            JsonElement links;
            JsonElement jsonElement2 = this.pathInfo;
            if (jsonElement2 == null) {
                Intrinsics.throwNpe();
            }
            if ((links = ElementKt.get((JsonElement)jsonElement2, (String)LINKS)).isJsonObject() && ElementKt.getObj((JsonElement)links).has(name) && (linkData = ElementKt.get((JsonElement)links, (String)name)).isJsonObject() && ElementKt.getObj((JsonElement)linkData).has("href")) {
                return String.valueOf(Companion.fromJson(ElementKt.get((JsonElement)linkData, (String)"href")));
            }
        }
        return null;
    }

    @Override
    public void forAll(@NotNull String linkName, @NotNull Consumer<Map<String, Object>> closure) {
        JsonElement links;
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        this.initPathInfo();
        JsonElement jsonElement = this.pathInfo;
        if (jsonElement == null) {
            Intrinsics.throwNpe();
        }
        if ((links = ElementKt.get((JsonElement)jsonElement, (String)LINKS)).isJsonObject() && ElementKt.getObj((JsonElement)links).has(linkName)) {
            JsonElement matchingLink = ElementKt.get((JsonElement)links, (String)linkName);
            if (matchingLink.isJsonArray()) {
                JsonArray jsonArray = matchingLink.getAsJsonArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"matchingLink.asJsonArray");
                Iterable $this$forEach$iv = (Iterable)jsonArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement it = (JsonElement)element$iv;
                    boolean bl = false;
                    JsonElement jsonElement2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"it");
                    JsonObject jsonObject = jsonElement2.getAsJsonObject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"it.asJsonObject");
                    closure.accept(Companion.asMap(jsonObject));
                }
            } else {
                JsonObject jsonObject = matchingLink.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"matchingLink.asJsonObject");
                closure.accept(Companion.asMap(jsonObject));
            }
        }
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final Map<String, Object> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.options = map;
    }

    @JvmOverloads
    public HalClientBase(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.baseUrl = baseUrl;
        this.options = options;
        HalClientBase halClientBase = this;
        boolean bl = false;
        halClientBase.defaultHeaders = map = (Map)new LinkedHashMap();
    }

    @JvmOverloads
    public /* synthetic */ HalClientBase(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        this(string, map);
    }

    @JvmOverloads
    public HalClientBase(@NotNull String baseUrl) {
        this(baseUrl, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        URL_TEMPLATE_REGEX = new Regex("\\{(\\w+)\\}");
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> asMap(@NotNull JsonObject jsonObject) {
        return Companion.asMap(jsonObject);
    }

    @JvmStatic
    @Nullable
    public static final Object fromJson(@NotNull JsonElement jsonValue) {
        return Companion.fromJson(jsonValue);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\n\u001a\u0018\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00040\u0004\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lau/com/dius/pact/pactbroker/HalClientBase$Companion;", "Lmu/KLogging;", "()V", "LINKS", "", "ROOT", "URL_TEMPLATE_REGEX", "Lkotlin/text/Regex;", "getURL_TEMPLATE_REGEX", "()Lkotlin/text/Regex;", "asMap", "", "kotlin.jvm.PlatformType", "", "jsonObject", "Lcom/google/gson/JsonObject;", "fromJson", "jsonValue", "Lcom/google/gson/JsonElement;", "pact-jvm-pact-broker"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Regex getURL_TEMPLATE_REGEX() {
            return URL_TEMPLATE_REGEX;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Map<String, Object> asMap(@NotNull JsonObject jsonObject) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
            Set set = jsonObject.entrySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"jsonObject.entrySet()");
            Iterable $this$associate$iv = set;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = entry.getKey();
                Object v = entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"entry.value");
                Pair pair = TuplesKt.to(k, (Object)Companion.fromJson((JsonElement)v));
                boolean bl2 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final Object fromJson(@NotNull JsonElement jsonValue) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)jsonValue, (String)"jsonValue");
            if (jsonValue.isJsonObject()) {
                JsonObject jsonObject = jsonValue.getAsJsonObject();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"jsonValue.asJsonObject");
                object = this.asMap(jsonObject);
            } else if (jsonValue.isJsonArray()) {
                void $this$mapTo$iv$iv;
                JsonArray jsonArray = jsonValue.getAsJsonArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"jsonValue.asJsonArray");
                Iterable $this$map$iv = (Iterable)jsonArray;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement jsonElement = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                    Object object2 = Companion.fromJson((JsonElement)v3);
                    collection.add(object2);
                }
                object = (List)destination$iv$iv;
            } else if (jsonValue.isJsonNull()) {
                object = null;
            } else {
                JsonPrimitive primitive = jsonValue.getAsJsonPrimitive();
                JsonPrimitive jsonPrimitive = primitive;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"primitive");
                object = jsonPrimitive.isBoolean() ? Boolean.valueOf(primitive.getAsBoolean()) : (primitive.isNumber() ? primitive.getAsBigDecimal() : primitive.getAsString());
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

