/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.Consumer;
import au.com.dius.pact.model.InvalidPactException;
import au.com.dius.pact.model.MergeResult;
import au.com.dius.pact.model.Pact;
import au.com.dius.pact.model.PactMerge;
import au.com.dius.pact.model.PactReader;
import au.com.dius.pact.model.PactSource;
import au.com.dius.pact.model.PactSpecVersion;
import au.com.dius.pact.model.Provider;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.ToString;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.Map;
import java.util.jar.JarInputStream;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ToString
@EqualsAndHashCode(excludes={"metadata", "source"})
public abstract class BasePact
implements Pact,
GroovyObject {
    protected static final Map DEFAULT_METADATA;
    private static final String METADATA = "metadata";
    private Consumer consumer;
    private Provider provider;
    private Map metadata;
    private PactSource source;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    protected BasePact(Provider provider, Consumer consumer, Map map) {
        void metadata;
        void provider2;
        void consumer2;
        MetaClass metaClass;
        Map map2;
        this.metadata = map2 = DEFAULT_METADATA;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var6_6 = consumer2;
        this.consumer = IndyInterface.bootstrap("cast", "()", 0, var6_6);
        void var7_7 = provider2;
        this.provider = IndyInterface.bootstrap("cast", "()", 0, var7_7);
        void var8_8 = metadata;
        this.metadata = IndyInterface.bootstrap("cast", "()", 0, var8_8);
    }

    public static String lookupVersion() {
        CallSite url = IndyInterface.bootstrap("getProperty", "location", 1, IndyInterface.bootstrap("getProperty", "codeSource", 1, IndyInterface.bootstrap("getProperty", "protectionDomain", 0, BasePact.class)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)url, null)) {
            CallSite openStream = IndyInterface.bootstrap("invoke", "openStream", 0, url);
            try {
                CallSite jarStream = IndyInterface.bootstrap("init", "<init>", 0, JarInputStream.class, openStream);
                CallSite callSite = IndyInterface.bootstrap("invoke", "getValue", 1, IndyInterface.bootstrap("getProperty", "mainAttributes", 1, IndyInterface.bootstrap("getProperty", "manifest", 0, jarStream)), "Implementation-Version");
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "");
                return callSite2;
            }
            catch (Exception e) {
                IndyInterface.bootstrap("invoke", "warn", 0, log, "Could not load pact-jvm manifest", e);
                String string = "";
                return string;
            }
            {
                finally {
                }
            }
            finally {
                IndyInterface.bootstrap("invoke", "close", 0, openStream);
            }
        }
        return "";
    }

    public static Map objectToMap(Object object) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "respondsTo", 1, object, "toMap")) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toMap", 0, object));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertToMap", 0, BasePact.class, object));
    }

    public static Map convertToMap(Object object) {
        if (ScriptBytecodeAdapter.compareEqual((Object)object, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, object);
        }
        public class _convertToMap_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertToMap_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"class");
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertToMap_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public class _convertToMap_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertToMap_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                Reference v2 = new Reference(v);
                if (v2.get() instanceof Map) {
                    return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, IndyInterface.bootstrap("invoke", "convertToMap", 2, this, v2.get())});
                }
                if (v2.get() instanceof Collection) {
                    public class _closure5
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference v;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure5(Object _outerInstance, Object _thisObject, Reference v) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.v = reference = v;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "convertToMap", 2, this, this.v.get());
                        }

                        public Object getV() {
                            return this.v.get();
                        }

                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure5.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, IndyInterface.bootstrap("invoke", "collect", 0, v2.get(), new _closure5((Object)this, this.getThisObject(), v2))});
                }
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, v2.get()});
            }

            public Object call(Object k, Object v) {
                Reference v2 = new Reference(v);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v2.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertToMap_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "properties", 0, object), new _convertToMap_closure1(BasePact.class, BasePact.class)), new _convertToMap_closure2(BasePact.class, BasePact.class)));
    }

    public static Map metaData(String version) {
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pact-specification", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"version", version}), "pact-jvm", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"version", IndyInterface.bootstrap("invoke", "lookupVersion", 0, BasePact.class)})});
    }

    public void write(String pactDir, PactSpecVersion pactSpecVersion) {
        Reference pactSpecVersion2 = new Reference((Object)pactSpecVersion);
        File pactFile = this.fileForPact(pactDir);
        if (pactFile.exists()) {
            File file = pactFile;
            synchronized (file) {
                RandomAccessFile raf = new RandomAccessFile(pactFile, "rw");
                FileLock lock = raf.getChannel().lock();
                try {
                    Pact existingPact = PactReader.loadPact(BasePact.readLines(raf));
                    MergeResult result = PactMerge.merge(existingPact, this);
                    if (!result.getOk()) {
                        throw (Throwable)new InvalidPactException(result.getMessage());
                    }
                    raf.seek(0);
                    byte[] bytes = JsonOutput.prettyPrint((String)this.toJson((PactSpecVersion)((Object)pactSpecVersion2.get()))).getBytes("UTF-8");
                    raf.setLength(bytes.length);
                    raf.write(bytes);
                }
                finally {
                    lock.release();
                    raf.close();
                }
            }
        }
        pactFile.getParentFile().mkdirs();
        public class _write_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference pactSpecVersion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _write_closure3(Object _outerInstance, Object _thisObject, Reference pactSpecVersion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.pactSpecVersion = reference = pactSpecVersion;
            }

            public Object doCall(Object it) {
                DefaultGroovyMethods.print((Object)it, (Object)JsonOutput.prettyPrint((String)((BasePact)this.getThisObject()).toJson((PactSpecVersion)((Object)IndyInterface.bootstrap("cast", "()", 0, this.pactSpecVersion.get())))));
                return null;
            }

            public PactSpecVersion getPactSpecVersion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.pactSpecVersion.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _write_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ResourceGroovyMethods.withWriter((File)pactFile, (Closure)new _write_closure3(this, this, pactSpecVersion2));
    }

    private static String readLines(RandomAccessFile file) {
        StringBuilder data = new StringBuilder();
        String line = file.readLine();
        while (line != null) {
            String string;
            data.append(line);
            line = string = file.readLine();
        }
        return data.toString();
    }

    private String toJson(PactSpecVersion pactSpecVersion) {
        Map<String, ?> jsonMap = this.toMap(pactSpecVersion);
        if (jsonMap.containsKey(METADATA)) {
            Map map = DefaultGroovyMethods.plus((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Map)DEFAULT_METADATA);
            map.putAll((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, DefaultGroovyMethods.getAt(jsonMap, (Object)METADATA), Map.class)));
            jsonMap.put(METADATA, map);
        } else {
            jsonMap.put(METADATA, DEFAULT_METADATA);
        }
        return JsonOutput.toJson(jsonMap);
    }

    public Map mergePacts(Map pact, File pactFile) {
        CallSite newPact = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), pact));
        CallSite json = IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonSlurper.class), pactFile);
        String pactSpec = "pact-specification";
        CallSite version = IndyInterface.bootstrap("getProperty", "version", 1, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", METADATA, 1, json), pactSpec));
        CallSite pactVersion = IndyInterface.bootstrap("getProperty", "version", 1, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", METADATA, 0, pact), pactSpec));
        if (DefaultTypeTransformation.booleanUnbox((Object)version) && ScriptBytecodeAdapter.compareNotEqual((Object)version, (Object)pactVersion)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidPactException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{pactFile}, new String[]{"Could not merge pact into '", "': pact specification version is "}), new GStringImpl(new Object[]{pactVersion, version}, new String[]{"", ", while the file is version ", ""}))));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "interactions", 0, json), null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidPactException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{pactFile}, new String[]{"Could not merge pact into '", "': file is not a message pact "}), "(it contains request/response interactions)")));
        }
        public class _mergePacts_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mergePacts_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "description", 0, it);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergePacts_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "unique", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "messages", 0, newPact), IndyInterface.bootstrap("getProperty", "messages", 0, json)), new _mergePacts_closure4(this, this));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)newPact, (String)"messages");
        return newPact;
    }

    public File fileForPact(String pactDir) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, pactDir, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, this.consumer), IndyInterface.bootstrap("getProperty", "name", 0, this.provider)}, new String[]{"", "-", ".json"})));
    }

    @Override
    public boolean compatibleTo(Pact other) {
        return ScriptBytecodeAdapter.compareEqual((Object)this.provider, (Object)IndyInterface.bootstrap("getProperty", "provider", 0, other)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isAssignableFrom", 0, IndyInterface.bootstrap("getProperty", "class", 4, this), IndyInterface.bootstrap("getProperty", "class", 0, other)));
    }

    public String toString() {
        CallSite _result = IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class);
        Boolean $toStringFirst = Boolean.TRUE;
        IndyInterface.bootstrap("invoke", "append", 0, _result, "au.com.dius.pact.model.BasePact(");
        if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
            Boolean bl;
            $toStringFirst = bl = Boolean.FALSE;
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 0, IndyInterface.bootstrap("invoke", "getConsumer", 2, this), this)) != false) {
            IndyInterface.bootstrap("invoke", "append", 0, _result, "(this)");
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, InvokerHelper.class, IndyInterface.bootstrap("invoke", "getConsumer", 2, this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
            Boolean bl;
            $toStringFirst = bl = Boolean.FALSE;
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 0, IndyInterface.bootstrap("invoke", "getProvider", 2, this), this)) != false) {
            IndyInterface.bootstrap("invoke", "append", 0, _result, "(this)");
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, InvokerHelper.class, IndyInterface.bootstrap("invoke", "getProvider", 2, this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
            Boolean bl;
            $toStringFirst = bl = Boolean.FALSE;
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 0, IndyInterface.bootstrap("invoke", "getMetadata", 2, this), this)) != false) {
            IndyInterface.bootstrap("invoke", "append", 0, _result, "(this)");
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, InvokerHelper.class, IndyInterface.bootstrap("invoke", "getMetadata", 2, this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
            Boolean bl;
            $toStringFirst = bl = Boolean.FALSE;
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 0, IndyInterface.bootstrap("invoke", "getSource", 2, this), this)) != false) {
            IndyInterface.bootstrap("invoke", "append", 0, _result, "(this)");
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, InvokerHelper.class, IndyInterface.bootstrap("invoke", "getSource", 2, this)));
        }
        IndyInterface.bootstrap("invoke", "append", 0, _result, ")");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, _result));
    }

    public int hashCode() {
        CallSite _result = IndyInterface.bootstrap("invoke", "initHash", 0, HashCodeHelper.class);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 0, IndyInterface.bootstrap("invoke", "getConsumer", 2, this), this)) == false) {
            CallSite callSite;
            _result = callSite = IndyInterface.bootstrap("invoke", "updateHash", 0, HashCodeHelper.class, _result, IndyInterface.bootstrap("invoke", "getConsumer", 2, this));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 0, IndyInterface.bootstrap("invoke", "getProvider", 2, this), this)) == false) {
            CallSite callSite;
            _result = callSite = IndyInterface.bootstrap("invoke", "updateHash", 0, HashCodeHelper.class, _result, IndyInterface.bootstrap("invoke", "getProvider", 2, this));
        }
        return DefaultTypeTransformation.intUnbox((Object)_result);
    }

    public boolean canEqual(Object other) {
        return other instanceof BasePact;
    }

    public boolean equals(Object other) {
        if (ScriptBytecodeAdapter.compareEqual((Object)other, null)) {
            return false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 2, this, other)) != false) {
            return true;
        }
        if (!(other instanceof BasePact)) {
            return false;
        }
        BasePact otherTyped = (BasePact)other;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "canEqual", 0, otherTyped, this)) == false) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getConsumer", 2, this), (Object)IndyInterface.bootstrap("invoke", "getConsumer", 0, otherTyped))) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getProvider", 2, this), (Object)IndyInterface.bootstrap("invoke", "getProvider", 0, otherTyped)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BasePact.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Map map;
        DEFAULT_METADATA = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pact-specification", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"version", "3.0.0"}), "pact-jvm", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"version", IndyInterface.bootstrap("invoke", "lookupVersion", 0, BasePact.class)})});
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "au.com.dius.pact.model.BasePact");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Override
    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Map getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map map) {
        this.metadata = map;
    }

    @Override
    public PactSource getSource() {
        return this.source;
    }

    public void setSource(PactSource pactSource) {
        this.source = pactSource;
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }
}

