/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model;

import au.com.dius.pact.model.Interaction;
import au.com.dius.pact.model.MergeResult;
import au.com.dius.pact.model.Pact;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lau/com/dius/pact/model/PactMerge;", "Lmu/KLogging;", "()V", "merge", "Lau/com/dius/pact/model/MergeResult;", "newPact", "Lau/com/dius/pact/model/Pact;", "existing", "pact-jvm-model_main"})
public final class PactMerge
extends KLogging {
    public static final PactMerge INSTANCE;

    @JvmStatic
    @NotNull
    public static final MergeResult merge(@NotNull Pact newPact, @NotNull Pact existing) {
        Pair it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)newPact, (String)"newPact");
        Intrinsics.checkParameterIsNotNull((Object)existing, (String)"existing");
        if (!newPact.compatibleTo(existing)) {
            return new MergeResult(false, "Cannot merge pacts as they are not compatible", null, 4, null);
        }
        if (existing.getInteractions().isEmpty() || newPact.getInteractions().isEmpty()) {
            existing.mergeInteractions(newPact.getInteractions());
            return new MergeResult(true, "", existing);
        }
        Iterable $receiver$iv = Lists.cartesianProduct((List[])new List[]{existing.getInteractions(), newPact.getInteractions()});
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to(it.get(0), it.get(1));
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            Interaction interaction = (Interaction)it.getFirst();
            Object object = it.getSecond();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.second");
            if (!interaction.conflictsWith((Interaction)object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflicts = (List)destination$iv$iv;
        if (conflicts.isEmpty()) {
            existing.mergeInteractions(newPact.getInteractions());
            return new MergeResult(true, "", existing);
        }
        return new MergeResult(false, "Cannot merge pacts as there were " + conflicts.size() + " conflict(s) " + ("between the interactions - " + CollectionsKt.joinToString$default((Iterable)conflicts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), null, 4, null);
    }

    private PactMerge() {
        INSTANCE = this;
    }

    static {
        new PactMerge();
    }
}

