/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.util;

public class Optional<V> {
    private V value = null;

    private Optional(V value) {
        this.value = value;
    }

    private Optional() {
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public V get() {
        return this.value;
    }

    public static <V> Optional<V> of(V value) {
        return new Optional<V>(value);
    }

    public static <V> Optional<V> empty() {
        return new Optional<V>();
    }

    public static <V> Optional<V> ofNullable(V value) {
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public V orElseThrow(RuntimeException exception) {
        if (this.value == null) {
            throw exception;
        }
        return this.value;
    }

    public V orElse(V other) {
        return this.value == null ? other : this.value;
    }
}

