/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.model.generators;

import au.com.dius.pact.model.ContentType;
import au.com.dius.pact.model.OptionalBody;
import au.com.dius.pact.model.generators.Category;
import au.com.dius.pact.model.generators.ContentTypeHandler;
import au.com.dius.pact.model.generators.Generator;
import au.com.dius.pact.model.generators.Generators$WhenMappings;
import au.com.dius.pact.model.generators.GeneratorsKt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00042\u001a\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00140\u0016J!\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0003J+\u0010\u0018\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0001J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lau/com/dius/pact/model/generators/Generators;", "", "categories", "", "Lau/com/dius/pact/model/generators/Category;", "", "Lau/com/dius/pact/model/generators/Generator;", "(Ljava/util/Map;)V", "getCategories", "()Ljava/util/Map;", "addGenerator", "category", "key", "generator", "applyBodyGenerators", "Lau/com/dius/pact/model/OptionalBody;", "body", "contentType", "Lau/com/dius/pact/model/ContentType;", "applyGenerator", "", "closure", "Lkotlin/Function2;", "component1", "copy", "processBody", "value", "Companion", "pact-jvm-model_main"})
public final class Generators {
    @NotNull
    private final Map<Category, Map<String, Generator>> categories;
    public static final Companion Companion = new Companion(null);

    @JvmOverloads
    @NotNull
    public final Generators addGenerator(@NotNull Category category, @Nullable String key, @NotNull Generator generator) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        if (this.categories.containsKey((Object)category) && this.categories.get((Object)category) != null) {
            Map<String, Generator> map = this.categories.get((Object)category);
            if (map != null) {
                String string = key;
                if (string == null) {
                    string = "";
                }
                map.put(string, generator);
            }
        } else {
            Map<Category, Map<String, Generator>> map = this.categories;
            Pair[] pairArray = new Pair[1];
            String string = key;
            if (string == null) {
                string = "";
            }
            pairArray[0] = TuplesKt.to((Object)string, (Object)generator);
            Map map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            map.put(category, map2);
        }
        return this;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ Generators addGenerator$default(Generators generators, Category category, String string, Generator generator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addGenerator");
        }
        if ((n & 2) != 0) {
            string = "";
        }
        return generators.addGenerator(category, string, generator);
    }

    @JvmOverloads
    @NotNull
    public final Generators addGenerator(@NotNull Category category, @NotNull Generator generator) {
        return Generators.addGenerator$default(this, category, null, generator, 2, null);
    }

    public final void applyGenerator(@NotNull Category category, @NotNull Function2<? super String, ? super Generator, Unit> closure) {
        Map<String, Generator> categoryValues;
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        if (this.categories.containsKey((Object)category) && this.categories.get((Object)category) != null && (categoryValues = this.categories.get((Object)category)) != null) {
            Map<String, Generator> map = categoryValues;
            Iterator<Map.Entry<String, Generator>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Generator> entry;
                Map.Entry<String, Generator> entry2 = entry = iterator.next();
                String key = entry2.getKey();
                Map.Entry<String, Generator> entry3 = entry;
                Generator value = entry3.getValue();
                closure.invoke((Object)key, (Object)value);
            }
        }
    }

    @NotNull
    public final OptionalBody applyBodyGenerators(@NotNull OptionalBody body, @NotNull ContentType contentType) {
        OptionalBody optionalBody;
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        switch (Generators$WhenMappings.$EnumSwitchMapping$0[body.getState().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                optionalBody = body;
                break;
            }
            case 4: {
                if (contentType.isJson()) {
                    String string = body.getValue();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    optionalBody = this.processBody(string, "application/json");
                    break;
                }
                if (contentType.isXml()) {
                    String string = body.getValue();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    optionalBody = this.processBody(string, "application/xml");
                    break;
                }
                optionalBody = body;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return optionalBody;
    }

    private final OptionalBody processBody(String value, String contentType) {
        ContentTypeHandler handler = GeneratorsKt.getContentTypeHandlers().get(contentType);
        Object object = handler;
        if (object == null || (object = object.processBody(value, (Function1<? super ContentTypeHandler, Unit>)((Function1)new Function1<ContentTypeHandler, Unit>(this){
            final /* synthetic */ Generators this$0;

            public final void invoke(@NotNull ContentTypeHandler handler) {
                Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
                this.this$0.applyGenerator(Category.BODY, (Function2<? super String, ? super Generator, Unit>)((Function2)new Function2<String, Generator, Unit>(handler){
                    final /* synthetic */ ContentTypeHandler $handler;

                    public final void invoke(@NotNull String key, @Nullable Generator generator) {
                        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                        if (generator != null) {
                            this.$handler.applyKey(key, generator);
                        }
                    }
                    {
                        this.$handler = contentTypeHandler;
                        super(2);
                    }
                }));
            }
            {
                this.this$0 = generators;
                super(1);
            }
        }))) == null) {
            object = OptionalBody.Companion.body(value);
        }
        return object;
    }

    @NotNull
    public final Map<Category, Map<String, Generator>> getCategories() {
        return this.categories;
    }

    public Generators(@NotNull Map<Category, Map<String, Generator>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        this.categories = categories;
    }

    public /* synthetic */ Generators(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new HashMap();
        }
        this(map);
    }

    public Generators() {
        this(null, 1, null);
    }

    @NotNull
    public final Map<Category, Map<String, Generator>> component1() {
        return this.categories;
    }

    @NotNull
    public final Generators copy(@NotNull Map<Category, Map<String, Generator>> categories) {
        Intrinsics.checkParameterIsNotNull(categories, (String)"categories");
        return new Generators(categories);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Generators copy$default(Generators generators, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            map = generators.categories;
        }
        return generators.copy(map);
    }

    public String toString() {
        return "Generators(categories=" + this.categories + ")";
    }

    public int hashCode() {
        Map<Category, Map<String, Generator>> map = this.categories;
        return map != null ? ((Object)map).hashCode() : 0;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Generators)) break block3;
                Generators generators = (Generators)object;
                if (!Intrinsics.areEqual(this.categories, generators.categories)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Generators fromMap(@Nullable Map<String, ? extends Object> map) {
        return Companion.fromMap(map);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006H\u0007\u00a8\u0006\b"}, d2={"Lau/com/dius/pact/model/generators/Generators$Companion;", "", "()V", "fromMap", "Lau/com/dius/pact/model/generators/Generators;", "map", "", "", "pact-jvm-model_main"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Generators fromMap(@Nullable Map<String, ? extends Object> map) {
            return new Generators(null, 1, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

