/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.pactbroker;

import au.com.dius.pact.com.github.michaelbull.result.Err;
import au.com.dius.pact.com.github.michaelbull.result.Ok;
import au.com.dius.pact.com.github.michaelbull.result.Result;
import au.com.dius.pact.core.pactbroker.CanIDeployResult;
import au.com.dius.pact.core.pactbroker.HalClient;
import au.com.dius.pact.core.pactbroker.IHalClient;
import au.com.dius.pact.core.pactbroker.Latest;
import au.com.dius.pact.core.pactbroker.NotFoundHalResponse;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerConsumer;
import au.com.dius.pact.core.pactbroker.PactResponse;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import com.github.salomonbrys.kotson.BuilderKt;
import com.github.salomonbrys.kotson.ElementKt;
import com.github.salomonbrys.kotson.MutableKt;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.dmfs.rfc3986.encoding.Precoded;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\b\b\u0002\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010(\u001a\u00020)H\u0016J4\u0010*\u001a\u00020+2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010-\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003JJ\u0010.\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\b\u0012\u000600j\u0002`10/2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0017J*\u00102\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00032\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0017R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00068"}, d2={"Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "", "pactBrokerUrl", "", "(Ljava/lang/String;)V", "options", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getOptions", "()Ljava/util/Map;", "getPactBrokerUrl", "()Ljava/lang/String;", "buildMatrixQuery", "pacticipant", "pacticipantVersion", "latest", "Lau/com/dius/pact/core/pactbroker/Latest;", "to", "buildPayload", "Lcom/google/gson/JsonObject;", "result", "Lau/com/dius/pact/core/pactbroker/TestResult;", "version", "buildUrl", "canIDeploy", "Lau/com/dius/pact/core/pactbroker/CanIDeployResult;", "fetchConsumers", "", "Lau/com/dius/pact/core/pactbroker/PactBrokerConsumer;", "provider", "fetchConsumersWithTag", "tag", "fetchLatestConsumersWithNoTag", "fetchPact", "Lau/com/dius/pact/core/pactbroker/PactResponse;", "url", "encodePath", "", "getUrlForProvider", "providerName", "newHalClient", "Lau/com/dius/pact/core/pactbroker/IHalClient;", "publishProviderTag", "", "docAttributes", "name", "publishVerificationResults", "Lau/com/dius/pact/com/github/michaelbull/result/Result;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "uploadPactFile", "pactFile", "Ljava/io/File;", "unescapedVersion", "tags", "Companion", "pact-jvm-core-pact-broker"})
public class PactBrokerClient {
    @NotNull
    private final String pactBrokerUrl;
    @NotNull
    private final Map<String, Object> options;
    @NotNull
    public static final String LATEST_PROVIDER_PACTS_WITH_NO_TAG = "pb:latest-untagged-pact-version";
    @NotNull
    public static final String LATEST_PROVIDER_PACTS = "pb:latest-provider-pacts";
    @NotNull
    public static final String LATEST_PROVIDER_PACTS_WITH_TAG = "pb:latest-provider-pacts-with-tag";
    @NotNull
    public static final String PROVIDER = "pb:provider";
    @NotNull
    public static final String PROVIDER_TAG_VERSION = "pb:version-tag";
    @NotNull
    public static final String PACTS = "pb:pacts";
    @NotNull
    public static final String UTF8 = "UTF-8";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public List<PactBrokerConsumer> fetchConsumers(@NotNull String provider) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        try {
            IHalClient halClient = this.newHalClient();
            boolean bl = false;
            List consumers = new ArrayList();
            halClient.navigate(MapsKt.mapOf((Pair)TuplesKt.to((Object)"provider", (Object)provider)), LATEST_PROVIDER_PACTS).forAll(PACTS, (Consumer<Map<String, Object>>)new Consumer<Map<String, ? extends Object>>(this, consumers){
                final /* synthetic */ PactBrokerClient this$0;
                final /* synthetic */ List $consumers;

                public final void accept(@NotNull Map<String, ? extends Object> pact) {
                    Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
                    String href = ((Object)new Precoded((CharSequence)String.valueOf(pact.get("href"))).decoded()).toString();
                    String name = String.valueOf(pact.get("name"));
                    if (this.this$0.getOptions().containsKey("authentication")) {
                        Object object = this.this$0.getOptions().get("authentication");
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                        }
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), (List)object, null, 16, null));
                    } else {
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), null, null, 24, null));
                    }
                }
                {
                    this.this$0 = pactBrokerClient;
                    this.$consumers = list;
                }
            });
            list = consumers;
        }
        catch (NotFoundHalResponse e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public List<PactBrokerConsumer> fetchConsumersWithTag(@NotNull String provider, @NotNull String tag) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        try {
            IHalClient halClient = this.newHalClient();
            boolean bl = false;
            List consumers = new ArrayList();
            halClient.navigate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"provider", (Object)provider), TuplesKt.to((Object)"tag", (Object)tag)}), LATEST_PROVIDER_PACTS_WITH_TAG).forAll(PACTS, (Consumer<Map<String, Object>>)new Consumer<Map<String, ? extends Object>>(this, consumers, tag){
                final /* synthetic */ PactBrokerClient this$0;
                final /* synthetic */ List $consumers;
                final /* synthetic */ String $tag;

                public final void accept(@NotNull Map<String, ? extends Object> pact) {
                    Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
                    String href = ((Object)new Precoded((CharSequence)String.valueOf(pact.get("href"))).decoded()).toString();
                    String name = String.valueOf(pact.get("name"));
                    if (this.this$0.getOptions().containsKey("authentication")) {
                        Object object = this.this$0.getOptions().get("authentication");
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                        }
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), (List)object, this.$tag));
                    } else {
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), CollectionsKt.emptyList(), this.$tag));
                    }
                }
                {
                    this.this$0 = pactBrokerClient;
                    this.$consumers = list;
                    this.$tag = string;
                }
            });
            list = consumers;
        }
        catch (NotFoundHalResponse e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmOverloads
    @Nullable
    public Object uploadPactFile(@NotNull File pactFile, @NotNull String unescapedVersion, @NotNull List<String> tags) {
        Intrinsics.checkParameterIsNotNull((Object)pactFile, (String)"pactFile");
        Intrinsics.checkParameterIsNotNull((Object)unescapedVersion, (String)"unescapedVersion");
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        String pactText = FilesKt.readText$default((File)pactFile, null, (int)1, null);
        JsonElement pact = JsonParser.parseString((String)pactText);
        IHalClient halClient = this.newHalClient();
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        JsonElement jsonElement = pact;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"pact");
        String providerName = escaper.escape(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)ElementKt.get((JsonElement)jsonElement, (String)"provider"), (String)"name")));
        String consumerName = UrlEscapers.urlPathSegmentEscaper().escape(ElementKt.getString((JsonElement)ElementKt.get((JsonElement)ElementKt.get((JsonElement)pact, (String)"consumer"), (String)"name")));
        String version = UrlEscapers.urlPathSegmentEscaper().escape(unescapedVersion);
        String uploadPath = "/pacts/provider/" + providerName + "/consumer/" + consumerName + "/version/" + version;
        Collection collection = tags;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String string = consumerName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"consumerName");
            String string2 = version;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"version");
            Companion.uploadTags(halClient, string, string2, tags);
        }
        return halClient.uploadJson(uploadPath, pactText, uploadPactFile.1.INSTANCE, false);
    }

    public static /* synthetic */ Object uploadPactFile$default(PactBrokerClient pactBrokerClient, File file, String string, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: uploadPactFile");
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return pactBrokerClient.uploadPactFile(file, string, list);
    }

    @JvmOverloads
    @Nullable
    public Object uploadPactFile(@NotNull File pactFile, @NotNull String unescapedVersion) {
        return PactBrokerClient.uploadPactFile$default(this, pactFile, unescapedVersion, null, 4, null);
    }

    @Nullable
    public String getUrlForProvider(@NotNull String providerName, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        IHalClient halClient = this.newHalClient();
        CharSequence charSequence = tag;
        boolean bl = false;
        if (charSequence.length() == 0 || Intrinsics.areEqual((Object)tag, (Object)"latest")) {
            halClient.navigate(MapsKt.mapOf((Pair)TuplesKt.to((Object)"provider", (Object)providerName)), LATEST_PROVIDER_PACTS);
        } else {
            halClient.navigate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"provider", (Object)providerName), TuplesKt.to((Object)"tag", (Object)tag)}), LATEST_PROVIDER_PACTS_WITH_TAG);
        }
        return halClient.linkUrl(PACTS);
    }

    @NotNull
    public PactResponse fetchPact(@NotNull String url, boolean encodePath) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        JsonObject halDoc = ElementKt.getObj((JsonElement)this.newHalClient().fetch(url, encodePath));
        JsonElement jsonElement = halDoc.get("_links");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"halDoc[\"_links\"]");
        return new PactResponse(halDoc, HalClient.Companion.asMap(ElementKt.getObj((JsonElement)jsonElement)));
    }

    public static /* synthetic */ PactResponse fetchPact$default(PactBrokerClient pactBrokerClient, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchPact");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return pactBrokerClient.fetchPact(string, bl);
    }

    @NotNull
    public IHalClient newHalClient() {
        return new HalClient(this.pactBrokerUrl, this.options);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public Result<Boolean, Exception> publishVerificationResults(@NotNull Map<String, ? extends Object> docAttributes, @NotNull TestResult result, @NotNull String version, @Nullable String buildUrl) {
        Result<Boolean, Exception> result2;
        Object object;
        String string;
        Object object2;
        Object object3;
        Map map;
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(docAttributes, (String)"docAttributes");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        IHalClient halClient = this.newHalClient();
        Map<String, ? extends Object> $this$mapKeys$iv = docAttributes;
        boolean $i$f$mapKeys = false;
        Map<String, ? extends Object> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Object object4 = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            object3 = (String)it.getKey();
            boolean bl2 = false;
            String string2 = object3;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            object2 = (Map.Entry)element$iv$iv$iv;
            String string3 = string;
            object = map;
            boolean bl3 = false;
            object4 = it$iv$iv.getValue();
            object.put(string3, object4);
        }
        Object publishLink = destination$iv$iv.get("pb:publish-verification-results");
        if (publishLink instanceof Map) {
            void $this$mapKeysTo$iv$iv2;
            JsonObject jsonObject = this.buildPayload(result, version, buildUrl);
            Map $this$mapKeys$iv2 = (Map)publishLink;
            boolean $i$f$mapKeys2 = false;
            Map $i$f$mapKeysTo2 = $this$mapKeys$iv2;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv2.size()));
            boolean $i$f$mapKeysTo3 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapKeysTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it$iv$iv;
                void it;
                object3 = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv2;
                boolean bl = false;
                object2 = String.valueOf(it.getKey());
                boolean bl4 = false;
                Object object5 = object2;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((String)object5).toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                object = (Map.Entry)element$iv$iv$iv;
                String string4 = string;
                Map map3 = map;
                boolean bl5 = false;
                object3 = it$iv$iv.getValue();
                map3.put(string4, object3);
            }
            Map lowercaseMap = destination$iv$iv2;
            if (lowercaseMap.containsKey("href")) {
                String string5 = String.valueOf(lowercaseMap.get("href"));
                String string6 = jsonObject.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"jsonObject.toString()");
                result2 = halClient.postJson(string5, string6);
            } else {
                result2 = (Result)new Err((Object)new RuntimeException("Unable to publish verification results as there is no pb:publish-verification-results link"));
            }
        } else {
            result2 = (Result<Boolean, Exception>)new Err((Object)new RuntimeException("Unable to publish verification results as there is no pb:publish-verification-results link"));
        }
        return result2;
    }

    public static /* synthetic */ Result publishVerificationResults$default(PactBrokerClient pactBrokerClient, Map map, TestResult testResult, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishVerificationResults");
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return pactBrokerClient.publishVerificationResults(map, testResult, string, string2);
    }

    @JvmOverloads
    @NotNull
    public Result<Boolean, Exception> publishVerificationResults(@NotNull Map<String, ? extends Object> docAttributes, @NotNull TestResult result, @NotNull String version) {
        return PactBrokerClient.publishVerificationResults$default(this, docAttributes, result, version, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsonObject buildPayload(@NotNull TestResult result, @NotNull String version, @Nullable String buildUrl) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        JsonObject jsonObject = BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"success", (Object)result.toBoolean()), TuplesKt.to((Object)"providerApplicationVersion", (Object)version)});
        if (buildUrl != null) {
            jsonObject.add("buildUrl", (JsonElement)BuilderKt.toJson((String)buildUrl));
        }
        Companion.getLogger().debug((Function0)new Function0<String>(result){
            final /* synthetic */ TestResult $result;

            @NotNull
            public final String invoke() {
                return "Test result = " + this.$result;
            }
            {
                this.$result = testResult;
                super(0);
            }
        });
        if (result instanceof TestResult.Failed) {
            Collection collection = ((TestResult.Failed)result).getResults();
            boolean bl = false;
            if (!collection.isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable answer$iv$iv$iv;
                Object key$iv$iv;
                Map $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = ((TestResult.Failed)result).getResults();
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Object destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator iterator = $this$groupByTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object element$iv$iv = iterator.next();
                    Map it = (Map)element$iv$iv;
                    boolean bl2 = false;
                    key$iv$iv = it.get("interactionId");
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$map$iv = destination$iv$iv;
                boolean $i$f$map = false;
                $this$groupByTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv;
                boolean bl4 = false;
                for (Map.Entry item$iv$iv : iterator.entrySet()) {
                    Object v5;
                    JsonObject interactionJson;
                    Object object;
                    block39: {
                        Iterable $this$flatMapTo$iv$iv;
                        Iterable $this$filterTo$iv$iv;
                        void mismatches;
                        key$iv$iv = item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl5 = false;
                        Iterable $this$filter$iv = (Iterable)mismatches.getValue();
                        boolean $i$f$filter = false;
                        answer$iv$iv$iv = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Map it = (Map)element$iv$iv;
                            boolean bl6 = false;
                            if (!(!it.containsKey("exception"))) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        Iterable $this$flatMap$iv = (List)destination$iv$iv2;
                        boolean $i$f$flatMap = false;
                        $this$filterTo$iv$iv = $this$flatMap$iv;
                        destination$iv$iv2 = new ArrayList();
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                            Pair pair;
                            Object object2;
                            Object object3;
                            Object $this$map$iv2;
                            Object destination$iv$iv3;
                            Map $this$filter$iv2;
                            List list;
                            Object element$iv$iv22;
                            Map mismatch = (Map)element$iv$iv;
                            boolean bl7 = false;
                            Object v = mismatch.get("type");
                            if (Intrinsics.areEqual(v, (Object)"body")) {
                                Object bodyMismatches = mismatch.get("comparison");
                                if (bodyMismatches instanceof Map) {
                                    void $this$flatMapTo$iv$iv2;
                                    Iterable $this$filterTo$iv$iv2;
                                    Iterable $this$filter$iv3 = ((Map)bodyMismatches).entrySet();
                                    boolean $i$f$filter2 = false;
                                    Iterable iterable2 = $this$filter$iv3;
                                    Collection destination$iv$iv4 = new ArrayList();
                                    boolean $i$f$filterTo2 = false;
                                    for (Object element$iv$iv22 : $this$filterTo$iv$iv2) {
                                        Map.Entry it = (Map.Entry)element$iv$iv22;
                                        boolean bl8 = false;
                                        if (!(Intrinsics.areEqual(it.getKey(), (Object)"diff") ^ true)) continue;
                                        destination$iv$iv4.add(element$iv$iv22);
                                    }
                                    Iterable $this$flatMap$iv2 = (List)destination$iv$iv4;
                                    boolean $i$f$flatMap2 = false;
                                    $this$filterTo$iv$iv2 = $this$flatMap$iv2;
                                    destination$iv$iv4 = new ArrayList();
                                    boolean $i$f$flatMapTo2 = false;
                                    for (Object element$iv$iv22 : $this$flatMapTo$iv$iv2) {
                                        void $this$mapTo$iv$iv2;
                                        Map.Entry entry = (Map.Entry)element$iv$iv22;
                                        boolean bl9 = false;
                                        Object v2 = entry.getValue();
                                        if (v2 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
                                        }
                                        List values = (List)v2;
                                        Iterable $this$map$iv3 = values;
                                        boolean $i$f$map2 = false;
                                        Iterable iterable3 = $this$map$iv3;
                                        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                                        boolean $i$f$mapTo2 = false;
                                        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                            void it;
                                            Map map = (Map)item$iv$iv2;
                                            Collection collection2 = destination$iv$iv5;
                                            boolean bl10 = false;
                                            JsonObject jsonObject2 = BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"attribute", (Object)"body"), TuplesKt.to((Object)"identifier", entry.getKey()), TuplesKt.to((Object)"description", it.get("mismatch")), TuplesKt.to((Object)"diff", it.get("diff"))});
                                            collection2.add(jsonObject2);
                                        }
                                        Iterable list$iv$iv = (List)destination$iv$iv5;
                                        CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                                    }
                                    list = (List)destination$iv$iv4;
                                } else {
                                    list = CollectionsKt.listOf((Object)BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"attribute", (Object)"body"), TuplesKt.to((Object)"description", (Object)String.valueOf(bodyMismatches))}));
                                }
                            } else if (Intrinsics.areEqual(v, (Object)"status")) {
                                list = CollectionsKt.listOf((Object)BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"attribute", (Object)"status"), TuplesKt.to((Object)"description", mismatch.get("description"))}));
                            } else if (Intrinsics.areEqual(v, (Object)"header")) {
                                void $this$mapTo$iv$iv3;
                                Map $this$filterTo$iv$iv3;
                                $this$filter$iv2 = mismatch;
                                boolean $i$f$filter3 = false;
                                Map $i$f$flatMap2 = $this$filter$iv2;
                                destination$iv$iv3 = new LinkedHashMap();
                                boolean $i$f$filterTo3 = false;
                                void $i$f$flatMapTo2 = $this$filterTo$iv$iv3;
                                boolean bl11 = false;
                                element$iv$iv22 = $i$f$flatMapTo2.entrySet().iterator();
                                while (element$iv$iv22.hasNext()) {
                                    Map.Entry element$iv$iv3;
                                    Map.Entry it = element$iv$iv3 = element$iv$iv22.next();
                                    boolean bl12 = false;
                                    if (!(Intrinsics.areEqual((Object)((String)it.getKey()), (Object)"interactionId") ^ true)) continue;
                                    destination$iv$iv3.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
                                }
                                $this$map$iv2 = destination$iv$iv3;
                                boolean $i$f$map3 = false;
                                $this$filterTo$iv$iv3 = $this$map$iv2;
                                destination$iv$iv3 = new ArrayList($this$map$iv2.size());
                                boolean $i$f$mapTo3 = false;
                                $i$f$flatMapTo2 = $this$mapTo$iv$iv3;
                                bl11 = false;
                                element$iv$iv22 = $i$f$flatMapTo2.entrySet().iterator();
                                while (element$iv$iv22.hasNext()) {
                                    Pair pair2;
                                    Map.Entry item$iv$iv3;
                                    Map.Entry it = item$iv$iv3 = element$iv$iv22.next();
                                    object3 = destination$iv$iv3;
                                    boolean bl13 = false;
                                    if (Intrinsics.areEqual((Object)((String)it.getKey()), (Object)"type")) {
                                        pair2 = TuplesKt.to((Object)"attribute", it.getValue());
                                    } else {
                                        object2 = it;
                                        boolean bl14 = false;
                                        pair2 = new Pair(object2.getKey(), object2.getValue());
                                    }
                                    pair = pair2;
                                    object3.add(pair);
                                }
                                list = CollectionsKt.listOf((Object)BuilderKt.jsonObject((Iterable)((List)destination$iv$iv3)));
                            } else if (Intrinsics.areEqual(v, (Object)"metadata")) {
                                void $this$flatMapTo$iv$iv3;
                                Map $this$filterTo$iv$iv4;
                                $this$filter$iv2 = mismatch;
                                boolean $i$f$filter4 = false;
                                Map $this$mapTo$iv$iv3 = $this$filter$iv2;
                                destination$iv$iv3 = new LinkedHashMap();
                                boolean $i$f$filterTo4 = false;
                                void $i$f$flatMapTo2 = $this$filterTo$iv$iv4;
                                boolean bl15 = false;
                                element$iv$iv22 = $i$f$flatMapTo2.entrySet().iterator();
                                while (element$iv$iv22.hasNext()) {
                                    Map.Entry element$iv$iv4;
                                    Map.Entry it = element$iv$iv4 = element$iv$iv22.next();
                                    boolean bl16 = false;
                                    if (!(Intrinsics.areEqual((Object)((String)it.getKey()), (Object)"interactionId") ^ true)) continue;
                                    destination$iv$iv3.put(element$iv$iv4.getKey(), element$iv$iv4.getValue());
                                }
                                Map $this$flatMap$iv3 = destination$iv$iv3;
                                boolean $i$f$flatMap3 = false;
                                $this$filterTo$iv$iv4 = $this$flatMap$iv3;
                                destination$iv$iv3 = new ArrayList();
                                boolean $i$f$flatMapTo3 = false;
                                $i$f$flatMapTo2 = $this$flatMapTo$iv$iv3;
                                bl15 = false;
                                element$iv$iv22 = $i$f$flatMapTo2.entrySet().iterator();
                                while (element$iv$iv22.hasNext()) {
                                    List list2;
                                    Map.Entry element$iv$iv5;
                                    Map.Entry it = element$iv$iv5 = element$iv$iv22.next();
                                    boolean bl17 = false;
                                    object2 = (String)it.getKey();
                                    switch (((String)object2).hashCode()) {
                                        case 3575610: {
                                            if (((String)object2).equals("type")) {
                                                list2 = CollectionsKt.listOf((Object)TuplesKt.to((Object)"attribute", it.getValue()));
                                                break;
                                            }
                                        }
                                        default: {
                                            list2 = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"identifier", it.getKey()), TuplesKt.to((Object)"description", it.getValue())});
                                        }
                                    }
                                    Iterable list$iv$iv = list2;
                                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                                }
                                list = CollectionsKt.listOf((Object)BuilderKt.jsonObject((Iterable)((List)destination$iv$iv3)));
                            } else {
                                void $this$mapTo$iv$iv4;
                                Object $this$filterNotTo$iv$iv;
                                Map $this$filterNot$iv = mismatch;
                                boolean $i$f$filterNot = false;
                                Map $this$flatMapTo$iv$iv3 = $this$filterNot$iv;
                                destination$iv$iv3 = new LinkedHashMap();
                                boolean $i$f$filterNotTo = false;
                                Iterator iterator2 = $this$filterNotTo$iv$iv;
                                boolean bl18 = false;
                                element$iv$iv22 = iterator2.entrySet().iterator();
                                while (element$iv$iv22.hasNext()) {
                                    Map.Entry element$iv$iv6;
                                    Map.Entry it = element$iv$iv6 = element$iv$iv22.next();
                                    boolean bl19 = false;
                                    if (Intrinsics.areEqual((Object)((String)it.getKey()), (Object)"interactionId") || Intrinsics.areEqual((Object)((String)it.getKey()), (Object)"type")) continue;
                                    destination$iv$iv3.put(element$iv$iv6.getKey(), element$iv$iv6.getValue());
                                }
                                $this$map$iv2 = destination$iv$iv3.entrySet();
                                boolean $i$f$map4 = false;
                                $this$filterNotTo$iv$iv = $this$map$iv2;
                                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                boolean $i$f$mapTo4 = false;
                                for (Object item$iv$iv4 : $this$mapTo$iv$iv4) {
                                    void it;
                                    element$iv$iv22 = (Map.Entry)item$iv$iv4;
                                    object3 = destination$iv$iv3;
                                    boolean bl20 = false;
                                    void var36_76 = it;
                                    boolean bl21 = false;
                                    pair = new Pair(var36_76.getKey(), var36_76.getValue());
                                    object3.add(pair);
                                }
                                list = CollectionsKt.listOf((Object)BuilderKt.jsonObject((Iterable)((List)destination$iv$iv3)));
                            }
                            Iterable list$iv$iv = list;
                            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                        }
                        List values = (List)destination$iv$iv2;
                        interactionJson = BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"interactionId", mismatches.getKey()), TuplesKt.to((Object)"success", (Object)false), TuplesKt.to((Object)"mismatches", (Object)BuilderKt.jsonArray((Iterable)values))});
                        $this$flatMapTo$iv$iv = (Iterable)mismatches.getValue();
                        boolean bl22 = false;
                        Iterable iterable4 = $this$flatMapTo$iv$iv;
                        boolean bl23 = false;
                        for (Object t : iterable4) {
                            Map it = (Map)t;
                            boolean bl24 = false;
                            if (!it.containsKey("exception")) continue;
                            v5 = t;
                            break block39;
                        }
                        v5 = null;
                    }
                    Map exceptionDetails = v5;
                    if (exceptionDetails != null) {
                        Object exception = exceptionDetails.get("exception");
                        if (exception instanceof Throwable) {
                            MutableKt.set((JsonElement)((JsonElement)interactionJson), (String)"exceptions", (Object)BuilderKt.jsonArray((Object[])new Object[]{BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"message", (Object)((Throwable)exception).getMessage()), TuplesKt.to((Object)"exceptionClass", (Object)((Throwable)exception).getClass().getName())})}));
                        } else {
                            MutableKt.set((JsonElement)((JsonElement)interactionJson), (String)"exceptions", (Object)BuilderKt.jsonArray((Object[])new Object[]{BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"message", (Object)String.valueOf(exception))})}));
                        }
                    }
                    JsonObject jsonObject3 = interactionJson;
                    object.add(jsonObject3);
                }
                List values = (List)destination$iv$iv;
                jsonObject.add("testResults", (JsonElement)BuilderKt.jsonArray((Iterable)values));
            }
        }
        return jsonObject;
    }

    @NotNull
    public List<PactBrokerConsumer> fetchLatestConsumersWithNoTag(@NotNull String provider) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        try {
            IHalClient halClient = this.newHalClient();
            boolean bl = false;
            List consumers = new ArrayList();
            halClient.navigate(MapsKt.mapOf((Pair)TuplesKt.to((Object)"provider", (Object)provider)), LATEST_PROVIDER_PACTS_WITH_NO_TAG).forAll(PACTS, (Consumer<Map<String, Object>>)new Consumer<Map<String, ? extends Object>>(this, consumers){
                final /* synthetic */ PactBrokerClient this$0;
                final /* synthetic */ List $consumers;

                public final void accept(@NotNull Map<String, ? extends Object> pact) {
                    Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
                    String href = URLDecoder.decode(String.valueOf(pact.get("href")), "UTF-8");
                    String name = String.valueOf(pact.get("name"));
                    if (this.this$0.getOptions().containsKey("authentication")) {
                        String string = href;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"href");
                        Object object = this.this$0.getOptions().get("authentication");
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                        }
                        this.$consumers.add(new PactBrokerConsumer(name, string, this.this$0.getPactBrokerUrl(), (List)object, null, 16, null));
                    } else {
                        String string = href;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"href");
                        this.$consumers.add(new PactBrokerConsumer(name, string, this.this$0.getPactBrokerUrl(), CollectionsKt.emptyList(), null, 16, null));
                    }
                }
                {
                    this.this$0 = pactBrokerClient;
                    this.$consumers = list;
                }
            });
            list = consumers;
        }
        catch (NotFoundHalResponse _) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void publishProviderTag(@NotNull Map<String, ? extends Object> docAttributes, @NotNull String name, @NotNull String tag, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull(docAttributes, (String)"docAttributes");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        try {
            Unit unit;
            IHalClient halClient = this.newHalClient().withDocContext(docAttributes).navigate(PROVIDER);
            Result<Boolean, Exception> result = halClient.putJson(PROVIDER_TAG_VERSION, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"version", (Object)version), TuplesKt.to((Object)"tag", (Object)tag)}), "{}");
            if (result instanceof Ok) {
                Companion.getLogger().debug((Function0)new Function0<String>(tag, name, version){
                    final /* synthetic */ String $tag;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $version;

                    @NotNull
                    public final String invoke() {
                        return "Pushed tag " + this.$tag + " for provider " + this.$name + " and version " + this.$version;
                    }
                    {
                        this.$tag = string;
                        this.$name = string2;
                        this.$version = string3;
                        super(0);
                    }
                });
                unit = Unit.INSTANCE;
            } else if (result instanceof Err) {
                Companion.getLogger().error((Throwable)((Err)result).getError(), (Function0)new Function0<String>(tag, name, version){
                    final /* synthetic */ String $tag;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $version;

                    @NotNull
                    public final String invoke() {
                        return "Failed to push tag " + this.$tag + " for provider " + this.$name + " and version " + this.$version;
                    }
                    {
                        this.$tag = string;
                        this.$name = string2;
                        this.$version = string3;
                        super(0);
                    }
                });
                unit = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Unit unit2 = unit;
        }
        catch (NotFoundHalResponse e) {
            Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(name){
                final /* synthetic */ String $name;

                @NotNull
                public final String invoke() {
                    return "Could not tag provider " + this.$name + ", link was missing";
                }
                {
                    this.$name = string;
                    super(0);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public CanIDeployResult canIDeploy(@NotNull String pacticipant, @NotNull String pacticipantVersion, @NotNull Latest latest, @Nullable String to) {
        CanIDeployResult canIDeployResult;
        Result<JsonElement, Exception> result;
        Intrinsics.checkParameterIsNotNull((Object)pacticipant, (String)"pacticipant");
        Intrinsics.checkParameterIsNotNull((Object)pacticipantVersion, (String)"pacticipantVersion");
        Intrinsics.checkParameterIsNotNull((Object)latest, (String)"latest");
        IHalClient halClient = this.newHalClient();
        Result<JsonElement, Exception> result2 = result = halClient.getJson("/matrix" + this.buildMatrixQuery(pacticipant, pacticipantVersion, latest, to), false);
        if (result2 instanceof Ok) {
            JsonElement jsonElement = ((JsonElement)((Ok)result).getValue()).getAsJsonObject().get("summary");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"result.value.asJsonObject[\"summary\"]");
            JsonObject summary = jsonElement.getAsJsonObject();
            boolean bl = Json.INSTANCE.toBoolean(summary.get("deployable"));
            String string = Json.INSTANCE.toString(summary.get("reason"));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Json.toString(summary[\"reason\"])");
            canIDeployResult = new CanIDeployResult(bl, "", string);
        } else if (result2 instanceof Err) {
            Companion.getLogger().error((Throwable)((Err)result).getError(), (Function0)new Function0<String>(result){
                final /* synthetic */ Result $result;

                @NotNull
                public final String invoke() {
                    return "Pact broker matrix query failed: " + ((Exception)((Err)this.$result).getError()).getMessage();
                }
                {
                    this.$result = result;
                    super(0);
                }
            });
            canIDeployResult = new CanIDeployResult(false, String.valueOf(((Exception)((Err)result).getError()).getMessage()), "");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return canIDeployResult;
    }

    private final String buildMatrixQuery(String pacticipant, String pacticipantVersion, Latest latest, String to) {
        String string;
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        String base = "?q[][pacticipant]=" + escaper.escape(pacticipant) + "&latestby=cvp";
        StringBuilder stringBuilder = new StringBuilder().append(base);
        Latest latest2 = latest;
        if (latest2 instanceof Latest.UseLatest) {
            string = ((Latest.UseLatest)latest).getLatest() ? "&q[][latest]=true" : "&q[][version]=" + escaper.escape(pacticipantVersion);
        } else if (latest2 instanceof Latest.UseLatestTag) {
            string = "q[][tag]=" + escaper.escape(((Latest.UseLatestTag)latest).getLatestTag());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        base = stringBuilder.append(string).toString();
        base = base + (KotlinLanguageSupportKt.isNotEmpty((String)to) ? "&latest=true&tag=" + escaper.escape(to) : "&latest=true");
        return base;
    }

    @NotNull
    public final String getPactBrokerUrl() {
        return this.pactBrokerUrl;
    }

    @NotNull
    public final Map<String, Object> getOptions() {
        return this.options;
    }

    public PactBrokerClient(@NotNull String pactBrokerUrl, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerUrl, (String)"pactBrokerUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.pactBrokerUrl = pactBrokerUrl;
        this.options = options;
    }

    public PactBrokerClient(@NotNull String pactBrokerUrl) {
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerUrl, (String)"pactBrokerUrl");
        String string = pactBrokerUrl;
        PactBrokerClient pactBrokerClient = this;
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        pactBrokerClient(string, map);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lau/com/dius/pact/core/pactbroker/PactBrokerClient$Companion;", "Lmu/KLogging;", "()V", "LATEST_PROVIDER_PACTS", "", "LATEST_PROVIDER_PACTS_WITH_NO_TAG", "LATEST_PROVIDER_PACTS_WITH_TAG", "PACTS", "PROVIDER", "PROVIDER_TAG_VERSION", "UTF8", "uploadTags", "", "halClient", "Lau/com/dius/pact/core/pactbroker/IHalClient;", "consumerName", "version", "tags", "", "pact-jvm-core-pact-broker"})
    public static final class Companion
    extends KLogging {
        public final void uploadTags(@NotNull IHalClient halClient, @NotNull String consumerName, @NotNull String version, @NotNull List<String> tags) {
            Intrinsics.checkParameterIsNotNull((Object)halClient, (String)"halClient");
            Intrinsics.checkParameterIsNotNull((Object)consumerName, (String)"consumerName");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
            Iterable $this$forEach$iv = tags;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String tag = UrlEscapers.urlPathSegmentEscaper().escape(it);
                halClient.uploadJson("/pacticipants/" + consumerName + "/versions/" + version + "/tags/" + tag, "", uploadTags.1.1.INSTANCE, false);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

