/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.pactbroker;

import au.com.dius.pact.com.github.michaelbull.result.Err;
import au.com.dius.pact.com.github.michaelbull.result.Result;
import au.com.dius.pact.core.pactbroker.HalClient;
import au.com.dius.pact.core.pactbroker.IHalClient;
import au.com.dius.pact.core.pactbroker.NotFoundHalResponse;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerConsumer;
import au.com.dius.pact.core.pactbroker.PactResponse;
import au.com.dius.pact.core.pactbroker.TestResult;
import com.github.salomonbrys.kotson.BuilderKt;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import groovy.json.JsonSlurper;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dmfs.rfc3986.encoding.Precoded;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016JT\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u001b2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00060\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0003H\u0017JT\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u001b2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00060\u00062\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u00032\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0003H\u0017J*\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0017R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "", "pactBrokerUrl", "", "(Ljava/lang/String;)V", "options", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getOptions", "()Ljava/util/Map;", "getPactBrokerUrl", "()Ljava/lang/String;", "fetchConsumers", "", "Lau/com/dius/pact/core/pactbroker/PactBrokerConsumer;", "provider", "fetchConsumersWithTag", "tag", "fetchLatestConsumersWithNoTag", "fetchPact", "Lau/com/dius/pact/core/pactbroker/PactResponse;", "url", "getUrlForProvider", "providerName", "newHalClient", "Lau/com/dius/pact/core/pactbroker/IHalClient;", "publishVerificationResults", "Lau/com/dius/pact/com/github/michaelbull/result/Result;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "docAttributes", "result", "Lau/com/dius/pact/core/pactbroker/TestResult;", "version", "buildUrl", "uploadPactFile", "pactFile", "Ljava/io/File;", "unescapedVersion", "tags", "Companion", "pact-jvm-core-pact-broker"})
public class PactBrokerClient {
    @NotNull
    private final String pactBrokerUrl;
    @NotNull
    private final Map<String, Object> options;
    @NotNull
    public static final String LATEST_PROVIDER_PACTS_WITH_NO_TAG = "pb:latest-untagged-pact-version";
    @NotNull
    public static final String LATEST_PROVIDER_PACTS = "pb:latest-provider-pacts";
    @NotNull
    public static final String LATEST_PROVIDER_PACTS_WITH_TAG = "pb:latest-provider-pacts-with-tag";
    @NotNull
    public static final String PACTS = "pacts";
    @NotNull
    public static final String UTF8 = "UTF-8";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public List<PactBrokerConsumer> fetchConsumers(@NotNull String provider) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        try {
            IHalClient halClient = this.newHalClient();
            boolean bl = false;
            List consumers = new ArrayList();
            halClient.navigate(MapsKt.mapOf((Pair)TuplesKt.to((Object)"provider", (Object)provider)), LATEST_PROVIDER_PACTS).forAll(PACTS, (Consumer<Map<String, Object>>)new Consumer<Map<String, ? extends Object>>(this, consumers){
                final /* synthetic */ PactBrokerClient this$0;
                final /* synthetic */ List $consumers;

                public final void accept(@NotNull Map<String, ? extends Object> pact) {
                    Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
                    String href = ((Object)new Precoded((CharSequence)String.valueOf(pact.get("href"))).decoded()).toString();
                    String name = String.valueOf(pact.get("name"));
                    if (this.this$0.getOptions().containsKey("authentication")) {
                        Object object = this.this$0.getOptions().get("authentication");
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                        }
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), (List)object, null, 16, null));
                    } else {
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), null, null, 24, null));
                    }
                }
                {
                    this.this$0 = pactBrokerClient;
                    this.$consumers = list;
                }
            });
            list = consumers;
        }
        catch (NotFoundHalResponse e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public List<PactBrokerConsumer> fetchConsumersWithTag(@NotNull String provider, @NotNull String tag) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        try {
            IHalClient halClient = this.newHalClient();
            boolean bl = false;
            List consumers = new ArrayList();
            halClient.navigate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"provider", (Object)provider), TuplesKt.to((Object)"tag", (Object)tag)}), LATEST_PROVIDER_PACTS_WITH_TAG).forAll(PACTS, (Consumer<Map<String, Object>>)new Consumer<Map<String, ? extends Object>>(this, consumers, tag){
                final /* synthetic */ PactBrokerClient this$0;
                final /* synthetic */ List $consumers;
                final /* synthetic */ String $tag;

                public final void accept(@NotNull Map<String, ? extends Object> pact) {
                    Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
                    String href = ((Object)new Precoded((CharSequence)String.valueOf(pact.get("href"))).decoded()).toString();
                    String name = String.valueOf(pact.get("name"));
                    if (this.this$0.getOptions().containsKey("authentication")) {
                        Object object = this.this$0.getOptions().get("authentication");
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                        }
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), (List)object, this.$tag));
                    } else {
                        this.$consumers.add(new PactBrokerConsumer(name, href, this.this$0.getPactBrokerUrl(), CollectionsKt.emptyList(), this.$tag));
                    }
                }
                {
                    this.this$0 = pactBrokerClient;
                    this.$consumers = list;
                    this.$tag = string;
                }
            });
            list = consumers;
        }
        catch (NotFoundHalResponse e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmOverloads
    @Nullable
    public Object uploadPactFile(@NotNull File pactFile, @NotNull String unescapedVersion, @NotNull List<String> tags) {
        Intrinsics.checkParameterIsNotNull((Object)pactFile, (String)"pactFile");
        Intrinsics.checkParameterIsNotNull((Object)unescapedVersion, (String)"unescapedVersion");
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        String pactText = FilesKt.readText$default((File)pactFile, null, (int)1, null);
        Object object = new JsonSlurper().parseText(pactText);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, kotlin.Any>>");
        }
        Map pact = (Map)object;
        IHalClient halClient = this.newHalClient();
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        Object v = pact.get("provider");
        if (v == null) {
            Intrinsics.throwNpe();
        }
        String providerName = escaper.escape(String.valueOf(((Map)v).get("name")));
        Escaper escaper2 = UrlEscapers.urlPathSegmentEscaper();
        Object v2 = pact.get("consumer");
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        String consumerName = escaper2.escape(String.valueOf(((Map)v2).get("name")));
        String version = UrlEscapers.urlPathSegmentEscaper().escape(unescapedVersion);
        String uploadPath = "/pacts/provider/" + providerName + "/consumer/" + consumerName + "/version/" + version;
        return halClient.uploadJson(uploadPath, pactText, new BiFunction<String, String, Object>(tags, halClient, consumerName, version){
            final /* synthetic */ List $tags;
            final /* synthetic */ IHalClient $halClient;
            final /* synthetic */ String $consumerName;
            final /* synthetic */ String $version;

            @NotNull
            public final String apply(@NotNull String result, @NotNull String status) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                if (Intrinsics.areEqual((Object)result, (Object)"OK")) {
                    Collection collection = this.$tags;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        String string2 = this.$consumerName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"consumerName");
                        String string3 = this.$version;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"version");
                        PactBrokerClient.Companion.uploadTags(this.$halClient, string2, string3, this.$tags);
                    }
                    string = status;
                } else {
                    string = "FAILED! " + status;
                }
                return string;
            }
            {
                this.$tags = list;
                this.$halClient = iHalClient;
                this.$consumerName = string;
                this.$version = string2;
            }
        }, false);
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ Object uploadPactFile$default(PactBrokerClient pactBrokerClient, File file, String string, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: uploadPactFile");
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return pactBrokerClient.uploadPactFile(file, string, list);
    }

    @JvmOverloads
    @Nullable
    public Object uploadPactFile(@NotNull File pactFile, @NotNull String unescapedVersion) {
        return PactBrokerClient.uploadPactFile$default(this, pactFile, unescapedVersion, null, 4, null);
    }

    @Nullable
    public String getUrlForProvider(@NotNull String providerName, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        IHalClient halClient = this.newHalClient();
        CharSequence charSequence = tag;
        boolean bl = false;
        if (charSequence.length() == 0 || Intrinsics.areEqual((Object)tag, (Object)"latest")) {
            halClient.navigate(MapsKt.mapOf((Pair)TuplesKt.to((Object)"provider", (Object)providerName)), LATEST_PROVIDER_PACTS);
        } else {
            halClient.navigate(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"provider", (Object)providerName), TuplesKt.to((Object)"tag", (Object)tag)}), LATEST_PROVIDER_PACTS_WITH_TAG);
        }
        return halClient.linkUrl(PACTS);
    }

    @NotNull
    public PactResponse fetchPact(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        JsonElement jsonElement = this.newHalClient().fetch(url);
        if (jsonElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.JsonObject");
        }
        JsonObject halDoc = (JsonObject)jsonElement;
        JsonElement jsonElement2 = halDoc.get("_links");
        if (jsonElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.gson.JsonObject");
        }
        Map<String, Object> map = HalClient.Companion.asMap((JsonObject)jsonElement2);
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, kotlin.Any>>");
        }
        return new PactResponse(HalClient.Companion.asMap(halDoc), map);
    }

    @NotNull
    public IHalClient newHalClient() {
        return new HalClient(this.pactBrokerUrl, this.options);
    }

    @Deprecated(message="Use the version that takes a test result", replaceWith=@ReplaceWith(imports={}, expression="publishVerificationResults"))
    @NotNull
    public Result<Boolean, Exception> publishVerificationResults(@NotNull Map<String, ? extends Map<String, ? extends Object>> docAttributes, boolean result, @NotNull String version, @Nullable String buildUrl) {
        Intrinsics.checkParameterIsNotNull(docAttributes, (String)"docAttributes");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return this.publishVerificationResults(docAttributes, TestResult.Companion.fromBoolean(result), version, buildUrl);
    }

    @Deprecated(message="Use the version that takes a test result", replaceWith=@ReplaceWith(imports={}, expression="publishVerificationResults"))
    @NotNull
    public static /* synthetic */ Result publishVerificationResults$default(PactBrokerClient pactBrokerClient, Map map, boolean bl, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishVerificationResults");
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return pactBrokerClient.publishVerificationResults((Map<String, ? extends Map<String, ? extends Object>>)map, bl, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public Result<Boolean, Exception> publishVerificationResults(@NotNull Map<String, ? extends Map<String, ? extends Object>> docAttributes, @NotNull TestResult result, @NotNull String version, @Nullable String buildUrl) {
        Result<Boolean, Exception> result2;
        Object object;
        String string;
        Object object2;
        Object object3;
        Map map;
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(docAttributes, (String)"docAttributes");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        IHalClient halClient = this.newHalClient();
        Map<String, ? extends Map<String, ? extends Object>> $this$mapKeys$iv = docAttributes;
        boolean $i$f$mapKeys = false;
        Map<String, ? extends Map<String, ? extends Object>> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Object object4 = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            object3 = (String)it.getKey();
            boolean bl2 = false;
            String string2 = object3;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            object2 = (Map.Entry)element$iv$iv$iv;
            String string3 = string;
            object = map;
            boolean bl3 = false;
            object4 = it$iv$iv.getValue();
            object.put(string3, object4);
        }
        Map publishLink = (Map)destination$iv$iv.get("pb:publish-verification-results");
        if (publishLink != null) {
            void $this$mapKeysTo$iv$iv2;
            JsonObject jsonObject = BuilderKt.jsonObject((Pair[])new Pair[]{TuplesKt.to((Object)"success", (Object)result.toBoolean()), TuplesKt.to((Object)"providerApplicationVersion", (Object)version)});
            if (buildUrl != null) {
                jsonObject.add("buildUrl", (JsonElement)BuilderKt.toJson((String)buildUrl));
            }
            Map $this$mapKeys$iv2 = publishLink;
            boolean $i$f$mapKeys2 = false;
            Map $i$f$mapKeysTo2 = $this$mapKeys$iv2;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv2.size()));
            boolean $i$f$mapKeysTo3 = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapKeysTo$iv$iv2.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it$iv$iv;
                void it;
                object3 = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv2;
                boolean bl = false;
                object2 = (String)it.getKey();
                boolean bl4 = false;
                Object object5 = object2;
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((String)object5).toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                object = (Map.Entry)element$iv$iv$iv;
                String string4 = string;
                Map map3 = map;
                boolean bl5 = false;
                object3 = it$iv$iv.getValue();
                map3.put(string4, object3);
            }
            Map lowercaseMap = destination$iv$iv2;
            if (lowercaseMap.containsKey("href")) {
                String string5 = String.valueOf(lowercaseMap.get("href"));
                String string6 = jsonObject.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"jsonObject.toString()");
                result2 = halClient.postJson(string5, string6);
            } else {
                result2 = (Result)new Err((Object)new RuntimeException("Unable to publish verification results as there is no pb:publish-verification-results link"));
            }
        } else {
            result2 = (Result<Boolean, Exception>)new Err((Object)new RuntimeException("Unable to publish verification results as there is no pb:publish-verification-results link"));
        }
        return result2;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ Result publishVerificationResults$default(PactBrokerClient pactBrokerClient, Map map, TestResult testResult, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishVerificationResults");
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return pactBrokerClient.publishVerificationResults((Map<String, ? extends Map<String, ? extends Object>>)map, testResult, string, string2);
    }

    @JvmOverloads
    @NotNull
    public Result<Boolean, Exception> publishVerificationResults(@NotNull Map<String, ? extends Map<String, ? extends Object>> docAttributes, @NotNull TestResult result, @NotNull String version) {
        return PactBrokerClient.publishVerificationResults$default(this, docAttributes, result, version, null, 8, null);
    }

    @NotNull
    public List<PactBrokerConsumer> fetchLatestConsumersWithNoTag(@NotNull String provider) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        try {
            IHalClient halClient = this.newHalClient();
            boolean bl = false;
            List consumers = new ArrayList();
            halClient.navigate(MapsKt.mapOf((Pair)TuplesKt.to((Object)"provider", (Object)provider)), LATEST_PROVIDER_PACTS_WITH_NO_TAG).forAll(PACTS, (Consumer<Map<String, Object>>)new Consumer<Map<String, ? extends Object>>(this, consumers){
                final /* synthetic */ PactBrokerClient this$0;
                final /* synthetic */ List $consumers;

                public final void accept(@NotNull Map<String, ? extends Object> pact) {
                    Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
                    String href = URLDecoder.decode(String.valueOf(pact.get("href")), "UTF-8");
                    String name = String.valueOf(pact.get("name"));
                    if (this.this$0.getOptions().containsKey("authentication")) {
                        String string = href;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"href");
                        Object object = this.this$0.getOptions().get("authentication");
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                        }
                        this.$consumers.add(new PactBrokerConsumer(name, string, this.this$0.getPactBrokerUrl(), (List)object, null, 16, null));
                    } else {
                        String string = href;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"href");
                        this.$consumers.add(new PactBrokerConsumer(name, string, this.this$0.getPactBrokerUrl(), CollectionsKt.emptyList(), null, 16, null));
                    }
                }
                {
                    this.this$0 = pactBrokerClient;
                    this.$consumers = list;
                }
            });
            list = consumers;
        }
        catch (NotFoundHalResponse _) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final String getPactBrokerUrl() {
        return this.pactBrokerUrl;
    }

    @NotNull
    public final Map<String, Object> getOptions() {
        return this.options;
    }

    public PactBrokerClient(@NotNull String pactBrokerUrl, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerUrl, (String)"pactBrokerUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.pactBrokerUrl = pactBrokerUrl;
        this.options = options;
    }

    public PactBrokerClient(@NotNull String pactBrokerUrl) {
        Intrinsics.checkParameterIsNotNull((Object)pactBrokerUrl, (String)"pactBrokerUrl");
        String string = pactBrokerUrl;
        PactBrokerClient pactBrokerClient = this;
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        pactBrokerClient(string, map);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lau/com/dius/pact/core/pactbroker/PactBrokerClient$Companion;", "", "()V", "LATEST_PROVIDER_PACTS", "", "LATEST_PROVIDER_PACTS_WITH_NO_TAG", "LATEST_PROVIDER_PACTS_WITH_TAG", "PACTS", "UTF8", "uploadTags", "", "halClient", "Lau/com/dius/pact/core/pactbroker/IHalClient;", "consumerName", "version", "tags", "", "pact-jvm-core-pact-broker"})
    public static final class Companion {
        public final void uploadTags(@NotNull IHalClient halClient, @NotNull String consumerName, @NotNull String version, @NotNull List<String> tags) {
            Intrinsics.checkParameterIsNotNull((Object)halClient, (String)"halClient");
            Intrinsics.checkParameterIsNotNull((Object)consumerName, (String)"consumerName");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
            Iterable $this$forEach$iv = tags;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String tag = UrlEscapers.urlPathSegmentEscaper().escape(it);
                halClient.uploadJson("/pacticipants/" + consumerName + "/versions/" + version + "/tags/" + tag, "", uploadTags.1.1.INSTANCE, false);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

