/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.ClosurePactSource;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.InputStreamPactSource;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactReader;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.ReaderPactSource;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.S3PactSource;
import au.com.dius.pact.core.model.UnknownPactSource;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.model.UrlSource;
import au.com.dius.pact.core.model.messaging.MessagePact;
import au.com.dius.pact.core.support.HttpClient;
import au.com.dius.pact.core.support.Json;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.S3Object;
import com.github.salomonbrys.kotson.BuilderKt;
import com.github.salomonbrys.kotson.ElementKt;
import com.github.salomonbrys.kotson.MutableKt;
import com.github.zafarkhaja.semver.Version;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J2\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0#H\u0002J\u0014\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010 \u001a\u00020!H\u0016J(\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0#H\u0016J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001c\u0010)\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0013H\u0007J\u001c\u0010+\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0013H\u0007J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0013H\u0007J\u0010\u00100\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lau/com/dius/pact/core/model/DefaultPactReader;", "Lau/com/dius/pact/core/model/PactReader;", "Lmu/KLogging;", "()V", "CLASSPATH_URI_START", "", "s3Client", "Lcom/amazonaws/services/s3/AmazonS3;", "s3Client$annotations", "getS3Client", "()Lcom/amazonaws/services/s3/AmazonS3;", "setS3Client", "(Lcom/amazonaws/services/s3/AmazonS3;)V", "determineSpecVersion", "pactInfo", "Lcom/google/gson/JsonElement;", "extractRequest", "Lau/com/dius/pact/core/model/Request;", "requestJson", "Lcom/google/gson/JsonObject;", "extractResponse", "Lau/com/dius/pact/core/model/Response;", "responseJson", "fileExists", "", "path", "formatBody", "", "json", "loadFile", "Lkotlin/Pair;", "Lau/com/dius/pact/core/model/PactSource;", "source", "", "options", "", "loadPact", "Lau/com/dius/pact/core/model/Pact;", "loadPactFromClasspath", "loadPactFromFile", "loadPactFromS3Bucket", "loadV2Pact", "pactJson", "loadV3Pact", "specVersion", "specification", "defaultVersion", "transformJson", "transformRequestResponseJson", "pact-jvm-core-model"})
public final class DefaultPactReader
extends KLogging
implements PactReader {
    private static final String CLASSPATH_URI_START = "classpath:";
    @NotNull
    public static AmazonS3 s3Client;
    public static final DefaultPactReader INSTANCE;

    @JvmStatic
    public static /* synthetic */ void s3Client$annotations() {
    }

    @NotNull
    public static final AmazonS3 getS3Client() {
        AmazonS3 amazonS3 = s3Client;
        if (amazonS3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"s3Client");
        }
        return amazonS3;
    }

    public static final void setS3Client(@NotNull AmazonS3 amazonS3) {
        Intrinsics.checkParameterIsNotNull((Object)amazonS3, (String)"<set-?>");
        s3Client = amazonS3;
    }

    @Override
    @NotNull
    public Pact<?> loadPact(@NotNull Object source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return this.loadPact(source, MapsKt.emptyMap());
    }

    @Override
    @NotNull
    public Pact<?> loadPact(@NotNull Object source, @NotNull Map<String, ? extends Object> options) {
        Pact<?> pact;
        Version specVersion;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Pair<JsonElement, PactSource> pactInfo = this.loadFile(source, options);
        String version = DefaultPactReader.determineSpecVersion((JsonElement)pactInfo.getFirst());
        Version version2 = specVersion = Version.valueOf((String)version);
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"specVersion");
        switch (version2.getMajorVersion()) {
            case 3: {
                pact = DefaultPactReader.loadV3Pact((PactSource)pactInfo.getSecond(), ElementKt.getObj((JsonElement)((JsonElement)pactInfo.getFirst())));
                break;
            }
            default: {
                pact = DefaultPactReader.loadV2Pact((PactSource)pactInfo.getSecond(), ElementKt.getObj((JsonElement)((JsonElement)pactInfo.getFirst())));
            }
        }
        return pact;
    }

    @JvmStatic
    @NotNull
    public static final String determineSpecVersion(@NotNull JsonElement pactInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pactInfo, (String)"pactInfo");
        String version = "2.0.0";
        if (ElementKt.getObj((JsonElement)pactInfo).has("metadata")) {
            String string;
            JsonElement jsonElement = ElementKt.getObj((JsonElement)pactInfo).get("metadata");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"pactInfo.obj[\"metadata\"]");
            JsonObject metadata = ElementKt.getObj((JsonElement)jsonElement);
            if (metadata.has("pactSpecificationVersion")) {
                JsonElement jsonElement2 = metadata.get("pactSpecificationVersion");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"metadata[\"pactSpecificationVersion\"]");
                string = ElementKt.getString((JsonElement)jsonElement2);
            } else if (metadata.has("pactSpecification")) {
                JsonElement jsonElement3 = metadata.get("pactSpecification");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"metadata[\"pactSpecification\"]");
                string = INSTANCE.specVersion(jsonElement3, version);
            } else if (metadata.has("pact-specification")) {
                JsonElement jsonElement4 = metadata.get("pact-specification");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"metadata[\"pact-specification\"]");
                string = INSTANCE.specVersion(jsonElement4, version);
            } else {
                string = version = version;
            }
        }
        if (Intrinsics.areEqual((Object)version, (Object)"3.0")) {
            version = "3.0.0";
        }
        return version;
    }

    private final String specVersion(JsonElement specification, String defaultVersion) {
        block3: {
            block2: {
                if (!specification.isJsonObject() || !ElementKt.getObj((JsonElement)specification).has("version")) break block2;
                JsonElement jsonElement = ElementKt.getObj((JsonElement)specification).get("version");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"specification.obj[\"version\"]");
                if (jsonElement.isJsonPrimitive()) break block3;
            }
            return defaultVersion;
        }
        JsonElement jsonElement = ElementKt.getObj((JsonElement)specification).get("version");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"specification.obj[\"version\"]");
        return ElementKt.getString((JsonElement)jsonElement);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pact<?> loadV3Pact(@NotNull PactSource source, @NotNull JsonObject pactJson) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pactJson, (String)"pactJson");
        if (pactJson.has("messages")) {
            return MessagePact.Companion.fromJson(pactJson, source);
        }
        JsonObject transformedJson = DefaultPactReader.transformJson(pactJson);
        JsonElement jsonElement = transformedJson.get("provider");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"transformedJson[\"provider\"]");
        Provider provider = Provider.Companion.fromJson(jsonElement);
        JsonElement jsonElement2 = transformedJson.get("consumer");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"transformedJson[\"consumer\"]");
        Consumer consumer = Consumer.Companion.fromJson(jsonElement2);
        JsonElement jsonElement3 = transformedJson.get("interactions");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"transformedJson[\"interactions\"]");
        Iterable $this$map$iv = (Iterable)ElementKt.getArray((JsonElement)jsonElement3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void i;
            JsonElement jsonElement4 = (JsonElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v3 = i;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"i");
            JsonElement jsonElement5 = ElementKt.getObj((JsonElement)v3).get("request");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"i.obj[\"request\"]");
            Request request = DefaultPactReader.extractRequest(ElementKt.getObj((JsonElement)jsonElement5));
            JsonElement jsonElement6 = ElementKt.getObj((JsonElement)i).get("response");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"i.obj[\"response\"]");
            Response response = DefaultPactReader.extractResponse(ElementKt.getObj((JsonElement)jsonElement6));
            boolean bl2 = false;
            List providerStates = new ArrayList();
            if (ElementKt.getObj((JsonElement)i).has("providerStates")) {
                Collection<ProviderState> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable iterable2 = (Iterable)ElementKt.getArray((JsonElement)ElementKt.get((JsonElement)i, (String)"providerStates"));
                List list = providerStates;
                boolean $i$f$map2 = false;
                void var21_21 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    JsonElement jsonElement7 = (JsonElement)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    void v6 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                    ProviderState providerState = ProviderState.Companion.fromJson((JsonElement)v6);
                    collection2.add(providerState);
                }
                collection2 = (List)destination$iv$iv2;
                list.addAll((Collection)collection2);
            } else if (ElementKt.getObj((JsonElement)i).has("providerState")) {
                providerStates.add(new ProviderState(Json.INSTANCE.toString(ElementKt.get((JsonElement)i, (String)"providerState")), null, 2, null));
            }
            String string = Json.INSTANCE.toString(ElementKt.get((JsonElement)i, (String)"description"));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Json.toString(i[\"description\"])");
            RequestResponseInteraction requestResponseInteraction = new RequestResponseInteraction(string, providerStates, request, response, Json.INSTANCE.toString(ElementKt.getObj((JsonElement)i).get("_id")));
            collection.add(requestResponseInteraction);
        }
        List interactions = (List)destination$iv$iv;
        return new RequestResponsePact(provider, consumer, CollectionsKt.toMutableList((Collection)interactions), BasePact.Companion.metaData(transformedJson.get("metadata"), PactSpecVersion.V3), source);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pact<?> loadV2Pact(@NotNull PactSource source, @NotNull JsonObject pactJson) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pactJson, (String)"pactJson");
        JsonObject transformedJson = DefaultPactReader.transformJson(pactJson);
        JsonElement jsonElement = transformedJson.get("provider");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"transformedJson[\"provider\"]");
        Provider provider = Provider.Companion.fromJson(jsonElement);
        JsonElement jsonElement2 = transformedJson.get("consumer");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"transformedJson[\"consumer\"]");
        Consumer consumer = Consumer.Companion.fromJson(jsonElement2);
        if (transformedJson.has("interactions")) {
            void $this$mapTo$iv$iv;
            JsonElement jsonElement3 = transformedJson.get("interactions");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"transformedJson[\"interactions\"]");
            Iterable $this$map$iv = (Iterable)ElementKt.getArray((JsonElement)jsonElement3);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void i;
                JsonElement jsonElement4 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v3 = i;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"i");
                JsonElement jsonElement5 = ElementKt.getObj((JsonElement)v3).get("request");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement5, (String)"i.obj[\"request\"]");
                Request request = DefaultPactReader.extractRequest(ElementKt.getObj((JsonElement)jsonElement5));
                JsonElement jsonElement6 = ElementKt.getObj((JsonElement)i).get("response");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement6, (String)"i.obj[\"response\"]");
                Response response = DefaultPactReader.extractResponse(ElementKt.getObj((JsonElement)jsonElement6));
                String string = Json.INSTANCE.toString(ElementKt.get((JsonElement)i, (String)"description"));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Json.toString(i[\"description\"])");
                RequestResponseInteraction requestResponseInteraction = new RequestResponseInteraction(string, ElementKt.getObj((JsonElement)i).has("providerState") ? CollectionsKt.listOf((Object)new ProviderState(Json.INSTANCE.toString(ElementKt.getObj((JsonElement)i).get("providerState")), null, 2, null)) : CollectionsKt.emptyList(), request, response, Json.INSTANCE.toString(ElementKt.getObj((JsonElement)i).get("_id")));
                collection.add(requestResponseInteraction);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List interactions = list;
        return new RequestResponsePact(provider, consumer, CollectionsKt.toMutableList((Collection)interactions), BasePact.Companion.metaData(transformedJson.get("metadata"), PactSpecVersion.V2), source);
    }

    @JvmStatic
    @NotNull
    public static final Response extractResponse(@NotNull JsonObject responseJson) {
        Intrinsics.checkParameterIsNotNull((Object)responseJson, (String)"responseJson");
        INSTANCE.formatBody((JsonElement)responseJson);
        return Response.Companion.fromJson(responseJson);
    }

    @JvmStatic
    @NotNull
    public static final Request extractRequest(@NotNull JsonObject requestJson) {
        Intrinsics.checkParameterIsNotNull((Object)requestJson, (String)"requestJson");
        INSTANCE.formatBody((JsonElement)requestJson);
        return Request.Companion.fromJson(requestJson);
    }

    private final void formatBody(JsonElement json) {
        block2: {
            JsonElement body;
            block3: {
                if (!json.isJsonObject() || !ElementKt.getObj((JsonElement)json).has("body")) break block2;
                JsonElement jsonElement = body = ElementKt.getObj((JsonElement)json).get("body");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"body");
                if (!jsonElement.isJsonNull() && !body.isJsonPrimitive()) break block3;
                if (!body.isJsonPrimitive()) break block2;
                JsonPrimitive jsonPrimitive = body.getAsJsonPrimitive();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"body.asJsonPrimitive");
                if (jsonPrimitive.isString()) break block2;
            }
            MutableKt.set((JsonElement)((JsonElement)ElementKt.getObj((JsonElement)json)), (String)"body", (Object)body.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final JsonObject transformJson(@NotNull JsonObject pactJson) {
        block20: {
            block17: {
                Intrinsics.checkParameterIsNotNull((Object)pactJson, (String)"pactJson");
                if (!pactJson.has("interactions")) break block17;
                v0 = pactJson.get("interactions");
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"pactJson[\"interactions\"]");
                if (!v0.isJsonArray()) break block17;
                v1 = (JsonElement)pactJson;
                v2 = pactJson.get("interactions");
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"pactJson[\"interactions\"]");
                var1_1 = (Iterable)ElementKt.getArray((JsonElement)v2);
                var26_2 = "interactions";
                var25_3 = v1;
                $i$f$map = false;
                var3_5 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    block19: {
                        block18: {
                            var8_10 = (JsonElement)item$iv$iv;
                            var27_29 = destination$iv$iv;
                            $i$a$-map-DefaultPactReader$transformJson$1 = false;
                            v3 = i;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"i");
                            if (!v3.isJsonObject()) break block18;
                            v4 = ElementKt.getObj((JsonElement)i).entrySet();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"i.obj.entrySet()");
                            $this$map$iv = v4;
                            $i$f$map = false;
                            var12_15 = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var17_21 = (Map.Entry)item$iv$iv;
                                var18_22 = destination$iv$iv;
                                $i$a$-map-DefaultPactReader$transformJson$1$interaction$1 = false;
                                if ((String)entry.getKey() == null) ** GOTO lbl-1000
                                tmp = -1;
                                switch (var20_24.hashCode()) {
                                    case 1095692943: {
                                        if (!var20_24.equals("request")) break;
                                        tmp = 1;
                                        break;
                                    }
                                    case 1320236227: {
                                        if (!var20_24.equals("provider_state")) break;
                                        tmp = 2;
                                        break;
                                    }
                                    case -340323263: {
                                        if (!var20_24.equals("response")) break;
                                        tmp = 3;
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 2: {
                                        v5 = TuplesKt.to((Object)"providerState", entry.getValue());
                                        break;
                                    }
                                    case 1: {
                                        v6 = entry.getValue();
                                        Intrinsics.checkExpressionValueIsNotNull(v6, (String)"entry.value");
                                        v5 = TuplesKt.to((Object)"request", (Object)DefaultPactReader.INSTANCE.transformRequestResponseJson(ElementKt.getObj((JsonElement)((JsonElement)v6))));
                                        break;
                                    }
                                    case 3: {
                                        v7 = entry.getValue();
                                        Intrinsics.checkExpressionValueIsNotNull(v7, (String)"entry.value");
                                        v5 = TuplesKt.to((Object)"response", (Object)DefaultPactReader.INSTANCE.transformRequestResponseJson(ElementKt.getObj((JsonElement)((JsonElement)v7))));
                                        break;
                                    }
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"entry");
                                        var22_26 = false;
                                        v5 = new Pair(var21_25.getKey(), var21_25.getValue());
                                    }
                                }
                                var23_27 = v5;
                                var18_22.add(var23_27);
                            }
                            interaction = BuilderKt.jsonObject((Iterable)((List)destination$iv$iv));
                            v8 = (JsonElement)interaction;
                            break block19;
                        }
                        v8 = i;
                    }
                    var28_30 = v8;
                    var27_29.add(var28_30);
                }
                var27_29 = (List)destination$iv$iv;
                MutableKt.set((JsonElement)var25_3, (String)var26_2, (Object)BuilderKt.jsonArray((Iterable)var27_29));
            }
            if (!pactJson.has("metadata")) break block20;
            v9 = pactJson.get("metadata");
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"pactJson[\"metadata\"]");
            if (!v9.isJsonObject()) break block20;
            v10 = (JsonElement)pactJson;
            v11 = pactJson.get("metadata");
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"pactJson[\"metadata\"]");
            v12 = ElementKt.getObj((JsonElement)v11).entrySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"pactJson[\"metadata\"].obj.entrySet()");
            $this$map$iv = v12;
            var26_2 = "metadata";
            var25_3 = v10;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                i = (Map.Entry)item$iv$iv;
                var27_29 = destination$iv$iv;
                $i$a$-map-DefaultPactReader$transformJson$2 = false;
                if ((String)entry.getKey() == null) ** GOTO lbl-1000
                switch (var10_12.hashCode()) {
                    case -2064928616: {
                        if (var10_12.equals("pact-specification")) {
                            v13 = TuplesKt.to((Object)"pactSpecification", entry.getValue());
                            break;
                        }
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"entry");
                        var12_16 = false;
                        v13 = new Pair(var11_14.getKey(), var11_14.getValue());
                    }
                }
                var28_30 = v13;
                var27_29.add(var28_30);
            }
            var27_29 = (List)destination$iv$iv;
            MutableKt.set((JsonElement)var25_3, (String)var26_2, (Object)BuilderKt.jsonObject((Iterable)var27_29));
        }
        return pactJson;
    }

    /*
     * Unable to fully structure code
     */
    private final JsonObject transformRequestResponseJson(JsonObject requestJson) {
        v0 = requestJson.entrySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"requestJson.entrySet()");
        $this$map$iv = v0;
        $i$f$map = false;
        var4_4 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var9_9 = (Map.Entry)item$iv$iv;
            var18_19 = destination$iv$iv;
            $i$a$-map-DefaultPactReader$transformRequestResponseJson$1 = false;
            var11_11 = $dstr$k$v;
            var12_12 = false;
            var13_14 = (String)var11_11.getKey();
            var11_11 = $dstr$k$v;
            var12_12 = false;
            v = (JsonElement)var11_11.getValue();
            v1 = k;
            if (v1 == null) ** GOTO lbl-1000
            var11_11 = v1;
            tmp = -1;
            switch (var11_11.hashCode()) {
                case -1592954823: {
                    if (!var11_11.equals("responseMatchingRules")) break;
                    tmp = 1;
                    break;
                }
                case -1077554975: {
                    if (!var11_11.equals("method")) break;
                    tmp = 2;
                    break;
                }
                case 2135015595: {
                    if (!var11_11.equals("requestMatchingRules")) break;
                    tmp = 3;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v2 = TuplesKt.to((Object)"matchingRules", (Object)v);
                    break;
                }
                case 3: {
                    v2 = TuplesKt.to((Object)"matchingRules", (Object)v);
                    break;
                }
                case 2: {
                    Intrinsics.checkExpressionValueIsNotNull((Object)Json.INSTANCE.toString(v), (String)"Json.toString(v)");
                    var15_16 = "method";
                    var16_17 = false;
                    v3 = var12_13;
                    if (v3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                    v2 = TuplesKt.to((Object)var15_16, (Object)var17_18);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v2 = TuplesKt.to((Object)k, (Object)v);
                }
            }
            var19_20 = v2;
            var18_19.add(var19_20);
        }
        return BuilderKt.jsonObject((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonElement, PactSource> loadFile(Object source, Map<String, ? extends Object> options) {
        boolean bl;
        Object object;
        Object urlSource2;
        if (source instanceof ClosurePactSource) {
            Object object2 = ((ClosurePactSource)source).getClosure().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"source.closure.get()");
            return this.loadFile(object2, options);
        }
        if (source instanceof FileSource) {
            Object object3 = ((FileSource)source).getFile();
            Charset charset2 = Charsets.UTF_8;
            int n = 8192;
            boolean bl2 = false;
            Object object4 = object3;
            boolean bl3 = false;
            Object object5 = object4;
            boolean bl4 = false;
            object5 = new FileInputStream((File)object5);
            bl4 = false;
            object4 = new InputStreamReader((InputStream)object5, charset2);
            bl3 = false;
            object3 = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object3;
                boolean bl6 = false;
                it = TuplesKt.to((Object)new JsonParser().parse((Reader)it), (Object)source);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
            return it;
        }
        if (source instanceof InputStream || source instanceof Reader || source instanceof File) {
            return this.loadPactFromFile(source);
        }
        if (source instanceof BrokerUrlSource) {
            Pair<JsonElement, PactSource> pair;
            URI uRI = new URI(((BrokerUrlSource)source).getPactBrokerUrl());
            Object object6 = options.get("authentication");
            HttpClient httpClient = HttpClient.INSTANCE;
            boolean bl7 = false;
            Map map = new LinkedHashMap();
            Closeable closeable = (Closeable)HttpClient.newHttpClient$default((HttpClient)httpClient, (Object)object6, (URI)uRI, (Map)map, (int)0, (int)0, (int)24, null).getFirst();
            boolean bl8 = false;
            Throwable throwable = null;
            try {
                CloseableHttpClient it = (CloseableHttpClient)closeable;
                boolean bl9 = false;
                pair = PactReaderKt.loadPactFromUrl((UrlPactSource)source, options, it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return pair;
        }
        if (source instanceof URL || source instanceof UrlPactSource) {
            UrlPactSource urlSource2 = source instanceof URL ? (UrlPactSource)new UrlSource(source.toString(), null, 2, null) : (UrlPactSource)source;
            return PactReaderKt.loadPactFromUrl(urlSource2, options, PactReaderKt.newHttpClient(urlSource2.getUrl(), options));
        }
        if (source instanceof String) {
            urlSource2 = (String)source;
            boolean bl10 = false;
            String string = ((String)urlSource2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            urlSource2 = string;
            object = new Regex("(https?|file)://?.*");
            bl = false;
            if (object.matches((CharSequence)urlSource2)) {
                urlSource2 = new UrlSource((String)source, null, 2, null);
                return PactReaderKt.loadPactFromUrl((UrlPactSource)urlSource2, options, PactReaderKt.newHttpClient(((UrlSource)urlSource2).getUrl(), options));
            }
        }
        if (source instanceof String) {
            urlSource2 = (String)source;
            boolean bl11 = false;
            String string = ((String)urlSource2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            urlSource2 = string;
            object = new Regex("s3://.*");
            bl = false;
            if (object.matches((CharSequence)urlSource2)) {
                return this.loadPactFromS3Bucket((String)source);
            }
        }
        if (source instanceof String && StringsKt.startsWith$default((String)((String)source), (String)CLASSPATH_URI_START, (boolean)false, (int)2, null)) {
            urlSource2 = (String)source;
            int n = CLASSPATH_URI_START.length();
            DefaultPactReader defaultPactReader = this;
            bl = false;
            String string = ((String)urlSource2).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String string2 = string;
            return defaultPactReader.loadPactFromClasspath(string2);
        }
        if (source instanceof String && this.fileExists((String)source)) {
            Pair pair;
            File file = new File((String)source);
            object = file;
            Charset charset3 = Charsets.UTF_8;
            int n = 8192;
            boolean bl9 = false;
            Object object7 = object;
            boolean bl12 = false;
            Object object8 = object7;
            boolean bl13 = false;
            object8 = new FileInputStream((File)object8);
            bl13 = false;
            object7 = new InputStreamReader((InputStream)object8, charset3);
            bl12 = false;
            object = object7 instanceof BufferedReader ? (BufferedReader)object7 : new BufferedReader((Reader)object7, n);
            boolean bl14 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl15 = false;
                pair = TuplesKt.to((Object)new JsonParser().parse((Reader)it), new FileSource(file, null, 2, null));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return pair;
        }
        try {
            return TuplesKt.to((Object)new JsonParser().parse(source.toString()), (Object)UnknownPactSource.INSTANCE);
        }
        catch (JsonSyntaxException e) {
            throw (Throwable)new UnsupportedOperationException("Unable to load pact file from '" + source + "' as it is neither a json document, file, input stream, " + "reader or an URL", e);
        }
    }

    static /* synthetic */ Pair loadFile$default(DefaultPactReader defaultPactReader, Object object, Map map, int n, Object object2) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return defaultPactReader.loadFile(object, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonElement, PactSource> loadPactFromFile(Object source) {
        Pair pair;
        Object object = source;
        if (object instanceof InputStream) {
            pair = TuplesKt.to((Object)new JsonParser().parse((Reader)new InputStreamReader((InputStream)source)), (Object)InputStreamPactSource.INSTANCE);
        } else if (object instanceof Reader) {
            pair = TuplesKt.to((Object)new JsonParser().parse((Reader)source), (Object)ReaderPactSource.INSTANCE);
        } else if (object instanceof File) {
            JsonElement jsonElement;
            Object object2 = (File)source;
            Charset charset2 = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object3 = object2;
            boolean bl2 = false;
            Object object4 = object3;
            boolean bl3 = false;
            object4 = new FileInputStream((File)object4);
            bl3 = false;
            object3 = new InputStreamReader((InputStream)object4, charset2);
            bl2 = false;
            object2 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object2;
                boolean bl5 = false;
                jsonElement = new JsonParser().parse((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
            pair = TuplesKt.to((Object)jsonElement, new FileSource((File)source, null, 2, null));
        } else {
            throw (Throwable)new IllegalArgumentException("loadPactFromFile expects either an InputStream, Reader or File. " + "Got a " + source.getClass().getName() + " instead");
        }
        return pair;
    }

    private final Pair<JsonElement, PactSource> loadPactFromS3Bucket(String source) {
        AmazonS3URI s3Uri = new AmazonS3URI(source);
        if (s3Client == null) {
            AmazonS3 amazonS3 = AmazonS3ClientBuilder.defaultClient();
            Intrinsics.checkExpressionValueIsNotNull((Object)amazonS3, (String)"AmazonS3ClientBuilder.defaultClient()");
            s3Client = amazonS3;
        }
        AmazonS3 amazonS3 = s3Client;
        if (amazonS3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"s3Client");
        }
        S3Object s3Pact = amazonS3.getObject(s3Uri.getBucket(), s3Uri.getKey());
        JsonParser jsonParser = new JsonParser();
        S3Object s3Object = s3Pact;
        Intrinsics.checkExpressionValueIsNotNull((Object)s3Object, (String)"s3Pact");
        return TuplesKt.to((Object)jsonParser.parse((Reader)new InputStreamReader((InputStream)s3Object.getObjectContent())), (Object)new S3PactSource(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonElement, PactSource> loadPactFromClasspath(String source) {
        Pair<JsonElement, PactSource> pair;
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        InputStream inputStream = thread.getContextClassLoader().getResourceAsStream(source);
        if (inputStream == null) {
            throw (Throwable)new IllegalStateException("not found on classpath: " + source);
        }
        Closeable closeable = inputStream;
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            pair = INSTANCE.loadPactFromFile(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return pair;
    }

    private final boolean fileExists(String path) {
        return new File(path).exists();
    }

    private DefaultPactReader() {
    }

    static {
        DefaultPactReader defaultPactReader;
        INSTANCE = defaultPactReader = new DefaultPactReader();
    }
}

