/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.com.github.michaelbull.result.Err;
import au.com.dius.pact.com.github.michaelbull.result.Ok;
import au.com.dius.pact.com.github.michaelbull.result.Result;
import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.InvalidHttpResponseException;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactResponse;
import au.com.dius.pact.core.pactbroker.util.HttpClientUtils;
import au.com.dius.pact.core.support.CustomServiceUnavailableRetryStrategy;
import com.github.salomonbrys.kotson.ElementKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a2\u0010\u0002\u001a\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\b\u0012\u00060\u0007j\u0002`\b0\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006\u001a6\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u001a.\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00150\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"logger", "Lmu/KLogger;", "fetchJsonResource", "Lau/com/dius/pact/com/github/michaelbull/result/Result;", "Lkotlin/Pair;", "Lcom/google/gson/JsonElement;", "Lau/com/dius/pact/core/model/UrlPactSource;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "http", "Lorg/apache/http/impl/client/CloseableHttpClient;", "source", "loadPactFromUrl", "Lau/com/dius/pact/core/model/PactSource;", "options", "", "", "", "newHttpClient", "baseUrl", "queryStringToMap", "", "query", "decode", "", "pact-jvm-core-model"})
public final class PactReaderKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    @NotNull
    public static final Pair<JsonElement, PactSource> loadPactFromUrl(@NotNull UrlPactSource source, @NotNull Map<String, ? extends Object> options, @NotNull CloseableHttpClient http) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        UrlPactSource urlPactSource = source;
        if (urlPactSource instanceof BrokerUrlSource) {
            PactBrokerClient brokerClient = new PactBrokerClient(((BrokerUrlSource)source).getPactBrokerUrl(), options);
            PactResponse pactResponse = brokerClient.fetchPact(source.getUrl());
            pair = TuplesKt.to((Object)pactResponse.getPactFile(), (Object)BrokerUrlSource.copy$default((BrokerUrlSource)source, null, null, pactResponse.getLinks(), options, null, 19, null));
        } else {
            Result<Pair<JsonElement, UrlPactSource>, Exception> jsonResource = PactReaderKt.fetchJsonResource(http, source);
            if (jsonResource instanceof Ok) {
                pair = TuplesKt.to((Object)ElementKt.getObj((JsonElement)((JsonElement)((Pair)((Ok)jsonResource).getValue()).getFirst())), (Object)((Pair)((Ok)jsonResource).getValue()).getSecond());
            } else {
                if (jsonResource instanceof Err) {
                    throw (Throwable)((Err)jsonResource).getError();
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final Result<Pair<JsonElement, UrlPactSource>, Exception> fetchJsonResource(@NotNull CloseableHttpClient http, @NotNull UrlPactSource source) {
        Intrinsics.checkParameterIsNotNull((Object)http, (String)"http");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        url = new URL(source.getUrl());
        this_$iv = Result.Companion;
        $i$f$of = false;
        try {
            $i$a$-of-PactReaderKt$fetchJsonResource$1 = false;
            v0 = url.getProtocol();
            if (v0 == null) ** GOTO lbl-1000
            var6_6 = v0;
            switch (var6_6.hashCode()) {
                case 3143036: {
                    if (var6_6.equals("file")) {
                        var7_7 = new URL(source.getUrl());
                        var8_8 = new JsonParser();
                        var9_9 = Charsets.UTF_8;
                        var10_10 = false;
                        var11_12 = TextStreamsKt.readBytes((URL)var7_7);
                        var12_13 = false;
                        var13_14 = false;
                        var14_15 = new String(var11_12, var9_9);
                        v1 = TuplesKt.to((Object)var8_8.parse(var14_15), (Object)source);
                        break;
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    httpGet = new HttpGet(HttpClientUtils.INSTANCE.buildUrl("", source.getUrl(), true));
                    httpGet.addHeader("Content-Type", "application/json");
                    httpGet.addHeader("Accept", "application/hal+json, application/json");
                    v2 = response = http.execute((HttpUriRequest)httpGet);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"response");
                    v3 = v2.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"response.statusLine");
                    if (v3.getStatusCode() >= 300) ** GOTO lbl40
                    v4 = contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"contentType");
                    if (!HttpClientUtils.INSTANCE.isJsonResponse(v4)) ** GOTO lbl39
                    v1 = TuplesKt.to((Object)new JsonParser().parse(EntityUtils.toString((HttpEntity)response.getEntity())), (Object)source);
                    break;
lbl39:
                    // 1 sources

                    throw (Throwable)new InvalidHttpResponseException("Expected a JSON response, but got '" + contentType + '\'');
lbl40:
                    // 1 sources

                    v5 = response.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"response.statusLine");
                    switch (v5.getStatusCode()) {
                        case 404: {
                            throw (Throwable)new InvalidHttpResponseException("No JSON document found at source '" + source + '\'');
                        }
                    }
                    throw (Throwable)new InvalidHttpResponseException("Request to source '" + source + "' failed with response " + '\'' + response.getStatusLine() + '\'');
                }
            }
            var20_17 = var19_16 = v1;
            var15_18 = (Result)new Ok((Object)var20_17);
        }
        catch (Exception ex$iv) {
            var15_18 = (Result)new Err((Object)ex$iv);
        }
        return var15_18;
    }

    @NotNull
    public static final CloseableHttpClient newHttpClient(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        CustomServiceUnavailableRetryStrategy retryStrategy = new CustomServiceUnavailableRetryStrategy(5, 3000);
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties().setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)retryStrategy);
        if (options.get("authentication") instanceof List) {
            Object object = options.get("authentication");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            List authentication = (List)object;
            String string = String.valueOf(CollectionsKt.first((List)authentication));
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String scheme = string3;
            if (Intrinsics.areEqual((Object)scheme, (Object)"basic")) {
                if (authentication.size() > 2) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    URI uri = new URI(baseUrl);
                    credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(String.valueOf(authentication.get(1)), String.valueOf(authentication.get(2))));
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                } else {
                    logger.warn((Function0)newHttpClient.1.INSTANCE);
                }
            } else {
                logger.warn((Function0)new Function0<String>(scheme){
                    final /* synthetic */ String $scheme;

                    @NotNull
                    public final String invoke() {
                        return "Only supports basic authentication, got '" + this.$scheme + "', ignoring.";
                    }
                    {
                        this.$scheme = string;
                        super(0);
                    }
                });
            }
        } else if (options.containsKey("authentication")) {
            logger.warn((Function0)new Function0<String>(options){
                final /* synthetic */ Map $options;

                @NotNull
                public final String invoke() {
                    return "Authentication options needs to be a list of values, got '" + this.$options.get("authentication") + "', ignoring.";
                }
                {
                    this.$options = map;
                    super(0);
                }
            });
        }
        CloseableHttpClient closeableHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient, (String)"builder.build()");
        return closeableHttpClient;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final Map<String, List<String>> queryStringToMap(@Nullable String query, boolean decode) {
        Map map;
        CharSequence charSequence = query;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            map = MapsKt.emptyMap();
        } else {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            boolean bl3;
            String[] stringArray;
            String it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)query, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl4 = false;
                stringArray = (String[])it;
                bl3 = false;
                if (!(stringArray.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                stringArray = new String[]{"="};
                bl3 = false;
                int n = 2;
                List nv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)bl3, (int)n, (int)2, null);
                Pair pair = TuplesKt.to(nv.get(0), nv.get(1));
                collection.add(pair);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            Map initial$iv = new LinkedHashMap();
            boolean $i$f$fold = false;
            Map accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                String value;
                void nameAndValue;
                Object item$iv$iv;
                item$iv$iv = (Pair)element$iv;
                Map map2 = accumulator$iv;
                boolean bl6 = false;
                String name = decode ? URLDecoder.decode((String)nameAndValue.getFirst(), "UTF-8") : (String)nameAndValue.getFirst();
                String string = value = decode ? URLDecoder.decode((String)nameAndValue.getSecond(), "UTF-8") : (String)nameAndValue.getSecond();
                if (map2.containsKey(name)) {
                    Object v = map2.get(name);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    List list = (List)v;
                    String string2 = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value");
                    list.add(string2);
                } else {
                    String string3 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name");
                    Object[] objectArray = new String[1];
                    String string4 = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"value");
                    objectArray[0] = string4;
                    map2.put(string3, CollectionsKt.mutableListOf((Object[])objectArray));
                }
                accumulator$iv = map2;
            }
            map = accumulator$iv;
        }
        return map;
    }

    public static /* synthetic */ Map queryStringToMap$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return PactReaderKt.queryStringToMap(string, bl);
    }

    @JvmOverloads
    @NotNull
    public static final Map<String, List<String>> queryStringToMap(@Nullable String query) {
        return PactReaderKt.queryStringToMap$default(query, false, 2, null);
    }
}

