/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.InvalidPathExpression;
import au.com.dius.pact.core.model.PathToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.iterators.PushbackIterator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u001a8\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a8\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0001\u001a>\u0010\u0011\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\f\u001a\u00020\u0001\u001a0\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0001\u001a8\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a8\u0010\u0016\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"EXP_ALLOWED_SPECIAL_CHARS", "", "PATH_SPECIAL_CHARS", "bracketPath", "", "chars", "Lorg/apache/commons/collections4/iterators/PushbackIterator;", "Lkotlin/collections/IndexedValue;", "", "tokens", "", "Lau/com/dius/pact/core/model/PathToken;", "path", "index", "", "identifier", "ch", "indexPath", "parsePath", "", "pathExp", "pathIdentifier", "stringPath", "pact-jvm-core-model"})
public final class PathExpressionsKt {
    @NotNull
    public static final String PATH_SPECIAL_CHARS = "'[].@ \t\n";
    @NotNull
    public static final String EXP_ALLOWED_SPECIAL_CHARS = "-_:";

    public static final void stringPath(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path, int index) {
        Intrinsics.checkParameterIsNotNull(chars, (String)"chars");
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String id = new String();
        IndexedValue c = new IndexedValue(index, (Object)Character.valueOf(' '));
        while (((Character)c.getValue()).charValue() != '\'' && chars.hasNext()) {
            Object object = chars.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"chars.next()");
            c = (IndexedValue)object;
            if (((Character)c.getValue()).charValue() == '\'') {
                CharSequence charSequence = id;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break;
                throw (Throwable)new InvalidPathExpression("Empty strings are not allowed in path expression \"" + path + "\" at index " + c.getIndex());
            }
            id = id + ((Character)c.getValue()).charValue();
        }
        if (((Character)c.getValue()).charValue() != '\'') {
            throw (Throwable)new InvalidPathExpression("Unterminated string in path expression \"" + path + "\" at index " + c.getIndex());
        }
        tokens.add(new PathToken.Field(id));
    }

    public static final void indexPath(@NotNull IndexedValue<Character> ch, @NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path) {
        int n;
        char c;
        Intrinsics.checkParameterIsNotNull(ch, (String)"ch");
        Intrinsics.checkParameterIsNotNull(chars, (String)"chars");
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String id = new String() + ((Character)ch.getValue()).charValue();
        while (chars.hasNext()) {
            IndexedValue c2 = (IndexedValue)chars.next();
            c = ((Character)c2.getValue()).charValue();
            boolean bl = false;
            if (Character.isDigit(c)) {
                id = id + ((Character)c2.getValue()).charValue();
                continue;
            }
            if (((Character)c2.getValue()).charValue() == ']') {
                chars.pushback((Object)c2);
                break;
            }
            throw (Throwable)new InvalidPathExpression("Indexes can only consist of numbers or a \"*\", found \"" + ((Character)c2.getValue()).charValue() + "\" " + "instead in path expression \"" + path + "\" at index " + c2.getIndex());
        }
        String string = id;
        List<PathToken> list = tokens;
        c = '\u0000';
        int n2 = n = Integer.parseInt(string);
        list.add(new PathToken.Index(n2));
    }

    public static final void identifier(char ch, @NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(chars, (String)"chars");
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String id = new String() + ch;
        while (chars.hasNext()) {
            IndexedValue c = (IndexedValue)chars.next();
            char c2 = ((Character)c.getValue()).charValue();
            boolean bl = false;
            if (Character.isLetterOrDigit(c2) || StringsKt.contains$default((CharSequence)EXP_ALLOWED_SPECIAL_CHARS, (char)((Character)c.getValue()).charValue(), (boolean)false, (int)2, null)) {
                id = id + ((Character)c.getValue()).charValue();
                continue;
            }
            if (((Character)c.getValue()).charValue() == '.' || ((Character)c.getValue()).charValue() == '\'' || ((Character)c.getValue()).charValue() == '[') {
                chars.pushback((Object)c);
                break;
            }
            throw (Throwable)new InvalidPathExpression("" + '\"' + ((Character)c.getValue()).charValue() + "\" is not allowed in an identifier in path expression \"" + path + '\"' + " at index " + c.getIndex());
        }
        tokens.add(new PathToken.Field(id));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void pathIdentifier(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path, int index) {
        Intrinsics.checkParameterIsNotNull(chars, (String)"chars");
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!chars.hasNext()) throw (Throwable)new InvalidPathExpression("Expected a path after \".\" in path expression \"" + path + "\" at index " + index);
        IndexedValue ch = (IndexedValue)chars.next();
        if (((Character)ch.getValue()).charValue() == '*') {
            tokens.add(PathToken.Star.INSTANCE);
            return;
        } else {
            char c = ((Character)ch.getValue()).charValue();
            boolean bl = false;
            if (!Character.isLetterOrDigit(c) && ((Character)ch.getValue()).charValue() != '_') throw (Throwable)new InvalidPathExpression("Expected either a \"*\" or path identifier in path expression \"" + path + '\"' + " at index " + ch.getIndex());
            PathExpressionsKt.identifier(((Character)ch.getValue()).charValue(), chars, tokens, path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void bracketPath(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path, int index) {
        Intrinsics.checkParameterIsNotNull(chars, (String)"chars");
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (!chars.hasNext()) throw (Throwable)new InvalidPathExpression("Expected a \"'\" (single quote) or a digit in path expression \"" + path + '\"' + " after index " + index);
        IndexedValue ch = (IndexedValue)chars.next();
        if (((Character)ch.getValue()).charValue() == '\'') {
            PathExpressionsKt.stringPath(chars, tokens, path, ch.getIndex());
        } else {
            char c = ((Character)ch.getValue()).charValue();
            boolean bl = false;
            if (Character.isDigit(c)) {
                IndexedValue indexedValue = ch;
                Intrinsics.checkExpressionValueIsNotNull((Object)indexedValue, (String)"ch");
                PathExpressionsKt.indexPath((IndexedValue<Character>)indexedValue, chars, tokens, path);
            } else if (((Character)ch.getValue()).charValue() == '*') {
                tokens.add(PathToken.StarIndex.INSTANCE);
            } else {
                if (((Character)ch.getValue()).charValue() != ']') throw (Throwable)new InvalidPathExpression("Indexes can only consist of numbers or a \"*\", found \"" + ((Character)ch.getValue()).charValue() + "\" " + "instead in path expression \"" + path + "\" at index " + ch.getIndex());
                throw (Throwable)new InvalidPathExpression("Empty bracket expressions are not allowed in path expression " + '\"' + path + "\" at index " + ch.getIndex());
            }
        }
        if (!chars.hasNext()) throw (Throwable)new InvalidPathExpression("Unterminated brackets in path expression \"" + path + "\" at index " + ch.getIndex());
        IndexedValue c = (IndexedValue)chars.next();
        if (((Character)c.getValue()).charValue() == ']') return;
        throw (Throwable)new InvalidPathExpression("Unterminated brackets, found \"" + ((Character)c.getValue()).charValue() + "\" instead of \"]\" " + "in path expression \"" + path + "\" at index " + c.getIndex());
    }

    public static final void pathExp(@NotNull PushbackIterator<IndexedValue<Character>> chars, @NotNull List<PathToken> tokens, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(chars, (String)"chars");
        Intrinsics.checkParameterIsNotNull(tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        block4: while (chars.hasNext()) {
            IndexedValue next = (IndexedValue)chars.next();
            switch (((Character)next.getValue()).charValue()) {
                case '.': {
                    PathExpressionsKt.pathIdentifier(chars, tokens, path, next.getIndex());
                    continue block4;
                }
                case '[': {
                    PathExpressionsKt.bracketPath(chars, tokens, path, next.getIndex());
                    continue block4;
                }
            }
            throw (Throwable)new InvalidPathExpression("Expected a \".\" or \"[\" instead of \"" + ((Character)next.getValue()).charValue() + "\" in path expression " + '\"' + path + "\" at index " + next.getIndex());
        }
    }

    @NotNull
    public static final List<PathToken> parsePath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ArrayList<PathToken.Root> tokens = new ArrayList<PathToken.Root>();
        PushbackIterator chars = new PushbackIterator(CollectionsKt.withIndex((Iterator)((Iterator)StringsKt.iterator((CharSequence)path))));
        if (chars.hasNext()) {
            IndexedValue ch = (IndexedValue)chars.next();
            if (((Character)ch.getValue()).charValue() == '$') {
                tokens.add(PathToken.Root.INSTANCE);
                PathExpressionsKt.pathExp((PushbackIterator<IndexedValue<Character>>)chars, (List<PathToken>)tokens, path);
            } else {
                throw (Throwable)new InvalidPathExpression("Path expression \"" + path + "\" does not start with a root marker \"$\"");
            }
        }
        return tokens;
    }
}

