/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.InvalidMatcherException;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonBody;
import au.com.dius.pact.consumer.dsl.PactDslJsonRootValue;
import au.com.dius.pact.consumer.dsl.UrlMatcherSupport;
import au.com.dius.pact.model.generators.Category;
import au.com.dius.pact.model.generators.DateGenerator;
import au.com.dius.pact.model.generators.DateTimeGenerator;
import au.com.dius.pact.model.generators.Generator;
import au.com.dius.pact.model.generators.ProviderStateGenerator;
import au.com.dius.pact.model.generators.RandomBooleanGenerator;
import au.com.dius.pact.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.model.generators.RandomHexadecimalGenerator;
import au.com.dius.pact.model.generators.RandomIntGenerator;
import au.com.dius.pact.model.generators.RandomStringGenerator;
import au.com.dius.pact.model.generators.TimeGenerator;
import au.com.dius.pact.model.generators.UuidGenerator;
import au.com.dius.pact.model.matchingrules.EqualsMatcher;
import au.com.dius.pact.model.matchingrules.MatchingRule;
import au.com.dius.pact.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.model.matchingrules.RuleLogic;
import au.com.dius.pact.model.matchingrules.TypeMatcher;
import com.mifmif.common.regex.Generex;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class PactDslJsonArray
extends DslPart {
    private static final String EXAMPLE = "Example \"";
    private final JSONArray body;
    private boolean wildCard;
    private int numberExamples = 1;

    public PactDslJsonArray() {
        this("", "", null, false);
    }

    public PactDslJsonArray(String rootPath, String rootName, DslPart parent) {
        this(rootPath, rootName, parent, false);
    }

    public PactDslJsonArray(String rootPath, String rootName, DslPart parent, PactDslJsonArray array) {
        super(parent, rootPath, rootName);
        this.body = array.body;
        this.wildCard = array.wildCard;
        this.matchers = array.matchers.copyWithUpdatedMatcherRootPrefix(rootPath);
        this.generators = array.generators;
    }

    public PactDslJsonArray(String rootPath, String rootName, DslPart parent, boolean wildCard) {
        super(parent, rootPath, rootName);
        this.wildCard = wildCard;
        this.body = new JSONArray();
    }

    @Override
    public DslPart closeArray() {
        if (this.parent != null) {
            this.parent.putArray(this);
        } else {
            this.getMatchers().applyMatcherRootPrefix("$");
            this.getGenerators().applyRootPrefix("$");
        }
        this.closed = true;
        return this.parent;
    }

    @Override
    @Deprecated
    public PactDslJsonBody arrayLike(String name) {
        throw new UnsupportedOperationException("use the eachLike() form");
    }

    @Override
    @Deprecated
    public PactDslJsonBody arrayLike() {
        return this.eachLike();
    }

    @Override
    public PactDslJsonBody eachLike(String name) {
        throw new UnsupportedOperationException("use the eachLike() form");
    }

    @Override
    public PactDslJsonBody eachLike(String name, int numberExamples) {
        throw new UnsupportedOperationException("use the eachLike(numberExamples) form");
    }

    @Override
    public PactDslJsonBody eachLike() {
        return this.eachLike(1);
    }

    @Override
    public PactDslJsonBody eachLike(int numberExamples) {
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the minArrayLike(Integer size) form");
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size) {
        return this.minArrayLike(size, (int)size);
    }

    @Override
    public PactDslJsonBody minArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException("use the minArrayLike(Integer size, int numberExamples) form");
    }

    @Override
    public PactDslJsonBody minArrayLike(Integer size, int numberExamples) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray("", "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the maxArrayLike(Integer size) form");
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size) {
        return this.maxArrayLike(size, 1);
    }

    @Override
    public PactDslJsonBody maxArrayLike(String name, Integer size, int numberExamples) {
        throw new UnsupportedOperationException("use the maxArrayLike(Integer size, int numberExamples) form");
    }

    @Override
    public PactDslJsonBody maxArrayLike(Integer size, int numberExamples) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray("", "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    protected void putObject(DslPart object) {
        for (String matcherName : object.matchers.getMatchingRules().keySet()) {
            this.matchers.setRules(this.rootPath + this.appendArrayIndex(1) + matcherName, (MatchingRuleGroup)object.matchers.getMatchingRules().get(matcherName));
        }
        this.generators.addGenerators(object.generators, this.rootPath + this.appendArrayIndex(1));
        for (int i = 0; i < this.getNumberExamples(); ++i) {
            this.body.put(object.getBody());
        }
    }

    @Override
    protected void putArray(DslPart object) {
        for (String matcherName : object.matchers.getMatchingRules().keySet()) {
            this.matchers.setRules(this.rootPath + this.appendArrayIndex(1) + matcherName, (MatchingRuleGroup)object.matchers.getMatchingRules().get(matcherName));
        }
        this.generators.addGenerators(object.generators, this.rootPath + this.appendArrayIndex(1));
        for (int i = 0; i < this.getNumberExamples(); ++i) {
            this.body.put(object.getBody());
        }
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    public PactDslJsonArray stringValue(String value) {
        if (value == null) {
            this.body.put(JSONObject.NULL);
        } else {
            this.body.put((Object)value);
        }
        return this;
    }

    public PactDslJsonArray string(String value) {
        return this.stringValue(value);
    }

    public PactDslJsonArray numberValue(Number value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray number(Number value) {
        return this.numberValue(value);
    }

    public PactDslJsonArray booleanValue(Boolean value) {
        this.body.put((Object)value);
        return this;
    }

    public PactDslJsonArray stringType() {
        this.body.put((Object)"string");
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new RandomStringGenerator(20));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonArray stringType(String example) {
        this.body.put((Object)example);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonArray numberType() {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(1), (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        return this.numberType(100);
    }

    public PactDslJsonArray numberType(Number number) {
        this.body.put((Object)number);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.NUMBER));
        return this;
    }

    public PactDslJsonArray integerType() {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(1), (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        return this.integerType(100L);
    }

    public PactDslJsonArray integerType(Long number) {
        this.body.put((Object)number);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.INTEGER));
        return this;
    }

    @Deprecated
    public PactDslJsonArray realType() {
        return this.decimalType();
    }

    @Deprecated
    public PactDslJsonArray realType(Double number) {
        return this.decimalType(number);
    }

    public PactDslJsonArray decimalType() {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(1), (Generator)new RandomDecimalGenerator(10));
        return this.decimalType(new BigDecimal("100"));
    }

    public PactDslJsonArray decimalType(BigDecimal number) {
        this.body.put((Object)number);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return this;
    }

    public PactDslJsonArray decimalType(Double number) {
        this.body.put((Object)number);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)new NumberTypeMatcher(NumberTypeMatcher.NumberType.DECIMAL));
        return this;
    }

    public PactDslJsonArray booleanType() {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(1), (Generator)RandomBooleanGenerator.INSTANCE);
        this.body.put(true);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonArray booleanType(Boolean example) {
        this.body.put((Object)example);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonArray stringMatcher(String regex, String value) {
        if (!value.matches(regex)) {
            throw new InvalidMatcherException(EXAMPLE + value + "\" does not match regular expression \"" + regex + "\"");
        }
        this.body.put((Object)value);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.regexp(regex));
        return this;
    }

    @Deprecated
    public PactDslJsonArray stringMatcher(String regex) {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(1), (Generator)new RandomStringGenerator(10));
        this.stringMatcher(regex, new Generex(regex).random());
        return this;
    }

    public PactDslJsonArray timestamp() {
        String pattern = DateFormatUtils.ISO_DATETIME_FORMAT.getPattern();
        this.body.put((Object)DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date(949323600000L)));
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new DateTimeGenerator(pattern));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchTimestamp(pattern));
        return this;
    }

    public PactDslJsonArray timestamp(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date(949323600000L)));
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new DateTimeGenerator(format));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonArray timestamp(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(example));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchTimestamp(format));
        return this;
    }

    public PactDslJsonArray date() {
        String pattern = DateFormatUtils.ISO_DATE_FORMAT.getPattern();
        this.body.put((Object)DateFormatUtils.ISO_DATE_FORMAT.format(new Date(949323600000L)));
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new DateGenerator(pattern));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchDate(pattern));
        return this;
    }

    public PactDslJsonArray date(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date(949323600000L)));
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new DateTimeGenerator(format));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchDate(format));
        return this;
    }

    public PactDslJsonArray date(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(example));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchDate(format));
        return this;
    }

    public PactDslJsonArray time() {
        String pattern = DateFormatUtils.ISO_TIME_FORMAT.getPattern();
        this.body.put((Object)DateFormatUtils.ISO_TIME_FORMAT.format(new Date(949323600000L)));
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new TimeGenerator(pattern));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchTime(pattern));
        return this;
    }

    public PactDslJsonArray time(String format) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(new Date(949323600000L)));
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new TimeGenerator(format));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchTime(format));
        return this;
    }

    public PactDslJsonArray time(String format, Date example) {
        FastDateFormat instance = FastDateFormat.getInstance((String)format);
        this.body.put((Object)instance.format(example));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.matchTime(format));
        return this;
    }

    public PactDslJsonArray ipAddress() {
        this.body.put((Object)"127.0.0.1");
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.regexp("(\\d{1,3}\\.)+\\d{1,3}"));
        return this;
    }

    @Override
    public PactDslJsonBody object(String name) {
        throw new UnsupportedOperationException("use the object() form");
    }

    @Override
    public PactDslJsonBody object() {
        return new PactDslJsonBody(".", "", this);
    }

    @Override
    public DslPart closeObject() {
        throw new UnsupportedOperationException("can't call closeObject on an Array");
    }

    @Override
    public DslPart close() {
        DslPart parentToReturn = this;
        if (!this.closed) {
            DslPart parent = this.closeArray();
            while (parent != null) {
                parentToReturn = parent;
                if (parent instanceof PactDslJsonArray) {
                    parent = parent.closeArray();
                    continue;
                }
                parent = parent.closeObject();
            }
        }
        return parentToReturn;
    }

    @Override
    public PactDslJsonArray array(String name) {
        throw new UnsupportedOperationException("use the array() form");
    }

    @Override
    public PactDslJsonArray array() {
        return new PactDslJsonArray("", "", this);
    }

    public PactDslJsonArray id() {
        this.body.put(100L);
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new RandomIntGenerator(0, Integer.MAX_VALUE));
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonArray id(Long id) {
        this.body.put((Object)id);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)TypeMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonArray hexValue() {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(1), (Generator)new RandomHexadecimalGenerator(10));
        return this.hexValue("1234a");
    }

    public PactDslJsonArray hexValue(String hexValue) {
        if (!hexValue.matches("[0-9a-fA-F]+")) {
            throw new InvalidMatcherException(EXAMPLE + hexValue + "\" is not a hexadecimal value");
        }
        this.body.put((Object)hexValue);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.regexp("[0-9a-fA-F]+"));
        return this;
    }

    @Deprecated
    public PactDslJsonArray guid() {
        return this.uuid();
    }

    @Deprecated
    public PactDslJsonArray guid(String uuid) {
        return this.uuid(uuid);
    }

    public PactDslJsonArray uuid() {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(1), (Generator)UuidGenerator.INSTANCE);
        return this.uuid("e2490de5-5bd3-43d5-b7c4-526e33f71304");
    }

    public PactDslJsonArray uuid(String uuid) {
        if (!uuid.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")) {
            throw new InvalidMatcherException(EXAMPLE + uuid + "\" is not an UUID");
        }
        this.body.put((Object)uuid);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.regexp("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}"));
        return this;
    }

    public PactDslJsonArray template(DslPart template) {
        this.putObject(template);
        return this;
    }

    public PactDslJsonArray template(DslPart template, int occurrences) {
        for (int i = 0; i < occurrences; ++i) {
            this.template(template);
        }
        return this;
    }

    public String toString() {
        return this.body.toString();
    }

    private String appendArrayIndex(Integer offset) {
        String index = "*";
        if (!this.wildCard) {
            index = String.valueOf(this.body.length() - 1 + offset);
        }
        return "[" + index + "]";
    }

    public static PactDslJsonBody arrayEachLike() {
        return PactDslJsonArray.arrayEachLike(1);
    }

    public static PactDslJsonBody arrayEachLike(Integer numberExamples) {
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMin(0));
        return new PactDslJsonBody(".", "", parent);
    }

    public static PactDslJsonArray arrayEachLike(PactDslJsonRootValue rootValue) {
        return PactDslJsonArray.arrayEachLike(1, rootValue);
    }

    public static PactDslJsonArray arrayEachLike(Integer numberExamples, PactDslJsonRootValue value) {
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMin(0));
        parent.putObject(value);
        return parent;
    }

    public static PactDslJsonBody arrayMinLike(int minSize) {
        return PactDslJsonArray.arrayMinLike(minSize, minSize);
    }

    public static PactDslJsonBody arrayMinLike(int minSize, int numberExamples) {
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMin(minSize));
        return new PactDslJsonBody(".", "", parent);
    }

    public static PactDslJsonArray arrayMinLike(int minSize, PactDslJsonRootValue value) {
        return PactDslJsonArray.arrayMinLike(minSize, minSize, value);
    }

    public static PactDslJsonArray arrayMinLike(int minSize, int numberExamples, PactDslJsonRootValue value) {
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMin(minSize));
        parent.putObject(value);
        return parent;
    }

    public static PactDslJsonBody arrayMaxLike(int maxSize) {
        return PactDslJsonArray.arrayMaxLike(maxSize, 1);
    }

    public static PactDslJsonBody arrayMaxLike(int maxSize, int numberExamples) {
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMax(maxSize));
        return new PactDslJsonBody(".", "", parent);
    }

    public static PactDslJsonArray arrayMaxLike(int maxSize, PactDslJsonRootValue value) {
        return PactDslJsonArray.arrayMaxLike(maxSize, 1, value);
    }

    public static PactDslJsonArray arrayMaxLike(int maxSize, int numberExamples, PactDslJsonRootValue value) {
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMax(maxSize));
        parent.putObject(value);
        return parent;
    }

    public static PactDslJsonBody arrayMinMaxLike(int minSize, int maxSize) {
        return PactDslJsonArray.arrayMinMaxLike(minSize, maxSize, minSize);
    }

    public static PactDslJsonBody arrayMinMaxLike(int minSize, int maxSize, int numberExamples) {
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMinMax(minSize, maxSize));
        return new PactDslJsonBody(".", "", parent);
    }

    public static PactDslJsonArray arrayMinMaxLike(int minSize, int maxSize, PactDslJsonRootValue value) {
        return PactDslJsonArray.arrayMinMaxLike(minSize, maxSize, minSize, value);
    }

    public static PactDslJsonArray arrayMinMaxLike(int minSize, int maxSize, int numberExamples, PactDslJsonRootValue value) {
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
        PactDslJsonArray parent = new PactDslJsonArray("", "", null, true);
        parent.setNumberExamples(numberExamples);
        parent.matchers.addRule("", (MatchingRule)parent.matchMinMax(minSize, maxSize));
        parent.putObject(value);
        return parent;
    }

    public PactDslJsonArray nullValue() {
        this.body.put(JSONObject.NULL);
        return this;
    }

    public int getNumberExamples() {
        return this.numberExamples;
    }

    public void setNumberExamples(int numberExamples) {
        this.numberExamples = numberExamples;
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name) {
        throw new UnsupportedOperationException("use the eachArrayLike() form");
    }

    @Override
    public PactDslJsonArray eachArrayLike(String name, int numberExamples) {
        throw new UnsupportedOperationException("use the eachArrayLike(numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayLike() {
        return this.eachArrayLike(1);
    }

    @Override
    public PactDslJsonArray eachArrayLike(int numberExamples) {
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMaxLike() form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMaxLike(numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(Integer size) {
        return this.eachArrayWithMaxLike(1, size);
    }

    @Override
    public PactDslJsonArray eachArrayWithMaxLike(int numberExamples, Integer size) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMinLike() form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(String name, int numberExamples, Integer size) {
        throw new UnsupportedOperationException("use the eachArrayWithMinLike(numberExamples) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(Integer size) {
        return this.eachArrayWithMinLike(size, size);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinLike(int numberExamples, Integer size) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    public PactDslJsonArray eachLike(PactDslJsonRootValue value) {
        return this.eachLike(value, 1);
    }

    public PactDslJsonArray eachLike(PactDslJsonRootValue value, int numberExamples) {
        if (numberExamples == 0) {
            throw new IllegalArgumentException("Testing Zero examples is unsafe. Please make sure to provide at least one example in the Pact provider implementation. See https://github.com/DiUS/pact-jvm/issues/546");
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMin(0));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonArray)parent.closeArray();
    }

    public PactDslJsonArray minArrayLike(Integer size, PactDslJsonRootValue value) {
        return this.minArrayLike(size, value, (int)size);
    }

    public PactDslJsonArray minArrayLike(Integer size, PactDslJsonRootValue value, int numberExamples) {
        if (numberExamples < size) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMin(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonArray)parent.closeArray();
    }

    public PactDslJsonArray maxArrayLike(Integer size, PactDslJsonRootValue value) {
        return this.maxArrayLike(size, value, 1);
    }

    public PactDslJsonArray maxArrayLike(Integer size, PactDslJsonRootValue value, int numberExamples) {
        if (numberExamples > size) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, size));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMax(size));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        parent.putObject(value);
        return (PactDslJsonArray)parent.closeArray();
    }

    public PactDslJsonArray includesStr(String value) {
        this.body.put((Object)value);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.includesMatcher(value));
        return this;
    }

    public PactDslJsonArray equalsTo(Object value) {
        this.body.put(value);
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)EqualsMatcher.INSTANCE);
        return this;
    }

    public PactDslJsonArray and(Object value, MatchingRule ... rules) {
        if (value != null) {
            this.body.put(value);
        } else {
            this.body.put(JSONObject.NULL);
        }
        this.matchers.setRules(this.rootPath + this.appendArrayIndex(0), new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.AND));
        return this;
    }

    public PactDslJsonArray or(Object value, MatchingRule ... rules) {
        if (value != null) {
            this.body.put(value);
        } else {
            this.body.put(JSONObject.NULL);
        }
        this.matchers.setRules(this.rootPath + this.appendArrayIndex(0), new MatchingRuleGroup(Arrays.asList(rules), RuleLogic.OR));
        return this;
    }

    public PactDslJsonArray matchUrl(String basePath, Object ... pathFragments) {
        UrlMatcherSupport urlMatcher = new UrlMatcherSupport(basePath, Arrays.asList(pathFragments));
        this.body.put((Object)urlMatcher.getExampleValue());
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(0), (MatchingRule)this.regexp(urlMatcher.getRegexExpression()));
        return this;
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException("use the minMaxArrayLike(minSize, maxSize) form");
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize) {
        return this.minMaxArrayLike(minSize, maxSize, (int)minSize);
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(String name, Integer minSize, Integer maxSize, int numberExamples) {
        throw new UnsupportedOperationException("use the minMaxArrayLike(minSize, maxSize, numberExamples) form");
    }

    @Override
    public PactDslJsonBody minMaxArrayLike(Integer minSize, Integer maxSize, int numberExamples) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException(String.format("The minimum size of %d is greater than the maximum of %d", minSize, maxSize));
        }
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMinMax(minSize, maxSize));
        PactDslJsonArray parent = new PactDslJsonArray("", "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonBody(".", "", parent);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException("use the eachArrayWithMinMaxLike(minSize, maxSize) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(Integer minSize, Integer maxSize) {
        return this.eachArrayWithMinMaxLike(minSize, minSize, maxSize);
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(String name, int numberExamples, Integer minSize, Integer maxSize) {
        throw new UnsupportedOperationException("use the eachArrayWithMinMaxLike(numberExamples, minSize, maxSize) form");
    }

    @Override
    public PactDslJsonArray eachArrayWithMinMaxLike(int numberExamples, Integer minSize, Integer maxSize) {
        if (minSize > maxSize) {
            throw new IllegalArgumentException(String.format("The minimum size of %d is greater than the maximum of %d", minSize, maxSize));
        }
        if (numberExamples < minSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is less than the minimum size of %d", numberExamples, minSize));
        }
        if (numberExamples > maxSize) {
            throw new IllegalArgumentException(String.format("Number of example %d is more than the maximum size of %d", numberExamples, maxSize));
        }
        this.matchers.addRule(this.rootPath + this.appendArrayIndex(1), (MatchingRule)this.matchMinMax(minSize, maxSize));
        PactDslJsonArray parent = new PactDslJsonArray(this.rootPath, "", (DslPart)this, true);
        parent.setNumberExamples(numberExamples);
        return new PactDslJsonArray("", "", parent);
    }

    public PactDslJsonArray valueFromProviderState(String expression, Object example) {
        this.generators.addGenerator(Category.BODY, this.rootPath + this.appendArrayIndex(0), (Generator)new ProviderStateGenerator(expression));
        this.body.put(example);
        return this;
    }
}

